/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuildingWorker;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.client.gui.WindowHutStoneSmelter;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingSmelterCrafter;
import com.minecolonies.coremod.colony.jobs.JobStoneSmeltery;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGlazedTerracotta;
import net.minecraft.block.BlockHardenedClay;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class BuildingStoneSmeltery
extends AbstractBuildingSmelterCrafter {
    private static final String STONE_SMELTERY = "StoneSmeltery";

    public BuildingStoneSmeltery(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return STONE_SMELTERY;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public IJob createJob(ICitizenData citizen) {
        return new JobStoneSmeltery(citizen);
    }

    @Override
    @NotNull
    public String getJobName() {
        return STONE_SMELTERY;
    }

    @Override
    public boolean canRecipeBeAdded(IToken token) {
        if (!super.canRecipeBeAdded(token)) {
            return false;
        }
        IRecipeStorage storage = (IRecipeStorage)IColonyManager.getInstance().getRecipeManager().getRecipes().get((Object)token);
        if (storage == null) {
            return false;
        }
        if (storage.getIntermediate() != Blocks.field_150460_al || storage.getInput().isEmpty()) {
            return false;
        }
        return this.isBlockForThisSmelter(storage.getPrimaryOutput()) && FurnaceRecipes.func_77602_a().func_151395_a(storage.getInput().get(0)).func_77969_a(storage.getPrimaryOutput());
    }

    public boolean isBlockForThisSmelter(ItemStack stack) {
        Block block;
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock && ((block = ((ItemBlock)item).func_179223_d()) == Blocks.field_150348_b || block == Blocks.field_150417_aV || block instanceof BlockGlazedTerracotta || block instanceof BlockHardenedClay || block instanceof BlockStoneBrick)) {
            return true;
        }
        return item == Items.field_151118_aC || item == Items.field_151044_h;
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.stoneSmelter;
    }

    public static class View
    extends AbstractBuildingSmelterCrafter.View {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutStoneSmelter(this);
        }

        @Override
        @NotNull
        public IBuildingWorker.Skill getPrimarySkill() {
            return IBuildingWorker.Skill.DEXTERITY;
        }

        @Override
        @NotNull
        public IBuildingWorker.Skill getSecondarySkill() {
            return IBuildingWorker.Skill.ENDURANCE;
        }
    }
}

