/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.views;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.data.IRequestSystemBuildingDataStore;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.ReflectionUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.blockout.Log;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.requestsystem.locations.StaticLocation;
import com.minecolonies.coremod.network.messages.HutRenameMessage;
import com.minecolonies.coremod.network.messages.OpenInventoryMessage;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBuildingView
implements IBuildingView {
    private final IColonyView colony;
    @NotNull
    private final BlockPos location;
    private int buildingLevel = 0;
    private int buildingMaxLevel = 0;
    private int buildingDmPrio = 1;
    private boolean buildingDmPrioState = false;
    private int rotation;
    private boolean isBuildingMirrored;
    private int workOrderLevel = 0;
    private ImmutableCollection<IToken<?>> resolvers;
    private IToken<?> requesterId;
    @NotNull
    private IToken<?> rsDataStoreToken;
    private String schematicName;
    private String style;
    private String customName = "";
    private int claimRadius = 0;

    protected AbstractBuildingView(IColonyView c, @NotNull BlockPos l) {
        this.colony = c;
        this.location = new BlockPos((Vec3i)l);
    }

    @Override
    @NotNull
    public BlockPos getID() {
        return this.location;
    }

    @Override
    @NotNull
    public BlockPos getPosition() {
        return this.location;
    }

    @Override
    public int getBuildingLevel() {
        return this.buildingLevel;
    }

    @Override
    public int getBuildingMaxLevel() {
        return this.buildingMaxLevel;
    }

    @Override
    public boolean isBuildingMaxLevel() {
        return this.buildingLevel >= this.buildingMaxLevel;
    }

    @Override
    public int getCurrentWorkOrderLevel() {
        return this.workOrderLevel;
    }

    @Override
    public String getSchematicName() {
        return this.schematicName;
    }

    @Override
    public String getCustomName() {
        return this.customName;
    }

    @Override
    public String getStyle() {
        return this.style;
    }

    @Override
    public int getRotation() {
        return this.rotation;
    }

    @Override
    public boolean isMirrored() {
        return this.isBuildingMirrored;
    }

    @Override
    public boolean hasWorkOrder() {
        return this.workOrderLevel != 0;
    }

    @Override
    public boolean isBuilding() {
        return this.workOrderLevel != 0 && this.workOrderLevel > this.buildingLevel;
    }

    @Override
    public boolean isRepairing() {
        return this.workOrderLevel != 0 && this.workOrderLevel == this.buildingLevel;
    }

    @Override
    public int getClaimRadius() {
        return this.claimRadius;
    }

    @Override
    public void openGui(boolean shouldOpenInv) {
        if (shouldOpenInv) {
            MineColonies.getNetwork().sendToServer((IMessage)new OpenInventoryMessage(this.getID()));
        } else {
            Window window = this.getWindow();
            if (window != null) {
                window.open();
            }
        }
    }

    @Override
    @Nullable
    public Window getWindow() {
        return null;
    }

    @Override
    public void deserialize(@NotNull ByteBuf buf) {
        this.buildingLevel = buf.readInt();
        this.buildingMaxLevel = buf.readInt();
        this.buildingDmPrio = buf.readInt();
        this.buildingDmPrioState = buf.readBoolean();
        this.workOrderLevel = buf.readInt();
        this.style = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.schematicName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.customName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.rotation = buf.readInt();
        this.isBuildingMirrored = buf.readBoolean();
        this.claimRadius = buf.readInt();
        ArrayList list = new ArrayList();
        int resolverSize = buf.readInt();
        for (int i = 0; i < resolverSize; ++i) {
            NBTTagCompound compound = ByteBufUtils.readTag((ByteBuf)buf);
            if (compound == null) continue;
            list.add(StandardFactoryController.getInstance().deserialize(compound));
        }
        this.resolvers = ImmutableList.copyOf(list);
        NBTTagCompound compound = ByteBufUtils.readTag((ByteBuf)buf);
        if (compound != null) {
            this.requesterId = (IToken)StandardFactoryController.getInstance().deserialize(compound);
        }
        this.loadRequestSystemFromNBT(ByteBufUtils.readTag((ByteBuf)buf));
    }

    private void loadRequestSystemFromNBT(NBTTagCompound compound) {
        this.rsDataStoreToken = (IToken)StandardFactoryController.getInstance().deserialize(compound.func_74775_l("DataStoreToken"));
    }

    private IRequestSystemBuildingDataStore getDataStore() {
        return this.colony.getRequestManager().getDataStoreManager().get(this.rsDataStoreToken, TypeConstants.REQUEST_SYSTEM_BUILDING_DATA_STORE);
    }

    @Override
    public Map<Integer, Collection<IToken<?>>> getOpenRequestsByCitizen() {
        return this.getDataStore().getOpenRequestsByCitizen();
    }

    private Map<IToken<?>, Integer> getCitizensByRequest() {
        return this.getDataStore().getCitizensByRequest();
    }

    @Override
    public <R> ImmutableList<IRequest<? extends R>> getOpenRequestsOfType(@NotNull ICitizenDataView citizenData, Class<R> requestType) {
        return ImmutableList.copyOf(this.getOpenRequests(citizenData).stream().filter(request -> {
            Set<TypeToken> requestTypes = ReflectionUtils.getSuperClasses(request.getType());
            return requestTypes.contains(TypeToken.of((Class)requestType));
        }).map(request -> request).iterator());
    }

    @Override
    public ImmutableList<IRequest> getOpenRequests(@NotNull ICitizenDataView data) {
        if (data == null || this.getColony() == null || this.getColony().getRequestManager() == null) {
            return ImmutableList.of();
        }
        if (!this.getOpenRequestsByCitizen().containsKey(data.getId())) {
            return ImmutableList.of();
        }
        Collection<IToken<?>> list = this.getOpenRequestsByCitizen().get(data.getId());
        if (list == null || list.isEmpty()) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(list.stream().filter(Objects::nonNull).map(this.getColony().getRequestManager()::getRequestForToken).filter(Objects::nonNull).iterator());
    }

    @Override
    public ImmutableList<IRequest> getOpenRequestsOfBuilding() {
        return ImmutableList.copyOf(this.getOpenRequestsByCitizen().values().stream().flatMap(Collection::stream).filter(Objects::nonNull).map(this.getColony().getRequestManager()::getRequestForToken).filter(Objects::nonNull).iterator());
    }

    @Override
    public IColonyView getColony() {
        return this.colony;
    }

    @Override
    public <R> ImmutableList<IRequest<? extends R>> getOpenRequestsOfTypeFiltered(@NotNull ICitizenDataView citizenData, Class<R> requestType, Predicate<IRequest<? extends R>> filter) {
        return ImmutableList.copyOf(this.getOpenRequests(citizenData).stream().filter(request -> {
            Set<TypeToken> requestTypes = ReflectionUtils.getSuperClasses(request.getType());
            return requestTypes.contains(TypeToken.of((Class)requestType));
        }).map(request -> request).filter(filter).iterator());
    }

    @Override
    public IToken<?> getId() {
        return this.requesterId;
    }

    @Override
    @NotNull
    public void onRequestedRequestComplete(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
        Integer citizenThatRequested = this.getCitizensByRequest().remove(request.getId());
        this.getOpenRequestsByCitizen().get(citizenThatRequested).remove(request.getId());
        if (this.getOpenRequestsByCitizen().get(citizenThatRequested).isEmpty()) {
            this.getOpenRequestsByCitizen().remove(citizenThatRequested);
        }
    }

    @Override
    @NotNull
    public void onRequestedRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
        Integer citizenThatRequested = this.getCitizensByRequest().remove(request.getId());
        this.getOpenRequestsByCitizen().get(citizenThatRequested).remove(request.getId());
        if (this.getOpenRequestsByCitizen().get(citizenThatRequested).isEmpty()) {
            this.getOpenRequestsByCitizen().remove(citizenThatRequested);
        }
    }

    @Override
    @NotNull
    public ITextComponent getRequesterDisplayName(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
        try {
            if (this.getColony() == null || !this.getCitizensByRequest().containsKey(request.getId()) || this.getColony().getCitizen(this.getCitizensByRequest().get(request.getId())) == null) {
                return new TextComponentString("<UNKNOWN>");
            }
            return new TextComponentString(this.getColony().getCitizen(this.getCitizensByRequest().get(request.getId())).getName());
        }
        catch (Exception ex) {
            Log.getLogger().warn((Object)ex);
            return new TextComponentString("");
        }
    }

    @Override
    @NotNull
    public ILocation getLocation() {
        return new StaticLocation(this.getPosition(), this.colony.getDimension());
    }

    @Override
    public int getBuildingDmPrio() {
        return this.buildingDmPrio;
    }

    @Override
    public boolean isBuildingDmPrioState() {
        return this.buildingDmPrioState;
    }

    @Override
    public ImmutableCollection<IToken<?>> getResolverIds() {
        return this.resolvers;
    }

    @Override
    public void setCustomName(String name) {
        this.customName = name;
        MineColonies.getNetwork().sendToServer((IMessage)new HutRenameMessage(this.colony, name, this));
    }
}

