/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.registry;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.buildings.registry.IBuildingDataManager;
import com.minecolonies.api.colony.buildings.registry.IBuildingRegistry;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class BuildingDataManager
implements IBuildingDataManager {
    @Override
    public IBuilding createFrom(IColony colony, NBTTagCompound compound) {
        ResourceLocation type = new ResourceLocation(compound.func_74779_i("type"));
        BlockPos pos = BlockPosUtil.readFromNBT(compound, "location");
        IBuilding building = this.createFrom(colony, pos, type);
        try {
            building.deserializeNBT(compound);
        }
        catch (RuntimeException ex) {
            Log.getLogger().error(String.format("A Building %s(%s) has thrown an exception during loading, its state cannot be restored. Report this to the mod author", type, building.getClass().getName()), (Throwable)ex);
            building = null;
        }
        return building;
    }

    @Override
    public IBuilding createFrom(IColony colony, AbstractTileEntityColonyBuilding tileEntityColonyBuilding) {
        return this.createFrom(colony, tileEntityColonyBuilding.getPosition(), tileEntityColonyBuilding.getBuildingName());
    }

    @Override
    public IBuilding createFrom(IColony colony, BlockPos position, ResourceLocation buildingName) {
        BuildingEntry entry = (BuildingEntry)IBuildingRegistry.getInstance().getValue(buildingName);
        if (entry == null) {
            Log.getLogger().error(String.format("Unknown building type '%s'.", buildingName));
            return null;
        }
        return entry.getBuildingProducer().apply(colony, position);
    }

    @Override
    public IBuildingView createViewFrom(IColonyView colony, BlockPos position, ByteBuf networkBuffer) {
        ResourceLocation buildingName = new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)networkBuffer));
        BuildingEntry entry = (BuildingEntry)IBuildingRegistry.getInstance().getValue(buildingName);
        if (entry == null) {
            Log.getLogger().error(String.format("Unknown building type '%s'.", buildingName));
            return null;
        }
        IBuildingView view = entry.getBuildingViewProducer().get().apply(colony, position);
        if (view != null) {
            view.deserialize(networkBuffer);
        }
        return view;
    }
}

