/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.blockout.controls.Text;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import com.minecolonies.coremod.client.gui.WindowMinecoloniesBuildTool;
import com.minecolonies.coremod.network.messages.DirectPlaceMessage;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class WindowSuggestBuildTool
extends AbstractWindowSkeleton {
    @NotNull
    private final BlockPos pos;
    @NotNull
    private final IBlockState building;
    @NotNull
    private ItemStack stack;

    public WindowSuggestBuildTool(@NotNull BlockPos pos, @NotNull IBlockState state, @NotNull ItemStack stack) {
        super("minecolonies:gui/windowsuggestbuildtool.xml");
        this.pos = pos;
        this.building = state;
        this.stack = stack;
        this.registerButton("buildtool", this::buildToolClicked);
        this.registerButton("direct", this::directClicked);
        this.registerButton("cancel", this::cancelClicked);
        this.findPaneOfTypeByID("text", Text.class).setTextContent(LanguageHandler.format("com.minecolonies.coremod.gui.placement.warning", new Object[0]));
    }

    private void directClicked() {
        MineColonies.getNetwork().sendToServer((IMessage)new DirectPlaceMessage(this.building, this.pos, this.stack));
        this.close();
    }

    private void buildToolClicked() {
        new WindowMinecoloniesBuildTool(this.pos).open();
    }

    private void cancelClicked() {
        this.close();
    }
}

