/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.blockout.views;

import com.minecolonies.blockout.Loader;
import com.minecolonies.blockout.PaneParams;
import com.minecolonies.blockout.Screen;
import com.minecolonies.blockout.views.View;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class Window
extends View {
    private static final int DEFAULT_WIDTH = 420;
    private static final int DEFAULT_HEIGHT = 240;
    protected Screen screen;
    protected boolean windowPausesGame = true;
    protected boolean lightbox = true;

    public Window(ResourceLocation resource) {
        this();
        Loader.createFromXMLFile(resource, (View)this);
    }

    public Window() {
        this(420, 240);
    }

    public Window(int w, int h) {
        this.width = w;
        this.height = h;
        this.screen = new Screen(this);
        this.window = this;
    }

    public Window(String resource) {
        this();
        Loader.createFromXMLFile(resource, (View)this);
    }

    public void loadParams(@NotNull PaneParams params) {
        PaneParams.SizePair size;
        String inherit = params.getStringAttribute("inherit", null);
        if (inherit != null) {
            Loader.createFromXMLFile(new ResourceLocation(inherit), (View)this);
        }
        if ((size = params.getSizePairAttribute("size", null, null)) == null) {
            int w = params.getIntegerAttribute("width", this.width);
            int h = params.getIntegerAttribute("height", this.height);
            this.setSize(w, h);
        } else {
            this.setSize(size.getX(), size.getY());
        }
        this.lightbox = params.getBooleanAttribute("lightbox", this.lightbox);
        this.windowPausesGame = params.getBooleanAttribute("pause", this.windowPausesGame);
    }

    @Override
    public void parseChildren(PaneParams params) {
    }

    @Override
    public void drawSelf(int mx, int my) {
        Window.updateDebugging();
        super.drawSelf(mx, my);
    }

    private static void updateDebugging() {
        debugging = Keyboard.isKeyDown((int)29) && Keyboard.isKeyDown((int)42) && Keyboard.isKeyDown((int)56);
    }

    public boolean hasLightbox() {
        return this.lightbox;
    }

    public boolean doesWindowPauseGame() {
        return this.windowPausesGame;
    }

    public void open() {
        if (FMLCommonHandler.instance().getSide().equals((Object)Side.CLIENT)) {
            FMLCommonHandler.instance().showGuiScreen((Object)this.getScreen());
        }
    }

    public GuiScreen getScreen() {
        return this.screen;
    }

    public void onMouseReleased(int mx, int my) {
    }

    @Override
    public boolean onKeyTyped(char ch, int key) {
        if (Window.getFocus() != null && Window.getFocus().onKeyTyped(ch, key)) {
            return true;
        }
        this.onUnhandledKeyTyped(ch, key);
        return false;
    }

    public void onUnhandledKeyTyped(int ch, int key) {
        if (key == 1) {
            this.close();
        }
    }

    public void close() {
        this.mc.field_71439_g.func_71053_j();
        this.mc.func_71381_h();
    }

    public void onOpened() {
    }

    public void onClosed() {
    }
}

