/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity.ai.statemachine.tickratestatemachine;

import com.minecolonies.api.entity.ai.statemachine.basestatemachine.BasicTransition;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickingTransition;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class TickingTransition<S extends IState>
extends BasicTransition<S>
implements ITickingTransition<S> {
    @NotNull
    private int tickRate;
    @NotNull
    private final int tickOffset;
    private static int tickOffsetVariant = 0;

    public TickingTransition(@NotNull S state, @NotNull BooleanSupplier condition, @NotNull Supplier<S> nextState, @NotNull int tickRate) {
        super(state, condition, nextState);
        this.tickRate = tickRate > 500 ? 500 : tickRate;
        this.tickRate = this.tickRate < 1 ? 1 : this.tickRate;
        this.tickOffset = tickOffsetVariant % this.tickRate;
        if (++tickOffsetVariant >= 50) {
            tickOffsetVariant = 0;
        }
    }

    protected TickingTransition(@NotNull BooleanSupplier condition, @NotNull Supplier<S> nextState, @NotNull int tickRate) {
        super(condition, nextState);
        this.tickRate = tickRate > 500 ? 500 : tickRate;
        this.tickRate = this.tickRate < 1 ? 1 : this.tickRate;
        this.tickOffset = tickOffsetVariant % this.tickRate;
        if (++tickOffsetVariant >= 50) {
            tickOffsetVariant = 0;
        }
    }

    @Override
    public int getTickRate() {
        return this.tickRate;
    }

    @Override
    public void setTickRate(@NotNull int tickRate) {
        this.tickRate = tickRate;
    }

    @Override
    public int getTickOffset() {
        return this.tickOffset;
    }
}

