/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.permissions;

import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.network.PacketUtils;
import com.minecolonies.api.util.BlockPosUtil;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import org.jetbrains.annotations.Nullable;

public class PermissionEvent {
    @Nullable
    private final UUID id;
    private final String name;
    private final Action action;
    private final BlockPos position;

    public PermissionEvent(UUID id, String name, Action action, BlockPos position) {
        this.id = id;
        this.name = name;
        this.action = action;
        this.position = position;
    }

    public PermissionEvent(ByteBuf buf) {
        UUID uuid = PacketUtils.readUUID(buf);
        this.id = uuid.equals(UUID.fromString("1-2-3-4-5")) ? null : uuid;
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.action = Action.valueOf(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.position = BlockPosUtil.readFromByteBuf(buf);
    }

    @Nullable
    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Action getAction() {
        return this.action;
    }

    public BlockPos getPosition() {
        return this.position;
    }

    public void serialize(ByteBuf buf) {
        if (this.id == null) {
            PacketUtils.writeUUID(buf, UUID.fromString("1-2-3-4-5"));
        } else {
            PacketUtils.writeUUID(buf, this.id);
        }
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.action.toString());
        BlockPosUtil.writeToByteBuf(buf, this.position);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PermissionEvent that = (PermissionEvent)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && this.action == that.action && Objects.equals(this.position, that.position);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.action, this.position});
    }
}

