/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.parser;

import cofh.cofhworld.CoFHWorld;
import cofh.cofhworld.init.FeatureParser;
import cofh.cofhworld.parser.IDistributionParser;
import cofh.cofhworld.world.IConfigurableFeatureGenerator;
import cofh.cofhworld.world.IFeatureGenerator;
import cofh.shade.com.typesafe.config.Config;
import org.apache.logging.log4j.Logger;

public class DistributionData {
    public static IFeatureGenerator parseFeature(String featureName, Config distObject) throws IDistributionParser.InvalidDistributionException {
        String featureType = DistributionData.parseFeatureType(distObject);
        IDistributionParser parser = FeatureParser.getDistribution(featureType);
        if (parser != null) {
            boolean missedFields = false;
            for (String field : parser.getRequiredFields()) {
                if (distObject.hasPath(field)) continue;
                CoFHWorld.log.error("Missing required setting `{}` for distribution type '{}' on feature '{}' at line {}.", (Object)field, (Object)featureType, (Object)featureName, (Object)distObject.origin().lineNumber());
                missedFields = true;
            }
            if (missedFields) {
                throw new IDistributionParser.InvalidDistributionException("Missing required fields", distObject.origin());
            }
            return parser.parseFeature(featureName, distObject, CoFHWorld.log);
        }
        CoFHWorld.log.warn("Unknown distribution '{}' on line {}.", (Object)featureType, (Object)distObject.origin().lineNumber());
        throw new IDistributionParser.InvalidDistributionException("Unknown distribution type", distObject.origin());
    }

    public static IConfigurableFeatureGenerator getFeature(String featureName, Config distObject, boolean retrogen, Logger log) throws IDistributionParser.InvalidDistributionException {
        String featureType = DistributionData.parseFeatureType(distObject);
        IDistributionParser parser = FeatureParser.getDistribution(featureType);
        if (parser != null) {
            boolean missedFields = false;
            for (String field : parser.getRequiredFields()) {
                if (distObject.hasPath(field)) continue;
                log.error("Missing required setting `{}` for distribution type '{}' on feature '{}' at line {}.", (Object)field, (Object)featureType, (Object)featureName, (Object)distObject.origin().lineNumber());
                missedFields = true;
            }
            if (missedFields) {
                throw new IDistributionParser.InvalidDistributionException("Missing required fields", distObject.origin());
            }
            return parser.getFeature(featureName, distObject, retrogen, log);
        }
        log.warn("Unknown distribution '{}' on line {}.", (Object)featureType, (Object)distObject.origin().lineNumber());
        throw new IDistributionParser.InvalidDistributionException("Unknown distribution type", distObject.origin());
    }

    public static String parseFeatureType(Config genObject) {
        return genObject.getString("distribution");
    }
}

