/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.sync;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import sonar.core.sync.ISyncHandler;

public class SyncHandlerGeneral {

    public static class SyncHandlerEnum<E extends Enum>
    implements ISyncHandler<E> {
        public E[] constants;

        public SyncHandlerEnum(E[] constants) {
            this.constants = constants;
        }

        @Override
        public NBTTagCompound save(NBTTagCompound tag, String key, E value) {
            tag.func_74768_a(key, ((Enum)value).ordinal());
            return tag;
        }

        @Override
        public E load(NBTTagCompound tag, String key) {
            return this.constants[tag.func_74762_e(key)];
        }

        @Override
        public ByteBuf save(ByteBuf buf, E value) {
            return buf.writeInt(((Enum)value).ordinal());
        }

        @Override
        public E load(ByteBuf buf) {
            return this.constants[buf.readInt()];
        }
    }

    public static class SyncHandlerUUID
    implements ISyncHandler<UUID> {
        @Override
        public NBTTagCompound save(NBTTagCompound tag, String key, UUID value) {
            tag.func_186854_a(key, value);
            return tag;
        }

        @Override
        public UUID load(NBTTagCompound tag, String key) {
            return tag.func_186857_a(key);
        }

        @Override
        public ByteBuf save(ByteBuf buf, UUID value) {
            buf.writeLong(value.getMostSignificantBits());
            buf.writeLong(value.getLeastSignificantBits());
            return buf;
        }

        @Override
        public UUID load(ByteBuf buf) {
            return new UUID(buf.readLong(), buf.readLong());
        }
    }

    public static class SyncHandlerItemStack
    implements ISyncHandler<ItemStack> {
        @Override
        public NBTTagCompound save(NBTTagCompound tag, String key, ItemStack value) {
            return value.func_77955_b(tag);
        }

        @Override
        public ItemStack load(NBTTagCompound tag, String key) {
            return new ItemStack(tag);
        }

        @Override
        public ByteBuf save(ByteBuf buf, ItemStack value) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)value);
            return buf;
        }

        @Override
        public ItemStack load(ByteBuf buf) {
            return ByteBufUtils.readItemStack((ByteBuf)buf);
        }
    }

    public static class SyncHandlerNBTTagCompound
    implements ISyncHandler<NBTTagCompound> {
        @Override
        public NBTTagCompound save(NBTTagCompound tag, String key, NBTTagCompound value) {
            tag.func_74782_a(key, (NBTBase)value);
            return tag;
        }

        @Override
        public NBTTagCompound load(NBTTagCompound tag, String key) {
            return tag.func_74775_l(key);
        }

        @Override
        public ByteBuf save(ByteBuf buf, NBTTagCompound value) {
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)value);
            return buf;
        }

        @Override
        public NBTTagCompound load(ByteBuf buf) {
            return ByteBufUtils.readTag((ByteBuf)buf);
        }
    }

    public static class SyncHandlerString
    implements ISyncHandler<String> {
        @Override
        public NBTTagCompound save(NBTTagCompound tag, String key, String value) {
            tag.func_74778_a(key, value);
            return tag;
        }

        @Override
        public String load(NBTTagCompound tag, String key) {
            return tag.func_74779_i(key);
        }

        @Override
        public ByteBuf save(ByteBuf buf, String value) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)value);
            return buf;
        }

        @Override
        public String load(ByteBuf buf) {
            return ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
    }
}

