/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.KilledByPlayer;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.RandomChanceWithLooting;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetMetadata;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.tconstruct.library.capability.projectile.CapabilityTinkerProjectile;
import slimeknights.tconstruct.library.capability.projectile.ITinkerProjectile;
import slimeknights.tconstruct.library.events.TinkerToolEvent;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.harvest.TinkerHarvestTools;

public class ToolEvents {
    @SubscribeEvent
    public void onExtraBlockBreak(TinkerToolEvent.ExtraBlockBreak event) {
        if (TinkerModifiers.modHarvestWidth == null || TinkerModifiers.modHarvestHeight == null) {
            return;
        }
        NBTTagList modifiers = TagUtil.getBaseModifiersTagList(event.itemStack);
        boolean width = false;
        boolean height = false;
        for (int i = 0; i < modifiers.func_74745_c(); ++i) {
            String modId = modifiers.func_150307_f(i);
            if (modId.equals(TinkerModifiers.modHarvestWidth.getIdentifier())) {
                width = true;
                continue;
            }
            if (!modId.equals(TinkerModifiers.modHarvestHeight.getIdentifier())) continue;
            height = true;
        }
        if (!width && !height) {
            return;
        }
        if (event.tool == TinkerHarvestTools.pickaxe || event.tool == TinkerHarvestTools.hatchet || event.tool == TinkerHarvestTools.shovel || event.tool == TinkerHarvestTools.kama) {
            event.width = event.width + (width ? 1 : 0);
            event.height = event.height + (height ? 1 : 0);
        } else if (event.tool == TinkerHarvestTools.mattock) {
            int c = 0;
            if (width) {
                ++c;
            }
            if (height) {
                ++c;
            }
            event.width += c;
            event.height += c;
        } else if (event.tool == TinkerHarvestTools.hammer || event.tool == TinkerHarvestTools.excavator || event.tool == TinkerHarvestTools.lumberAxe || event.tool == TinkerHarvestTools.scythe) {
            event.width = event.width + (width ? 2 : 0);
            event.height = event.height + (height ? 2 : 0);
            event.distance = 3;
        }
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        if (event.getName().equals((Object)LootTableList.field_186386_ak)) {
            LootCondition[] lootConditions = new LootCondition[]{};
            LootEntryItem entry = new LootEntryItem(TinkerCommons.matNecroticBone.func_77973_b(), 1, 0, new LootFunction[]{new SetMetadata(lootConditions, new RandomValueRange((float)TinkerCommons.matNecroticBone.func_77960_j()))}, lootConditions, "necrotic_bone");
            event.getTable().addPool(new LootPool(new LootEntry[]{entry}, new LootCondition[]{new KilledByPlayer(false), new RandomChanceWithLooting(0.07f, 0.05f)}, new RandomValueRange(1.0f), new RandomValueRange(0.0f), "necrotic_bone"));
        }
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos;
        World world;
        if (ItemStack.func_179545_c((ItemStack)event.getItemStack(), (ItemStack)TinkerCommons.matMoss) && (world = event.getWorld()).func_180495_p(pos = event.getPos()).func_177230_c().getEnchantPowerBonus(world, pos) >= 1.0f) {
            EntityPlayer player = event.getEntityPlayer();
            if (event.getEntityPlayer().field_71068_ca >= 10) {
                player.func_184185_a(SoundEvents.field_187604_bf, 1.0f, 1.0f);
                if (!event.getWorld().field_72995_K) {
                    event.getItemStack().func_190918_g(1);
                    player.func_192024_a(null, 10);
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)TinkerCommons.matMendingMoss.func_77946_l());
                    event.setUseBlock(Event.Result.DENY);
                    event.setUseItem(Event.Result.DENY);
                    event.setCanceled(true);
                }
            } else {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("message.mending_moss.not_enough_levels", new Object[]{10}), true);
            }
        }
    }

    @SubscribeEvent
    public void onLooting(LootingLevelEvent event) {
        int level = event.getLootingLevel();
        ItemStack item = CapabilityTinkerProjectile.getTinkerProjectile(event.getDamageSource()).map(ITinkerProjectile::getItemStack).orElse(ItemStack.field_190927_a);
        if (item.func_190926_b() && event.getDamageSource().func_76346_g() instanceof EntityPlayer) {
            item = ((EntityPlayer)event.getDamageSource().func_76346_g()).func_184614_ca();
        }
        if (!item.func_190926_b()) {
            level = Math.max(level, this.getLooting(item));
        }
        event.setLootingLevel(level);
    }

    private int getLooting(ItemStack item) {
        if (item != null) {
            return TinkerModifiers.modLuck.getLuckLevel(item);
        }
        return 0;
    }
}

