/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.util;

import javax.annotation.Nullable;
import malte0811.industrialwires.util.MiscUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class LocalSidedWorld {
    private World world;
    private BlockPos origin;
    private EnumFacing facing;
    private boolean mirror;
    public boolean isRemote;

    public LocalSidedWorld(World world, BlockPos origin, EnumFacing facing, boolean mirror) {
        this.world = world;
        this.facing = facing;
        this.mirror = mirror;
        this.origin = origin;
        if (world != null) {
            this.isRemote = world.field_72995_K;
        }
    }

    public IBlockState getBlockState(BlockPos pos) {
        return this.world.func_180495_p(this.getRealPos(pos));
    }

    public TileEntity getTileEntity(BlockPos pos) {
        return this.world.func_175625_s(this.getRealPos(pos));
    }

    public boolean isAir(BlockPos pos) {
        return this.world.func_175623_d(this.getRealPos(pos));
    }

    public boolean setBlockState(BlockPos pos, IBlockState setTo) {
        return this.world.func_175656_a(this.getRealPos(pos), setTo);
    }

    public void spawnEntity(Entity e) {
        Vec3d posTransf = e.func_174791_d();
        Vec3d pos = this.getRealPos(posTransf);
        e.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        Vec3d motion = this.getRealDirection(new Vec3d(e.field_70159_w, e.field_70181_x, e.field_70179_y));
        e.field_70159_w = motion.field_72450_a;
        e.field_70181_x = motion.field_72448_b;
        e.field_70179_y = motion.field_72449_c;
        this.world.func_72838_d(e);
    }

    public void setTileEntity(BlockPos pos, TileEntity setTo) {
        this.world.func_175690_a(this.getRealPos(pos), setTo);
    }

    public void markForUpdate(BlockPos rel) {
        BlockPos pos = this.getRealPos(rel);
        IBlockState state = this.world.func_180495_p(pos);
        this.world.func_184138_a(pos, state, state, 3);
        this.world.func_175685_c(pos, state.func_177230_c(), true);
    }

    public BlockPos getRealPos(BlockPos relative) {
        return MiscUtils.offset(this.origin, this.facing, this.mirror, (Vec3i)relative);
    }

    public Vec3d getRealPos(Vec3d relative) {
        return MiscUtils.offset(new Vec3d((double)this.origin.func_177958_n() + 0.5, (double)this.origin.func_177956_o() + 0.5, (double)this.origin.func_177952_p() + 0.5), this.facing, this.mirror, relative.func_72441_c(0.5, 0.5, 0.5));
    }

    public Vec3d getRealDirection(Vec3d dir) {
        return MiscUtils.offset(Vec3d.field_186680_a, this.facing, this.mirror, dir);
    }

    public EnumFacing realToTransformed(@Nullable EnumFacing f) {
        if (f == null || f.func_176740_k() == EnumFacing.Axis.Y) {
            return f;
        }
        return EnumFacing.func_176731_b((int)(f.func_176736_b() - this.facing.func_176736_b() + 6));
    }

    public EnumFacing transformedToReal(@Nullable EnumFacing f) {
        if (f == null || f.func_176740_k() == EnumFacing.Axis.Y) {
            return f;
        }
        return EnumFacing.func_176731_b((int)(f.func_176736_b() + this.facing.func_176736_b() + 2));
    }

    public World getWorld() {
        return this.world;
    }

    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    public void setOrigin(BlockPos origin) {
        this.origin = origin;
    }

    public void setMirror(boolean mirror) {
        this.mirror = mirror;
    }

    public BlockPos getOrigin() {
        return this.origin;
    }

    public void setWorld(World world) {
        this.world = world;
        if (world != null) {
            this.isRemote = world.field_72995_K;
        }
    }

    public boolean isMirrored() {
        return this.mirror;
    }

    public EnumFacing getFacing() {
        return this.facing;
    }
}

