/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.items;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.client.ClientProxy;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.industrialwires.IndustrialWires;
import malte0811.industrialwires.blocks.controlpanel.BlockTypes_Panel;
import malte0811.industrialwires.blocks.controlpanel.TileEntityComponentPanel;
import malte0811.industrialwires.controlpanel.IConfigurableComponent;
import malte0811.industrialwires.controlpanel.PanelComponent;
import malte0811.industrialwires.controlpanel.PanelUtils;
import malte0811.industrialwires.items.INetGUIItem;
import malte0811.industrialwires.util.MiscUtils;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPanelComponent
extends Item
implements INetGUIItem {
    public static final String[] types = new String[]{"lighted_button", "label", "indicator_light", "slider", "variac", "toggle_switch", "toggle_switch_covered", "lock", "panel_meter", "7seg", "rgb_led"};
    public static final String NAME = "panel_component";

    public ItemPanelComponent() {
        this.func_77655_b("industrialwires.panel_component");
        this.func_77627_a(true);
        this.func_77637_a(IndustrialWires.creativeTab);
        this.func_77625_d(64);
        this.setRegistryName(new ResourceLocation("industrialwires", NAME));
        IndustrialWires.items.add(this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> list, ITooltipFlag flag) {
        if (GuiScreen.func_146272_n()) {
            NBTTagCompound nbt = ItemPanelComponent.getTagCompound(stack);
            NBTTagCompound data = nbt.func_74775_l("data");
            PanelUtils.addInfo(stack, list, data);
        } else {
            list.add(I18n.func_135052_a((String)"desc.immersiveengineering.info.holdShiftForInfo", (Object[])new Object[0]));
        }
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer(ItemStack stack) {
        return ClientProxy.itemFont;
    }

    @Nonnull
    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a() + "." + types[stack.func_77960_j()];
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            for (int i = 0; i < types.length; ++i) {
                subItems.add((Object)new ItemStack((Item)this, 1, i));
            }
        }
    }

    @Nullable
    public static PanelComponent componentFromStack(ItemStack stack) {
        if (stack.func_77973_b() != IndustrialWires.panelComponent) {
            return null;
        }
        NBTTagCompound loadFrom = ItemPanelComponent.getTagCompound(stack).func_74775_l("data").func_74737_b();
        loadFrom.func_74778_a("type", types[stack.func_77960_j()]);
        return PanelComponent.read(loadFrom);
    }

    @Nonnull
    public static ItemStack stackFromComponent(PanelComponent pc) {
        NBTTagCompound inner = new NBTTagCompound();
        pc.writeToNBT(inner, true);
        NBTTagCompound outer = new NBTTagCompound();
        outer.func_74782_a("data", (NBTBase)inner);
        int meta = ItemPanelComponent.getMetaFromPC(inner.func_74779_i("type"));
        ItemPanelComponent.removeIrrelevantTags(inner);
        if (meta >= 0) {
            ItemStack ret = new ItemStack((Item)IndustrialWires.panelComponent, 1, meta);
            ret.func_77982_d(outer);
            return ret;
        }
        return ItemStack.field_190927_a;
    }

    private static void removeIrrelevantTags(NBTTagCompound inner) {
        inner.func_82580_o("x");
        inner.func_82580_o("y");
        inner.func_82580_o("type");
        inner.func_82580_o("panelHeight");
    }

    private static int getMetaFromPC(String pc) {
        for (int i = 0; i < types.length; ++i) {
            if (!pc.equals(types[i])) continue;
            return i;
        }
        return -1;
    }

    @Nonnull
    public static NBTTagCompound getTagCompound(ItemStack stack) {
        PanelComponent asCmp;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nbt = stack.func_77978_p();
        assert (nbt != null);
        if (!nbt.func_74764_b("data") && (asCmp = PanelComponent.baseCreaters.get(types[stack.func_77960_j()]).get()) != null) {
            NBTTagCompound written = new NBTTagCompound();
            asCmp.writeToNBT(written, true);
            ItemPanelComponent.removeIrrelevantTags(written);
            nbt.func_74782_a("data", (NBTBase)written);
        }
        return nbt;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, @Nonnull EnumHand hand) {
        if (!worldIn.field_72995_K && !playerIn.func_70093_af()) {
            playerIn.openGui((Object)"industrialwires", 1, worldIn, 0, 0, hand == EnumHand.MAIN_HAND ? 1 : 0);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(hand));
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            ItemStack itemstack;
            IBlockState iblockstate = worldIn.func_180495_p(pos);
            Block block = iblockstate.func_177230_c();
            if (!block.func_176200_f((IBlockAccess)worldIn, pos)) {
                pos = pos.func_177972_a(facing);
            }
            if (!(itemstack = player.func_184586_b(hand)).func_190926_b() && player.func_175151_a(pos, facing, itemstack) && worldIn.func_190527_a((Block)IndustrialWires.panel, pos, false, facing, null)) {
                this.placeBlockAt(itemstack, player, worldIn, pos, facing, hitX, hitY, hitZ);
                SoundType soundtype = worldIn.func_180495_p(pos).func_177230_c().getSoundType(worldIn.func_180495_p(pos), worldIn, pos, (Entity)player);
                worldIn.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                itemstack.func_190918_g(1);
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.FAIL;
    }

    private void placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        IBlockState state = IndustrialWires.panel.func_176203_a(BlockTypes_Panel.SINGLE_COMP.ordinal());
        world.func_175656_a(pos, state);
        TileEntityComponentPanel te = MiscUtils.getLoadedTE(world, pos, TileEntityComponentPanel.class);
        if (te != null) {
            EnumFacing dir = te.getFacingForPlacement((EntityLivingBase)player, pos, side, hitX, hitY, hitZ);
            te.setFacing(dir);
            te.setComponent(ItemPanelComponent.componentFromStack(stack));
        }
    }

    @Override
    public void onChange(NBTTagCompound data, EntityPlayer player, EnumHand hand) {
        PanelComponent old;
        ItemStack held = player.func_184586_b(hand);
        if (!held.func_190926_b() && held.func_77973_b() == IndustrialWires.panelComponent && (old = ItemPanelComponent.componentFromStack(held)) instanceof IConfigurableComponent) {
            NBTTagList changes = data.func_150295_c("data", 10);
            IConfigurableComponent cmp = (IConfigurableComponent)((Object)old);
            for (int i = 0; i < changes.func_74745_c(); ++i) {
                NBTTagCompound curr = changes.func_150305_b(i);
                IConfigurableComponent.ConfigType type = IConfigurableComponent.ConfigType.values()[curr.func_74762_e("type")];
                try {
                    cmp.applyConfigOption(type, curr.func_74762_e("cfgId"), curr.func_74781_a("value"));
                    continue;
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
            ItemStack newCmp = ApiUtils.copyStackWithAmount((ItemStack)ItemPanelComponent.stackFromComponent(old), (int)held.func_190916_E());
            player.func_184611_a(hand, newCmp);
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !ItemStack.func_179545_c((ItemStack)oldStack, (ItemStack)newStack);
    }
}

