/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.client.gui;

import blusunrize.immersiveengineering.client.ClientUtils;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import malte0811.industrialwires.IndustrialWires;
import malte0811.industrialwires.blocks.controlpanel.TileEntityPanelCreator;
import malte0811.industrialwires.containers.ContainerPanelCreator;
import malte0811.industrialwires.controlpanel.MessageType;
import malte0811.industrialwires.controlpanel.PanelComponent;
import malte0811.industrialwires.controlpanel.PanelUtils;
import malte0811.industrialwires.items.ItemPanelComponent;
import malte0811.industrialwires.network.MessageGUIInteract;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class GuiPanelCreator
extends GuiContainer {
    public int panelSize = 128;
    private ContainerPanelCreator container;
    private int snapToGrid = 0;
    private ResourceLocation textureLoc = new ResourceLocation("industrialwires", "textures/gui/panel_creator.png");
    private ItemStack lastFloating = ItemStack.field_190927_a;
    private PanelComponent lastFloatingPC;

    public GuiPanelCreator(InventoryPlayer ip, TileEntityPanelCreator te) {
        super((Container)new ContainerPanelCreator(ip, te));
        this.container = (ContainerPanelCreator)this.field_147002_h;
        this.field_147000_g = 231;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.textureLoc);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        for (PanelComponent pc2 : this.container.tile.components) {
            this.drawPanelComponent(pc2, -1, -1);
        }
        int x0 = this.getX0();
        int y0 = this.getY0();
        int xRel = mouseX - x0;
        int yRel = mouseY - y0;
        PanelComponent curr = this.getFloatingPC();
        if (curr != null && 0 <= xRel && xRel <= this.panelSize && 0 <= yRel && yRel <= this.panelSize) {
            Runnable after = () -> {};
            if (this.snapToGrid != 0) {
                curr.setX((float)xRel / (float)this.panelSize);
                curr.setY((float)yRel / (float)this.panelSize);
                BiFunction<Integer, Integer, Integer> right = (a, b) -> b;
                BiFunction<Integer, Integer, Integer> left = (a, b) -> a;
                Function<PanelComponent, Double> xSize = pc -> {
                    AxisAlignedBB aabb = pc.getBlockRelativeAABB();
                    return aabb.field_72336_d - aabb.field_72340_a;
                };
                Function<PanelComponent, Double> ySize = pc -> {
                    AxisAlignedBB aabb = pc.getBlockRelativeAABB();
                    return aabb.field_72334_f - aabb.field_72339_c;
                };
                Pair<Integer, Runnable> xSnap = this.snapToGrid(xRel, curr, PanelComponent::getX, PanelComponent::getY, xSize, ySize, left, right);
                xRel = (Integer)xSnap.getLeft();
                Pair<Integer, Runnable> ySnap = this.snapToGrid(yRel, curr, PanelComponent::getY, PanelComponent::getX, ySize, xSize, right, left);
                yRel = (Integer)ySnap.getLeft();
                after = () -> {
                    ((Runnable)xSnap.getRight()).run();
                    ((Runnable)ySnap.getRight()).run();
                };
            }
            this.drawPanelComponent(curr, xRel, yRel);
            after.run();
        }
    }

    private Pair<Integer, Runnable> snapToGrid(int mouse, PanelComponent toPlace, Function<PanelComponent, Float> pos, Function<PanelComponent, Float> pos2, Function<PanelComponent, Double> size, Function<PanelComponent, Double> size2, BiFunction<Integer, Integer, Integer> getY, BiFunction<Integer, Integer, Integer> getX) {
        List<PanelComponent> components = this.container.tile.components;
        if (this.snapToGrid == 2 && !components.isEmpty()) {
            ArrayList<Pair<PanelComponent, Double>> compLefts = new ArrayList<Pair<PanelComponent, Double>>(components.size());
            ArrayList<Pair<PanelComponent, Double>> compCenters = new ArrayList<Pair<PanelComponent, Double>>(components.size());
            ArrayList<Pair<PanelComponent, Double>> compRights = new ArrayList<Pair<PanelComponent, Double>>(components.size());
            for (PanelComponent pc : components) {
                double compLeft = pos.apply(pc).floatValue();
                double compSize = size.apply(pc);
                compLefts.add((Pair<PanelComponent, Double>)new ImmutablePair((Object)pc, (Object)compLeft));
                compRights.add((Pair<PanelComponent, Double>)new ImmutablePair((Object)pc, (Object)(compLeft + compSize)));
                compCenters.add((Pair<PanelComponent, Double>)new ImmutablePair((Object)pc, (Object)(compLeft + compSize / 2.0)));
            }
            double mainLeft = pos.apply(toPlace).floatValue();
            double mainSize = size.apply(toPlace);
            double mainRight = mainLeft + mainSize;
            double mainCenter = (mainRight + mainLeft) / 2.0;
            Triple<PanelComponent, ComponentSnapType, Double> min = this.getMinDist(compLefts, mainLeft, mainCenter, mainRight);
            Triple<PanelComponent, ComponentSnapType, Double> tmpMin = this.getMinDist(compCenters, mainLeft, mainCenter, mainRight);
            if (Math.abs((Double)tmpMin.getRight()) < Math.abs((Double)min.getRight())) {
                min = tmpMin;
            }
            if (Math.abs((Double)(tmpMin = this.getMinDist(compRights, mainLeft, mainCenter, mainRight)).getRight()) < Math.abs((Double)min.getRight())) {
                min = tmpMin;
            }
            if (Math.abs((Double)min.getRight()) < 0.03125) {
                int ret = (int)((double)mouse + (Double)min.getRight() * (double)this.panelSize);
                PanelComponent snappedTo = (PanelComponent)min.getLeft();
                ComponentSnapType type = (ComponentSnapType)((Object)min.getMiddle());
                return new ImmutablePair((Object)ret, () -> {
                    float posOther = ((Float)pos2.apply(toPlace)).floatValue();
                    int hor1 = Math.round(Math.min(posOther, ((Float)pos2.apply(snappedTo)).floatValue()) * (float)this.panelSize);
                    int hor2 = (int)Math.round(Math.max((double)posOther + (Double)size2.apply(toPlace), (double)((Float)pos2.apply(snappedTo)).floatValue() + (Double)size2.apply(snappedTo)) * (double)this.panelSize);
                    int vert1 = (int)((double)ret + 0.5 * (double)type.ordinal() * mainSize * (double)this.panelSize);
                    int vert2 = vert1 + 1;
                    int x0 = this.getX0();
                    int y0 = this.getY0();
                    GuiPanelCreator.func_73734_a((int)(x0 + (Integer)getX.apply(hor1, vert1)), (int)(y0 + (Integer)getY.apply(hor1, vert1)), (int)(x0 + (Integer)getX.apply(hor2, vert2)), (int)(y0 + (Integer)getY.apply(hor2, vert2)), (int)-10066330);
                });
            }
        }
        if (this.snapToGrid != 0) {
            mouse = Math.round(mouse * 16 / this.panelSize) * this.panelSize / 16;
        }
        return new ImmutablePair((Object)mouse, () -> {});
    }

    private Triple<PanelComponent, ComponentSnapType, Double> getMinDist(List<Pair<PanelComponent, Double>> comps, double left, double center, double right) {
        Pair tmpMin = Collections.min(comps, Comparator.comparingDouble(a -> Math.abs((Double)a.getRight() - left)));
        ImmutableTriple totalMin = new ImmutableTriple(tmpMin.getLeft(), (Object)ComponentSnapType.LEFT, (Object)((Double)tmpMin.getRight() - left));
        tmpMin = Collections.min(comps, Comparator.comparingDouble(a -> Math.abs((Double)a.getRight() - center)));
        if (Math.abs((Double)tmpMin.getRight() - center) < Math.abs((Double)totalMin.getRight())) {
            totalMin = new ImmutableTriple(tmpMin.getLeft(), (Object)ComponentSnapType.CENTER, (Object)((Double)tmpMin.getRight() - center));
        }
        if (Math.abs((Double)(tmpMin = Collections.min(comps, Comparator.comparingDouble(a -> Math.abs((Double)a.getRight() - right)))).getRight() - right) < Math.abs((Double)totalMin.getRight())) {
            totalMin = new ImmutableTriple(tmpMin.getLeft(), (Object)ComponentSnapType.RIGHT, (Object)((Double)tmpMin.getRight() - right));
        }
        return totalMin;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        String tooltip = null;
        if (((GuiButton)this.field_146292_n.get(0)).func_146115_a()) {
            tooltip = I18n.func_135052_a((String)"industrialwires.desc.create_panel", (Object[])new Object[0]);
            ClientUtils.drawHoveringText((List)ImmutableList.of((Object)"Create a new panel"), (int)mouseX, (int)mouseY, (FontRenderer)this.field_146297_k.field_71466_p);
        } else if (((GuiButton)this.field_146292_n.get(1)).func_146115_a()) {
            tooltip = I18n.func_135052_a((String)"industrialwires.desc.remove_all", (Object[])new Object[0]);
        } else if (((GuiButton)this.field_146292_n.get(2)).func_146115_a()) {
            tooltip = I18n.func_135052_a((String)("industrialwires.desc.snap" + this.snapToGrid), (Object[])new Object[0]);
        } else if (((GuiButton)this.field_146292_n.get(3)).func_146115_a()) {
            tooltip = I18n.func_135052_a((String)"industrialwires.desc.disassemble", (Object[])new Object[0]);
        }
        if (tooltip != null) {
            ClientUtils.drawHoveringText((List)ImmutableList.of((Object)tooltip), (int)mouseX, (int)mouseY, (FontRenderer)this.field_146297_k.field_71466_p);
        }
    }

    private void drawPanelComponent(PanelComponent pc, int x, int y) {
        boolean red;
        if (x >= 0 && y >= 0) {
            pc.setX((float)x / (float)this.panelSize);
            pc.setY((float)y / (float)this.panelSize);
        }
        ItemStack unfinishedPanel = (ItemStack)this.container.func_75138_a().get(0);
        boolean bl = red = (0x200L & Minecraft.func_71386_F()) != 0L;
        if (red && !pc.isValidPos(this.container.tile.components, PanelUtils.getHeight(unfinishedPanel), PanelUtils.getAngle(unfinishedPanel))) {
            AxisAlignedBB aabb = pc.getBlockRelativeAABB();
            int left = (int)((double)this.getX0() + aabb.field_72340_a * (double)this.panelSize) - 1;
            int top = (int)((double)this.getY0() + aabb.field_72339_c * (double)this.panelSize) - 1;
            int right = (int)((double)this.getX0() + aabb.field_72336_d * (double)this.panelSize) + 1;
            int bottom = (int)((double)this.getY0() + aabb.field_72334_f * (double)this.panelSize) + 1;
            Gui.func_73734_a((int)left, (int)top, (int)right, (int)bottom, (int)-65536);
        }
        pc.renderInGUI(this);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        int buttonTop = this.field_147009_r + 62;
        this.field_146292_n.add(new GuiButton(0, this.field_147003_i + 2, buttonTop, 20, 20, "C"));
        this.field_146292_n.add(new GuiButton(1, this.field_147003_i + 2, buttonTop + 22, 20, 20, "R"));
        this.field_146292_n.add(new GuiButton(2, this.field_147003_i + 2, buttonTop + 44, 20, 20, "S"));
        this.field_146292_n.add(new GuiButton(3, this.field_147003_i + 2, buttonTop - 54, 20, 20, "D"));
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        block4: {
            List<PanelComponent> components;
            int yRel;
            int xRel;
            block5: {
                super.func_73864_a(mouseX, mouseY, mouseButton);
                int x0 = this.getX0();
                int y0 = this.getY0();
                xRel = mouseX - x0;
                yRel = mouseY - y0;
                PanelComponent curr = this.getFloatingPC();
                if (0 > xRel || xRel > this.panelSize || 0 > yRel || yRel > this.panelSize) break block4;
                components = this.container.tile.components;
                if (curr == null) break block5;
                ItemStack unfinishedPanel = (ItemStack)this.container.func_75138_a().get(0);
                if (!curr.isValidPos(components, PanelUtils.getHeight(unfinishedPanel), PanelUtils.getAngle(unfinishedPanel))) break block4;
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74776_a("x", curr.getX());
                nbt.func_74776_a("y", curr.getY());
                nbt.func_74768_a("type", MessageType.ADD.ordinal());
                IndustrialWires.packetHandler.sendToServer((IMessage)new MessageGUIInteract(this.container.tile, nbt));
                components.add(curr.copyOf());
                ItemStack currStack = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
                if (!currStack.func_190926_b()) {
                    currStack.func_190918_g(1);
                    if (currStack.func_190916_E() <= 0) {
                        this.field_146297_k.field_71439_g.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                    }
                }
                break block4;
            }
            if (this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
                float xRelFloat = (float)xRel / (float)this.panelSize;
                float yRelFloat = (float)yRel / (float)this.panelSize;
                for (int i = 0; i < components.size(); ++i) {
                    PanelComponent pc = components.get(i);
                    AxisAlignedBB aabb = pc.getBlockRelativeAABB();
                    if (!(aabb.field_72340_a <= (double)xRelFloat) || !(aabb.field_72336_d > (double)xRelFloat) || !(aabb.field_72339_c <= (double)yRelFloat) || !(aabb.field_72334_f > (double)yRelFloat)) continue;
                    PanelComponent removed = components.get(i);
                    ItemStack remItem = ItemPanelComponent.stackFromComponent(removed);
                    this.field_146297_k.field_71439_g.field_71071_by.func_70437_b(remItem);
                    NBTTagCompound nbt = new NBTTagCompound();
                    nbt.func_74768_a("type", MessageType.REMOVE.ordinal());
                    nbt.func_74768_a("id", i);
                    IndustrialWires.packetHandler.sendToServer((IMessage)new MessageGUIInteract(this.container.tile, nbt));
                    break;
                }
            }
        }
    }

    public int getX0() {
        return 30 + this.field_147003_i;
    }

    public int getY0() {
        return 6 + this.field_147009_r;
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        NBTTagCompound nbt = new NBTTagCompound();
        switch (button.field_146127_k) {
            case 0: {
                nbt.func_74768_a("type", MessageType.CREATE_PANEL.ordinal());
                break;
            }
            case 1: {
                nbt.func_74768_a("type", MessageType.REMOVE_ALL.ordinal());
                break;
            }
            case 2: {
                this.snapToGrid = (this.snapToGrid + 1) % 3;
                break;
            }
            case 3: {
                nbt.func_74768_a("type", MessageType.DISASSEMBLE.ordinal());
            }
        }
        if (!nbt.func_82582_d()) {
            IndustrialWires.packetHandler.sendToServer((IMessage)new MessageGUIInteract(this.container.tile, nbt));
        }
    }

    private PanelComponent getFloatingPC() {
        ItemStack floating = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
        if (floating.func_190926_b() || floating.func_77973_b() != IndustrialWires.panelComponent) {
            return null;
        }
        if (ItemStack.func_77989_b((ItemStack)floating, (ItemStack)this.lastFloating)) {
            return this.lastFloatingPC;
        }
        this.lastFloating = floating.func_77946_l();
        this.lastFloatingPC = ItemPanelComponent.componentFromStack(floating);
        return this.lastFloatingPC;
    }

    private static enum ComponentSnapType {
        LEFT,
        CENTER,
        RIGHT;

    }
}

