/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.client;

import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Vector3f;

@SideOnly(value=Side.CLIENT)
public class RawQuad {
    public final Vector3f[] vertices = new Vector3f[4];
    public final EnumFacing facing;
    public final TextureAtlasSprite tex;
    public final float[] colorA;
    public final Vector3f normal;
    public final float[][] uvs;
    public int light;

    public RawQuad(Vector3f v0, Vector3f v1, Vector3f v2, Vector3f v3, EnumFacing facing, TextureAtlasSprite tex, float[] colorA, Vector3f normal, float[] uvs) {
        this(v0, v1, v2, v3, facing, tex, colorA, normal, uvs, -1);
    }

    public RawQuad(Vector3f v0, Vector3f v1, Vector3f v2, Vector3f v3, EnumFacing facing, TextureAtlasSprite tex, float[] colorA, Vector3f normal, float[] uvs, int light) {
        this(v0, v1, v2, v3, facing, tex, colorA, normal, new float[][]{{uvs[0], uvs[1]}, {uvs[0], uvs[3]}, {uvs[2], uvs[3]}, {uvs[2], uvs[1]}}, light);
    }

    public RawQuad(Vector3f v0, Vector3f v1, Vector3f v2, Vector3f v3, EnumFacing facing, TextureAtlasSprite tex, float[] colorA, @Nullable Vector3f normal, float[][] uvs, int light) {
        this.vertices[0] = v0;
        this.vertices[1] = v1;
        this.vertices[2] = v2;
        this.vertices[3] = v3;
        this.facing = facing;
        this.tex = tex;
        if (colorA.length == 3) {
            this.colorA = Arrays.copyOf(colorA, 4);
            this.colorA[3] = 1.0f;
        } else {
            this.colorA = colorA;
        }
        if (normal != null) {
            this.normal = normal;
        } else {
            this.normal = Vector3f.cross((Vector3f)Vector3f.sub((Vector3f)v1, (Vector3f)v3, null), (Vector3f)Vector3f.sub((Vector3f)v2, (Vector3f)v0, null), null);
            this.normal.normalise(this.normal);
        }
        this.uvs = uvs;
        this.light = light;
    }

    public static RawQuad unbake(BakedQuad q) {
        Vector3f[] vertices = new Vector3f[4];
        float[] color = new float[4];
        Vector3f normal = new Vector3f();
        float[][] uvs = new float[4][2];
        TextureAtlasSprite sprite = q.func_187508_a();
        VertexFormat format = q.getFormat();
        int pos = 0;
        for (int v = 0; v < 4; ++v) {
            for (int e = 0; e < format.func_177345_h(); ++e) {
                switch (format.func_177348_c(e).func_177375_c()) {
                    case POSITION: {
                        int x = q.func_178209_a()[pos];
                        int y = q.func_178209_a()[pos + 1];
                        int z = q.func_178209_a()[pos + 2];
                        vertices[v] = new Vector3f(Float.intBitsToFloat(x), Float.intBitsToFloat(y), Float.intBitsToFloat(z));
                        break;
                    }
                    case COLOR: {
                        for (int i = 0; i < 4; ++i) {
                            color[i] = Float.intBitsToFloat(q.func_178209_a()[pos + i]);
                        }
                        break;
                    }
                    case UV: {
                        if (format.func_177348_c(e).func_177367_b() != VertexFormatElement.EnumType.FLOAT) break;
                        uvs[v][0] = sprite.func_188537_a(Float.intBitsToFloat(q.func_178209_a()[pos]));
                        uvs[v][1] = sprite.func_188536_b(Float.intBitsToFloat(q.func_178209_a()[pos + 1]));
                        break;
                    }
                    case NORMAL: {
                        int x = q.func_178209_a()[pos];
                        int y = q.func_178209_a()[pos + 1];
                        int z = q.func_178209_a()[pos + 2];
                        normal.set(Float.intBitsToFloat(x), Float.intBitsToFloat(y), Float.intBitsToFloat(z));
                    }
                }
                pos += format.func_177348_c(e).func_177368_f() / 4;
            }
        }
        return new RawQuad(vertices[0], vertices[1], vertices[2], vertices[3], q.func_178210_d(), sprite, color, normal, uvs, -1);
    }

    public RawQuad apply(Matrix4 mat) {
        Matrix4 matNormal = mat.copy().transpose();
        matNormal.invert();
        return new RawQuad(mat.apply(this.vertices[0]), mat.apply(this.vertices[1]), mat.apply(this.vertices[2]), mat.apply(this.vertices[3]), this.facing, this.tex, this.colorA, matNormal.apply(this.normal), this.uvs, this.light);
    }
}

