/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.feature;

import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockLog;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;
import twilightforest.block.BlockTFHedge;
import twilightforest.block.BlockTFLog;
import twilightforest.block.TFBlocks;
import twilightforest.enums.HedgeVariant;
import twilightforest.enums.WoodVariant;
import twilightforest.world.feature.IBlockSettable;
import twilightforest.world.feature.TFGenHollowTree;
import twilightforest.world.feature.TFGenerator;

public abstract class TFTreeGenerator
extends WorldGenAbstractTree
implements IBlockSettable {
    protected IBlockState treeState = TFBlocks.twilight_log.func_176223_P();
    protected IBlockState branchState = TFBlocks.twilight_log.func_176223_P().func_177226_a((IProperty)BlockTFLog.field_176299_a, (Comparable)BlockLog.EnumAxis.NONE).func_177226_a(BlockTFLog.VARIANT, (Comparable)((Object)WoodVariant.DARK));
    protected IBlockState leafState = TFBlocks.hedge.func_176223_P().func_177226_a(BlockTFHedge.VARIANT, (Comparable)((Object)HedgeVariant.DARKWOOD_LEAVES));
    protected IBlockState rootState = TFBlocks.root.func_176223_P();
    protected IPlantable source = TFBlocks.twilight_sapling;

    public TFTreeGenerator() {
        this(false);
    }

    public TFTreeGenerator(boolean notify) {
        super(notify);
    }

    @Override
    public final void setBlockAndNotify(World world, BlockPos pos, IBlockState state) {
        this.func_175903_a(world, pos, state);
    }

    protected boolean func_150523_a(Block blockType) {
        return TFGenHollowTree.canGrowInto(blockType);
    }

    protected void buildRoot(World world, BlockPos pos, double offset, int b) {
        BlockPos[] lineArray;
        BlockPos dest = TFGenerator.translate(pos.func_177979_c(b + 2), 5.0, 0.3 * (double)b + offset, 0.8);
        for (BlockPos coord : lineArray = TFGenerator.getBresehnamArrays(pos.func_177977_b(), dest)) {
            this.placeRootBlock(world, coord, this.rootState);
        }
    }

    protected void placeRootBlock(World world, BlockPos pos, IBlockState state) {
        if (TFTreeGenerator.canRootGrowIn(world, pos)) {
            this.func_175903_a(world, pos, state);
        }
    }

    public static boolean canRootGrowIn(World world, BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos);
        Block blockID = blockState.func_177230_c();
        if (blockID.isAir(blockState, (IBlockAccess)world, pos)) {
            return TFGenerator.isNearSolid(world, pos);
        }
        return blockState.func_185887_b(world, pos) >= 0.0f && blockID != TFBlocks.stronghold_shield && blockID != TFBlocks.trophy_pedestal && blockID != TFBlocks.boss_spawner && (blockState.func_185904_a() == Material.field_151577_b || blockState.func_185904_a() == Material.field_151578_c || blockState.func_185904_a() == Material.field_151576_e);
    }

    protected void addFirefly(World world, BlockPos pos, int height, double angle) {
        int iAngle = (int)(angle * 4.0);
        if (iAngle == 0) {
            this.setIfEmpty(world, pos.func_177982_a(1, height, 0), TFBlocks.firefly.func_176223_P().func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)EnumFacing.EAST));
        } else if (iAngle == 1) {
            this.setIfEmpty(world, pos.func_177982_a(-1, height, 0), TFBlocks.firefly.func_176223_P().func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)EnumFacing.WEST));
        } else if (iAngle == 2) {
            this.setIfEmpty(world, pos.func_177982_a(0, height, 1), TFBlocks.firefly.func_176223_P().func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)EnumFacing.SOUTH));
        } else if (iAngle == 3) {
            this.setIfEmpty(world, pos.func_177982_a(0, height, -1), TFBlocks.firefly.func_176223_P().func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)EnumFacing.NORTH));
        }
    }

    private void setIfEmpty(World world, BlockPos pos, IBlockState state) {
        if (world.func_175623_d(pos)) {
            this.func_175903_a(world, pos, state);
        }
    }
}

