/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.hollowtree;

import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.template.TemplateManager;
import twilightforest.TFFeature;
import twilightforest.block.TFBlocks;
import twilightforest.structures.hollowtree.ComponentTFHollowTreeSmallBranch;
import twilightforest.structures.hollowtree.StructureTFTreeComponent;
import twilightforest.world.feature.TFGenerator;

public class ComponentTFHollowTreeMedBranch
extends StructureTFTreeComponent {
    BlockPos src;
    BlockPos dest;
    double length;
    double angle;
    double tilt;
    boolean leafy;

    public ComponentTFHollowTreeMedBranch() {
    }

    protected ComponentTFHollowTreeMedBranch(TFFeature feature, int i, int sx, int sy, int sz, double length, double angle, double tilt, boolean leafy) {
        super(feature, i);
        this.src = new BlockPos(sx, sy, sz);
        this.dest = TFGenerator.translate(this.src, length, angle, tilt);
        this.length = length;
        this.angle = angle;
        this.tilt = tilt;
        this.leafy = leafy;
        this.func_186164_a(EnumFacing.SOUTH);
        this.field_74887_e = new StructureBoundingBox((Vec3i)this.src, (Vec3i)this.dest);
        this.field_74887_e.func_78888_b(this.makeExpandedBB(0.5, length, angle, tilt));
        this.field_74887_e.func_78888_b(this.makeExpandedBB(0.1f, length, 0.225, tilt));
        this.field_74887_e.func_78888_b(this.makeExpandedBB(0.1f, length, -0.225, tilt));
    }

    private StructureBoundingBox makeExpandedBB(double outVar, double branchLength, double branchAngle, double branchTilt) {
        BlockPos branchSrc = TFGenerator.translate(this.src, this.length * outVar, this.angle, this.tilt);
        BlockPos branchDest = TFGenerator.translate(branchSrc, branchLength, branchAngle, branchTilt);
        return new StructureBoundingBox((Vec3i)branchSrc, (Vec3i)branchDest);
    }

    @Override
    protected void func_143012_a(NBTTagCompound tagCompound) {
        super.func_143012_a(tagCompound);
        tagCompound.func_74768_a("srcPosX", this.src.func_177958_n());
        tagCompound.func_74768_a("srcPosY", this.src.func_177956_o());
        tagCompound.func_74768_a("srcPosZ", this.src.func_177952_p());
        tagCompound.func_74768_a("destPosX", this.dest.func_177958_n());
        tagCompound.func_74768_a("destPosY", this.dest.func_177956_o());
        tagCompound.func_74768_a("destPosZ", this.dest.func_177952_p());
        tagCompound.func_74780_a("branchLength", this.length);
        tagCompound.func_74780_a("branchAngle", this.angle);
        tagCompound.func_74780_a("branchTilt", this.tilt);
        tagCompound.func_74757_a("branchLeafy", this.leafy);
    }

    @Override
    protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager templateManager) {
        super.func_143011_b(tagCompound, templateManager);
        this.src = new BlockPos(tagCompound.func_74762_e("srcPosX"), tagCompound.func_74762_e("srcPosY"), tagCompound.func_74762_e("srcPosZ"));
        this.dest = new BlockPos(tagCompound.func_74762_e("destPosX"), tagCompound.func_74762_e("destPosY"), tagCompound.func_74762_e("destPosZ"));
        this.length = tagCompound.func_74769_h("branchLength");
        this.angle = tagCompound.func_74769_h("branchAngle");
        this.tilt = tagCompound.func_74769_h("branchTilt");
        this.leafy = tagCompound.func_74767_n("branchLeafy");
    }

    public void makeSmallBranch(List<StructureComponent> list, Random rand, int index, int x, int y, int z, double branchLength, double branchRotation, double branchAngle, boolean leafy) {
        ComponentTFHollowTreeSmallBranch branch = new ComponentTFHollowTreeSmallBranch(this.getFeatureType(), index, x, y, z, branchLength, branchRotation, branchAngle, leafy);
        list.add(branch);
        branch.func_74861_a(this, list, rand);
    }

    public boolean func_74875_a(World world, Random random, StructureBoundingBox sbb) {
        return this.addComponentParts(world, random, sbb, false);
    }

    @Override
    public boolean addComponentParts(World world, Random random, StructureBoundingBox sbb, boolean drawLeaves) {
        BlockPos rSrc = this.src.func_177982_a(-this.field_74887_e.field_78897_a, -this.field_74887_e.field_78895_b, -this.field_74887_e.field_78896_c);
        BlockPos rDest = this.dest.func_177982_a(-this.field_74887_e.field_78897_a, -this.field_74887_e.field_78895_b, -this.field_74887_e.field_78896_c);
        if (!drawLeaves) {
            IBlockState log = TFBlocks.twilight_log.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.NONE);
            this.drawBresehnam(world, sbb, rSrc.func_177958_n(), rSrc.func_177956_o(), rSrc.func_177952_p(), rDest.func_177958_n(), rDest.func_177956_o(), rDest.func_177952_p(), log);
            this.drawBresehnam(world, sbb, rSrc.func_177958_n(), rSrc.func_177956_o() + 1, rSrc.func_177952_p(), rDest.func_177958_n(), rDest.func_177956_o(), rDest.func_177952_p(), log);
        }
        Random decoRNG = new Random(world.func_72905_C() + (long)(this.field_74887_e.field_78897_a * 321534781) ^ (long)(this.field_74887_e.field_78896_c * 756839));
        int numShoots = Math.min(decoRNG.nextInt(3) + 1, (int)(this.length / 5.0));
        double angleInc = 0.8 / (double)numShoots;
        for (int i = 0; i < numShoots; ++i) {
            double angleVar = angleInc * (double)i - 0.4;
            double outVar = decoRNG.nextDouble() * 0.8 + 0.2;
            BlockPos bSrc = TFGenerator.translate(rSrc, this.length * outVar, this.angle, this.tilt);
            this.drawSmallBranch(world, sbb, bSrc.func_177958_n(), bSrc.func_177956_o(), bSrc.func_177952_p(), Math.max(this.length * (double)0.3f, 2.0), this.angle + angleVar, this.tilt, drawLeaves);
        }
        if (drawLeaves) {
            int numLeafBalls = Math.min(decoRNG.nextInt(3) + 1, (int)(this.length / 5.0));
            for (int i = 0; i < numLeafBalls; ++i) {
                double slength = (double)(decoRNG.nextFloat() * 0.6f + 0.2f) * this.length;
                BlockPos bdst = TFGenerator.translate(rSrc, slength, this.angle, this.tilt);
                this.makeLeafBlob(world, sbb, bdst.func_177958_n(), bdst.func_177956_o(), bdst.func_177952_p(), decoRNG.nextBoolean() ? 2 : 3);
            }
            this.makeLeafBlob(world, sbb, rDest.func_177958_n(), rDest.func_177956_o(), rDest.func_177952_p(), 3);
        }
        return true;
    }

    protected void drawBresehnam(World world, StructureBoundingBox sbb, int x1, int y1, int z1, int x2, int y2, int z2, IBlockState blockState) {
        if (x1 == x2 && z1 == z2) {
            int l = Math.max(y1, y2);
            for (int i = Math.min(y1, y2); i < l; ++i) {
                this.func_175811_a(world, blockState, x1, i, z1, sbb);
            }
        } else {
            BlockPos[] lineCoords;
            for (BlockPos coords : lineCoords = TFGenerator.getBresehnamArrays(x1, y1, z1, x2, y2, z2)) {
                this.func_175811_a(world, blockState, coords.func_177958_n(), coords.func_177956_o(), coords.func_177952_p(), sbb);
            }
        }
    }

    protected void makeLeafBlob(World world, StructureBoundingBox sbb, int sx, int sy, int sz, int radius) {
        for (int dx = 0; dx <= radius; ++dx) {
            for (int dy = 0; dy <= radius; ++dy) {
                for (int dz = 0; dz <= radius; ++dz) {
                    int dist = 0;
                    dist = dx >= dy && dx >= dz ? (int)((float)dx + ((float)Math.max(dy, dz) * 0.5f + (float)Math.min(dy, dz) * 0.25f)) : (dy >= dx && dy >= dz ? (int)((float)dy + ((float)Math.max(dx, dz) * 0.5f + (float)Math.min(dx, dz) * 0.25f)) : (int)((float)dz + ((float)Math.max(dx, dy) * 0.5f + (float)Math.min(dx, dy) * 0.25f)));
                    if (dist > radius) continue;
                    IBlockState leaves = TFBlocks.twilight_leaves.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
                    this.placeLeafBlock(world, leaves, sx + dx, sy + dy, sz + dz, sbb);
                    this.placeLeafBlock(world, leaves, sx + dx, sy + dy, sz - dz, sbb);
                    this.placeLeafBlock(world, leaves, sx - dx, sy + dy, sz + dz, sbb);
                    this.placeLeafBlock(world, leaves, sx - dx, sy + dy, sz - dz, sbb);
                    this.placeLeafBlock(world, leaves, sx + dx, sy - dy, sz + dz, sbb);
                    this.placeLeafBlock(world, leaves, sx + dx, sy - dy, sz - dz, sbb);
                    this.placeLeafBlock(world, leaves, sx - dx, sy - dy, sz + dz, sbb);
                    this.placeLeafBlock(world, leaves, sx - dx, sy - dy, sz - dz, sbb);
                }
            }
        }
    }

    protected void drawSmallBranch(World world, StructureBoundingBox sbb, int sx, int sy, int sz, double branchLength, double branchAngle, double branchTilt, boolean drawLeaves) {
        BlockPos branchDest = TFGenerator.translate(new BlockPos(sx, sy, sz), branchLength, branchAngle, branchTilt);
        if (!drawLeaves) {
            IBlockState log = TFBlocks.twilight_log.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.NONE);
            this.drawBresehnam(world, sbb, sx, sy, sz, branchDest.func_177958_n(), branchDest.func_177956_o(), branchDest.func_177952_p(), log);
        } else {
            this.makeLeafBlob(world, sbb, branchDest.func_177958_n(), branchDest.func_177956_o(), branchDest.func_177952_p(), 2);
        }
    }
}

