/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.features;

import com.google.common.math.StatsAccumulator;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.BlockWall;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import twilightforest.TwilightForestMod;
import twilightforest.entity.EntityTFSkeletonDruid;
import twilightforest.enums.StructureWoodVariant;
import twilightforest.loot.TFTreasure;
import twilightforest.structures.RandomizedTemplateProcessor;
import twilightforest.world.feature.TFGenerator;

public class GenDruidHut
extends TFGenerator {
    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int dz;
        BlockPos transformedSize;
        int dx;
        Random random = world.func_175726_f(pos).func_76617_a(987234911L);
        MinecraftServer minecraftserver = world.func_73046_m();
        TemplateManager templatemanager = world.func_72860_G().func_186340_h();
        Template template = templatemanager.func_186237_a(minecraftserver, HutType.values()[random.nextInt(HutType.size)].RL);
        Rotation[] rotations = Rotation.values();
        Rotation rotation = rotations[random.nextInt(rotations.length)];
        Mirror[] mirrors = Mirror.values();
        Mirror mirror = mirrors[random.nextInt(mirrors.length + 1) % mirrors.length];
        ChunkPos chunkpos = new ChunkPos(pos.func_177982_a(-8, 0, -8));
        StructureBoundingBox structureboundingbox = new StructureBoundingBox(chunkpos.func_180334_c() + 8, 0, chunkpos.func_180333_d() + 8, chunkpos.func_180332_e() + 8, 255, chunkpos.func_180330_f() + 8);
        PlacementSettings placementsettings = new PlacementSettings().func_186214_a(mirror).func_186220_a(rotation).func_186223_a(structureboundingbox).func_189950_a(random);
        BlockPos posSnap = chunkpos.func_180331_a(8, pos.func_177956_o() - 1, 8);
        BlockPos.MutableBlockPos startPos = new BlockPos.MutableBlockPos(posSnap.func_177982_a(dx = random.nextInt(17 - (transformedSize = template.func_186257_a(rotation)).func_177958_n()), 0, dz = random.nextInt(17 - transformedSize.func_177952_p())));
        if (!GenDruidHut.offsetToAverageGroundLevel(world, startPos, transformedSize)) {
            return false;
        }
        BlockPos placementPos = template.func_189961_a((BlockPos)startPos, mirror, rotation);
        template.func_189960_a(world, placementPos, (ITemplateProcessor)new HutTemplateProcessor(placementPos, placementsettings, random.nextInt(), random.nextInt(), random.nextInt()), placementsettings, 20);
        Map data = template.func_186258_a(placementPos, placementsettings);
        if (random.nextBoolean()) {
            template = templatemanager.func_186237_a(minecraftserver, BasementType.values()[random.nextInt(BasementType.size)].getBasement(random.nextBoolean()));
            placementPos = placementPos.func_177979_c(12).func_177967_a(rotation.func_185831_a(mirror.func_185803_b(EnumFacing.NORTH)), 1).func_177967_a(rotation.func_185831_a(mirror.func_185803_b(EnumFacing.EAST)), 1);
            template.func_189960_a(world, placementPos, (ITemplateProcessor)new HutTemplateProcessor(placementPos, placementsettings, random.nextInt(), random.nextInt(), random.nextInt()), placementsettings, 20);
            data.putAll(template.func_186258_a(placementPos, placementsettings));
        }
        data.forEach((blockPos, s) -> {
            if ("spawner".equals(s)) {
                TileEntityMobSpawner ms;
                if (world.func_180501_a(blockPos, Blocks.field_150474_ac.func_176223_P(), 18) && (ms = (TileEntityMobSpawner)world.func_175625_s(blockPos)) != null) {
                    ms.func_145881_a().func_190894_a(EntityList.func_191306_a(EntityTFSkeletonDruid.class));
                }
            } else if (s.startsWith("loot")) {
                IBlockState chest = s.endsWith("T") ? Blocks.field_150447_bR.func_176223_P() : Blocks.field_150486_ae.func_176223_P();
                switch (s.substring(4, 5)) {
                    case "W": {
                        chest = chest.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)rotation.func_185831_a(mirror.func_185803_b(EnumFacing.WEST)));
                        break;
                    }
                    case "E": {
                        chest = chest.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)rotation.func_185831_a(mirror.func_185803_b(EnumFacing.EAST)));
                        break;
                    }
                    case "S": {
                        chest = chest.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)rotation.func_185831_a(mirror.func_185803_b(EnumFacing.SOUTH)));
                        break;
                    }
                    default: {
                        chest = chest.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)rotation.func_185831_a(mirror.func_185803_b(EnumFacing.NORTH)));
                    }
                }
                if (world.func_180501_a(blockPos, chest, 18)) {
                    TFTreasure.basement.generateChestContents(world, (BlockPos)blockPos);
                }
            }
        });
        return true;
    }

    private static boolean offsetToAverageGroundLevel(World world, BlockPos.MutableBlockPos startPos, BlockPos size) {
        StatsAccumulator heights = new StatsAccumulator();
        for (int dx = 0; dx < size.func_177958_n(); ++dx) {
            for (int dz = 0; dz < size.func_177952_p(); ++dz) {
                int y;
                int x = startPos.func_177958_n() + dx;
                int z = startPos.func_177952_p() + dz;
                for (y = world.func_189649_b(x, z); y >= 0; --y) {
                    IBlockState state = world.func_180495_p(new BlockPos(x, y, z));
                    if (GenDruidHut.isBlockNotOk(state)) {
                        return false;
                    }
                    if (GenDruidHut.isBlockOk(state)) break;
                }
                if (y < 0) {
                    return false;
                }
                heights.add((double)y);
            }
        }
        if (heights.populationStandardDeviation() > 2.0) {
            return false;
        }
        int baseY = (int)Math.round(heights.mean());
        int maxY = (int)heights.max();
        startPos.func_185336_p(baseY);
        return GenDruidHut.isAreaClear((IBlockAccess)world, startPos.func_177981_b(maxY - baseY + 1), startPos.func_177971_a((Vec3i)size));
    }

    private static boolean isAreaClear(IBlockAccess world, BlockPos min, BlockPos max) {
        for (BlockPos pos : BlockPos.func_177975_b((BlockPos)min, (BlockPos)max)) {
            if (world.func_180495_p(pos).func_177230_c().func_176200_f(world, pos)) continue;
            return false;
        }
        return true;
    }

    private static boolean isBlockOk(IBlockState state) {
        Material material = state.func_185904_a();
        return material == Material.field_151576_e || material == Material.field_151578_c || material == Material.field_151577_b || material == Material.field_151595_p;
    }

    private static boolean isBlockNotOk(IBlockState state) {
        Material material = state.func_185904_a();
        return material == Material.field_151586_h || material == Material.field_151587_i || state.func_177230_c() == Blocks.field_150357_h;
    }

    public class HutTemplateProcessor
    extends RandomizedTemplateProcessor {
        private final StructureWoodVariant OAK_SWIZZLE;
        private final StructureWoodVariant SPRUCE_SWIZZLE;
        private final StructureWoodVariant BIRCH_SWIZZLE;

        public HutTemplateProcessor(BlockPos pos, PlacementSettings settings, int oakSwizzle, int spruceSwizzle, int birchSwizzle) {
            super(pos, settings);
            int limit = StructureWoodVariant.values().length;
            this.OAK_SWIZZLE = StructureWoodVariant.values()[Math.floorMod(oakSwizzle, limit)];
            this.SPRUCE_SWIZZLE = StructureWoodVariant.values()[Math.floorMod(spruceSwizzle, limit)];
            this.BIRCH_SWIZZLE = StructureWoodVariant.values()[Math.floorMod(birchSwizzle, limit)];
        }

        @Nullable
        public Template.BlockInfo func_189943_a(World worldIn, BlockPos pos, Template.BlockInfo blockInfo) {
            IBlockState state = blockInfo.field_186243_b;
            Block block = state.func_177230_c();
            if (block == Blocks.field_150347_e) {
                return this.random.nextBoolean() ? blockInfo : new Template.BlockInfo(pos, Blocks.field_150341_Y.func_176223_P(), null);
            }
            if (block == Blocks.field_150463_bK) {
                return this.random.nextBoolean() ? blockInfo : new Template.BlockInfo(pos, state.func_177226_a((IProperty)BlockWall.field_176255_P, (Comparable)BlockWall.EnumType.MOSSY), null);
            }
            if (block == Blocks.field_150417_aV && state != Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.CHISELED)) {
                return this.random.nextBoolean() ? blockInfo : new Template.BlockInfo(pos, state.func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.values()[this.random.nextInt(3)]), null);
            }
            BlockPlanks.EnumType type = StructureWoodVariant.getTypeFromBlockState(state);
            if (type != null) {
                switch (type) {
                    case OAK: {
                        return new Template.BlockInfo(pos, StructureWoodVariant.modifyBlockWithType(state, this.OAK_SWIZZLE), null);
                    }
                    case SPRUCE: {
                        return new Template.BlockInfo(pos, StructureWoodVariant.modifyBlockWithType(state, this.SPRUCE_SWIZZLE), null);
                    }
                    case BIRCH: {
                        return new Template.BlockInfo(pos, StructureWoodVariant.modifyBlockWithType(state, this.BIRCH_SWIZZLE), null);
                    }
                }
            }
            return blockInfo;
        }
    }

    private static enum BasementType {
        STUDY(TwilightForestMod.prefix("landscape/druid_hut/basement_study"), TwilightForestMod.prefix("landscape/druid_hut/basement_study_trap")),
        SHELVES(TwilightForestMod.prefix("landscape/druid_hut/basement_shelves"), TwilightForestMod.prefix("landscape/druid_hut/basement_shelves_trap")),
        GALLERY(TwilightForestMod.prefix("landscape/druid_hut/basement_gallery"), TwilightForestMod.prefix("landscape/druid_hut/basement_gallery_trap"));

        private final ResourceLocation RL;
        private final ResourceLocation RL_TRAP;
        private static int size;

        private BasementType(ResourceLocation rl, ResourceLocation rlTrap) {
            this.RL = rl;
            this.RL_TRAP = rlTrap;
            BasementType.increment();
        }

        private static void increment() {
            ++size;
        }

        private ResourceLocation getBasement(boolean trapped) {
            return trapped ? this.RL_TRAP : this.RL;
        }
    }

    private static enum HutType {
        REGULAR(TwilightForestMod.prefix("landscape/druid_hut/druid_hut")),
        SIDEWAYS(TwilightForestMod.prefix("landscape/druid_hut/druid_sideways")),
        DOUBLE_DECK(TwilightForestMod.prefix("landscape/druid_hut/druid_doubledeck"));

        private final ResourceLocation RL;
        private static int size;

        private HutType(ResourceLocation rl) {
            this.RL = rl;
            HutType.increment();
        }

        private static void increment() {
            ++size;
        }
    }
}

