/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.compat.ie;

import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.api.shader.ShaderCaseBalloon;
import blusunrize.immersiveengineering.api.shader.ShaderCaseChemthrower;
import blusunrize.immersiveengineering.api.shader.ShaderCaseDrill;
import blusunrize.immersiveengineering.api.shader.ShaderCaseMinecart;
import blusunrize.immersiveengineering.api.shader.ShaderCaseRailgun;
import blusunrize.immersiveengineering.api.shader.ShaderCaseRevolver;
import blusunrize.immersiveengineering.api.shader.ShaderCaseShield;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.client.ClientUtils;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.function.IntConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.util.TriConsumer;
import twilightforest.TwilightForestMod;
import twilightforest.client.shader.ShaderManager;
import twilightforest.client.shader.ShaderUniform;
import twilightforest.compat.ie.TFShaderCaseChemthrower;
import twilightforest.compat.ie.TFShaderCaseDrill;
import twilightforest.compat.ie.TFShaderCaseRailgun;
import twilightforest.compat.ie.TFShaderCaseShield;
import twilightforest.item.TFItems;

public class IEShaderRegister {
    private static final ShaderCase.ShaderLayer NULL_LAYER = new ShaderCase.ShaderLayer(null, -1);
    private static final ShaderCase.ShaderLayer UNCOLORED_REVOLVER_LAYER = new ShaderCase.ShaderLayer(new ResourceLocation("immersiveengineering", "revolvers/shaders/revolver_uncoloured"), -1);
    private static final ShaderCase.ShaderLayer UNCOLORED_CHEMTHROW_LAYER = new ShaderCase.ShaderLayer(new ResourceLocation("immersiveengineering", "items/shaders/chemthrower_uncoloured"), -1);
    private static final ShaderCase.ShaderLayer UNCOLORED_DRILL_LAYER = new ShaderCase.ShaderLayer(new ResourceLocation("immersiveengineering", "items/shaders/drill_diesel_uncoloured"), -1);
    private static final ShaderCase.ShaderLayer UNCOLORED_RAILGUN_LAYER = new ShaderCase.ShaderLayer(new ResourceLocation("immersiveengineering", "items/shaders/railgun_uncoloured"), -1);
    private static final ShaderCase.ShaderLayer UNCOLORED_SHIELD_LAYER = new ShaderCase.ShaderLayer(new ResourceLocation("immersiveengineering", "items/shaders/shield_uncoloured"), -1);
    private static final ShaderCase.ShaderLayer UNCOLORED_MINECART_LAYER = new ShaderCase.ShaderLayer(new ResourceLocation("immersiveengineering", "textures/models/shaders/minecart_uncoloured.png"), -1);
    private static final ShaderCase.ShaderLayer UNCOLORED_BALLOON_LAYER = new ShaderCase.ShaderLayer(new ResourceLocation("immersiveengineering", "blocks/shaders/balloon_uncoloured"), -1);
    public static final ResourceLocation PROCESSED_REVOLVER_GRIP_LAYER = new ResourceLocation("twilightforest", "items/immersiveengineering/revolver_grip_processed");
    public static final ResourceLocation PROCESSED_REVOLVER_LAYER = new ResourceLocation("twilightforest", "items/immersiveengineering/revolver_processed");
    public static final ResourceLocation PROCESSED_CHEMTHROW_LAYER = new ResourceLocation("twilightforest", "items/immersiveengineering/chemthrower_processed");
    public static final ResourceLocation PROCESSED_DRILL_LAYER = new ResourceLocation("twilightforest", "items/immersiveengineering/drill_processed");
    public static final ResourceLocation PROCESSED_RAILGUN_LAYER = new ResourceLocation("twilightforest", "items/immersiveengineering/railgun_processed");
    public static final ResourceLocation PROCESSED_SHIELD_LAYER = new ResourceLocation("twilightforest", "items/immersiveengineering/shield_processed");
    public static final ResourceLocation PROCESSED_BALLOON_LAYER = new ResourceLocation("twilightforest", "blocks/immersiveengineering/balloon_processed");
    private static final ResourceLocation TEXTURE_STARS = new ResourceLocation("textures/entity/end_portal.png");
    private static final TriConsumer<IntConsumer, Boolean, Float> TWILIGHT_TRICONSUMER = (shaderCallback, pre, partialTick) -> {
        if (pre.booleanValue()) {
            ShaderManager.useShader(ShaderManager.twilightSkyShader, shaderCallback);
            OpenGlHelper.func_77473_a((int)OpenGlHelper.field_176096_r);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE_STARS);
            OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        } else {
            ShaderManager.releaseShader();
            OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        }
    };
    private static final TriConsumer<IntConsumer, Boolean, Float> FIREFLY_TRICONSUMER = (shaderCallback, pre, partialTick) -> {
        if (pre.booleanValue()) {
            ShaderManager.useShader(ShaderManager.fireflyShader, shaderCallback);
        } else {
            ShaderManager.releaseShader();
        }
    };
    private static final TriConsumer<IntConsumer, Boolean, Float> CARMINITE_TRICONSUMER = (shaderCallback, pre, partialTick) -> {
        if (pre.booleanValue()) {
            ShaderManager.useShader(ShaderManager.carminiteShader, shaderCallback);
        } else {
            ShaderManager.releaseShader();
        }
    };
    private static final TriConsumer<IntConsumer, Boolean, Float> DEVICE_RED_ENERGY_TRICONSUMER = (shaderCallback, pre, partialTick) -> {
        if (pre.booleanValue()) {
            ShaderManager.useShader(ShaderManager.towerDeviceShader, shaderCallback);
        } else {
            ShaderManager.releaseShader();
        }
    };
    private static final TriConsumer<IntConsumer, Boolean, Float> DEVICE_YELLOW_ENERGY_TRICONSUMER = (shaderCallback, pre, partialTick) -> {
        if (pre.booleanValue()) {
            GlStateManager.func_187421_b((int)3553, (int)10240, (int)9729);
            ShaderManager.useShader(ShaderManager.yellowCircuitShader, shaderCallback);
        } else {
            ShaderManager.releaseShader();
            GlStateManager.func_187421_b((int)3553, (int)10240, (int)9728);
        }
    };
    private static final TriConsumer<IntConsumer, Boolean, Float> AURORA_TRICONSUMER = (shaderCallback, pre, partialTick) -> {
        if (pre.booleanValue()) {
            ShaderManager.useShader(ShaderManager.auroraShader, shaderCallback);
        } else {
            ShaderManager.releaseShader();
        }
    };
    private static final TriConsumer<IntConsumer, Boolean, Float> RAM_TRICONSUMER = (shaderCallback, pre, partialTick) -> ClientUtils.toggleLightmap((boolean)pre, (boolean)true);
    private static final ShaderLayerProvider<?> LAYER_PROVIDER = (m, t, s, c) -> new ShaderCase.ShaderLayer(m.provideTex(t, s), c);
    private static final ShaderLayerProvider<?> TOWER_DEVICE_SHADER_PROVIDER = (m, t, s, c) -> new ShaderConsumerLayer(ModType.TWILIGHT_FOREST.provideTex(t, "energy"), -1, DEVICE_RED_ENERGY_TRICONSUMER, ShaderManager.Uniforms.STAR_UNIFORMS);
    private static final ShaderLayerProvider<?> YELLOW_CIRCUIT_SHADER_PROVIDER = (m, t, s, c) -> new ShaderConsumerLayer(ModType.IMMERSIVE_ENGINEERING.provideTex(t, "circuit"), -4526590, DEVICE_YELLOW_ENERGY_TRICONSUMER, ShaderManager.Uniforms.STAR_UNIFORMS);
    private static List<ShaderRegistry.ShaderRegistryEntry> SHADERS;
    private static List<ShaderRegistry.ShaderRegistryEntry> NONBOSSES;
    private static final EnumRarity RARITY;

    public static void initShaders() {
        NONBOSSES = ImmutableList.of((Object)IEShaderRegister.registerShaderCases("Twilight", ModType.TWILIGHT_FOREST, "1_4", RARITY, -11770789, -14146241, -16733696, -1, (m, t, s, c) -> new ShaderConsumerLayer(m.provideTex(t, s), -1, TWILIGHT_TRICONSUMER, ShaderManager.Uniforms.STAR_UNIFORMS)).setInfo("Twilight Forest", "Twilight Forest", "twilightforest"), (Object)IEShaderRegister.registerShaderCases("Firefly", ModType.TWILIGHT_FOREST, "1_6", RARITY, -10075840, -681681, -4129024, -4129024, LAYER_PROVIDER, (m, t, s, c) -> new ShaderConsumerLayer(ModType.TWILIGHT_FOREST.provideTex(t, "processed"), -1, FIREFLY_TRICONSUMER, ShaderManager.Uniforms.TIME_UNIFORM)).setInfo("Twilight Forest", "Firefly", "firefly"), (Object)IEShaderRegister.registerShaderCases("Pinch Beetle", ModType.TWILIGHT_FOREST, "1_0", RARITY, -4418777, -14412279, -14412279, -12303292, LAYER_PROVIDER, (m, t, s, c) -> new ShaderCase.ShaderLayer(m.provideTex(t, "1_6"), c)).setInfo("Twilight Forest", "Pinch Beetle", "pinch_beetle"), (Object)IEShaderRegister.registerShaderCases("Snakestone", ModType.TWILIGHT_FOREST, "streaks", RARITY, -6316129, -9934744, -10461088, -1, LAYER_PROVIDER, (m, t, s, c) -> new ShaderCase.ShaderLayer(ModType.TWILIGHT_FOREST.provideTex(t, "scales"), -11513776), (m, t, s, c) -> new ShaderCase.ShaderLayer(ModType.IMMERSIVE_ENGINEERING.provideTex(t, "circuit"), -10987432)).setInfo("Twilight Forest", "Nagastone", "courtyard"), (Object)IEShaderRegister.registerShaderCases("Mazestone", ModType.TWILIGHT_FOREST, "scales", RARITY, -7431794, -11511472, -9405584, -1, LAYER_PROVIDER).setInfo("Twilight Forest", "Mazestone", "mazestone"), (Object)IEShaderRegister.registerShaderCases("Underbrick", ModType.TWILIGHT_FOREST, "scales", RARITY, -8034235, -9011338, -10400461, -1, LAYER_PROVIDER).setInfo("Twilight Forest", "Underbrick", "underbrick"), (Object)IEShaderRegister.registerShaderCasesTopped("Towerwood", ModType.TWILIGHT_FOREST, "1_0", RARITY, -5872326, -664941, -8168907, -1, new ShaderLayerProvider[]{LAYER_PROVIDER, YELLOW_CIRCUIT_SHADER_PROVIDER}, TOWER_DEVICE_SHADER_PROVIDER).setInfo("Twilight Forest", "Towerwood Planks", "towerwood"), (Object)IEShaderRegister.registerShaderCasesTopped("Carminite", ModType.TWILIGHT_FOREST, "carminite", RARITY, -9306112, -65536, -65536, -65536, new ShaderLayerProvider[]{(m, t, s, c) -> new ShaderConsumerLayer(m.provideTex(t, s), -1, CARMINITE_TRICONSUMER, ShaderManager.Uniforms.STAR_UNIFORMS)}, TOWER_DEVICE_SHADER_PROVIDER).setInfo("Twilight Forest", "Carminite", "carminite"), (Object)IEShaderRegister.registerShaderCases("Auroralized", ModType.TWILIGHT_FOREST, "1_5", RARITY, -16711681, -16711936, -16776961, -1, (m, t, s, c) -> new ShaderConsumerLayer(m.provideTex(t, s), -1, AURORA_TRICONSUMER, ShaderManager.Uniforms.TIME_UNIFORM)).setInfo("Twilight Forest", "Aurora Palace", "aurora"), (Object)IEShaderRegister.registerShaderCases("Ironwood", ModType.TWILIGHT_FOREST, "1_0", RARITY, -9739935, -10531520, -10594485, -1, (m, t, s, c) -> new ShaderCase.ShaderLayer(ModType.TWILIGHT_FOREST.provideTex(t, "streaks"), -8815549), LAYER_PROVIDER).setInfo("Twilight Forest", "Ironwood", "ironwood"), (Object)IEShaderRegister.registerShaderCases("Steeleaf", ModType.TWILIGHT_FOREST, "1_0", RARITY, -11368646, -14798316, -12492240, -1, (m, t, s, c) -> new ShaderCase.ShaderLayer(ModType.IMMERSIVE_ENGINEERING.provideTex(t, "1_4"), -12492240), (m, t, s, c) -> new ShaderCase.ShaderLayer(ModType.TWILIGHT_FOREST.provideTex(t, "streaks"), -9592226), LAYER_PROVIDER).setInfo("Twilight Forest", "Steeleaf", "steeleaf"), (Object)IEShaderRegister.registerShaderCases("Knightly", ModType.TWILIGHT_FOREST, "1_0", RARITY, -1573683, -11711413, -8352654, -1, LAYER_PROVIDER).setInfo("Twilight Forest", "Knightly", "knightly"), (Object[])new ShaderRegistry.ShaderRegistryEntry[]{IEShaderRegister.registerShaderCases("Fiery", ModType.TWILIGHT_FOREST, "1_0", RARITY, -15133933, -142243, -8964847, -1, LAYER_PROVIDER).setInfo("Twilight Forest", "Fiery", "fiery"), IEShaderRegister.registerShaderCases("Final Castle", ModType.TWILIGHT_FOREST, "scales", RARITY, -1250586, -3621956, -16711681, -16711681, LAYER_PROVIDER).setInfo("Twilight Forest", "Final Castle", "finalcastle"), IEShaderRegister.registerShaderCases("Cube of Annihilation", ModType.TWILIGHT_FOREST, "1_0", RARITY, -16777213, -15466432, -16777213, -15466432, (m, t, s, c) -> new ShaderCase.ShaderLayer(m.provideTex(t, s), -15466432)).setInfo("Twilight Forest", "Cube of Annilation", "cube_of_annilation")});
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        listBuilder.addAll(NONBOSSES);
        listBuilder.add((Object[])new ShaderRegistry.ShaderRegistryEntry[]{IEShaderRegister.registerShaderCases("Questing Ram", ModType.TWILIGHT_FOREST, "streaks", RARITY, -400952, -6650519, -13685962, -7284497, LAYER_PROVIDER, (m, t, s, c) -> new ShaderConsumerLayer(ModType.IMMERSIVE_ENGINEERING.provideTex(t, "circuit"), 814799087, RAM_TRICONSUMER, new ShaderUniform[0])).setInfo("Twilight Forest", "Questing Ram", "questing_ram"), IEShaderRegister.registerShaderCases("Naga", ModType.TWILIGHT_FOREST, "scales", RARITY, -13476571, -15259375, -5909482, -1, LAYER_PROVIDER, (m, t, s, c) -> new ShaderCase.ShaderLayer(ModType.IMMERSIVE_ENGINEERING.provideTex(t, "shark"), -1)).setInfo("Twilight Forest", "Naga Boss", "naga"), IEShaderRegister.registerShaderCases("Lich", ModType.TWILIGHT_FOREST, "1_0", RARITY, -2106932, -3957760, -12974987, -1, LAYER_PROVIDER).setInfo("Twilight Forest", "Twilight Lich Boss", "lich"), IEShaderRegister.registerShaderCases("Minoshroom", ModType.TWILIGHT_FOREST, "1_6", RARITY, -5763054, -5000269, -13374517, -1, LAYER_PROVIDER).setInfo("Twilight Forest", "Minoshroom Miniboss", "minoshroom"), IEShaderRegister.registerShaderCases("Hydra", ModType.TWILIGHT_FOREST, "scales", RARITY, -15455936, -14057365, -980334, -1, LAYER_PROVIDER, (m, t, s, c) -> new ShaderCase.ShaderLayer(ModType.IMMERSIVE_ENGINEERING.provideTex(t, "shark"), -1)).setInfo("Twilight Forest", "Hydra Boss", "hydra"), IEShaderRegister.registerShaderCases("Knight Phantom", ModType.TWILIGHT_FOREST, "1_0", RARITY, -868193019, -13224652, -8758199, -1, LAYER_PROVIDER).setInfo("Twilight Forest", "Knight Phantom Minibosses", "knight_phantom"), IEShaderRegister.registerShaderCases("Ur-Ghast", ModType.TWILIGHT_FOREST, "1_2", RARITY, -394759, -6670537, -11119018, -1, LAYER_PROVIDER).setInfo("Twilight Forest", "Ur-Ghast", "ur-ghast"), IEShaderRegister.registerShaderCases("Alpha Yeti", ModType.TWILIGHT_FOREST, "1_0", RARITY, -197380, -11894578, -14336154, -1, LAYER_PROVIDER).setInfo("Twilight Forest", "Alpha Yeti", "alpha_yeti"), IEShaderRegister.registerShaderCases("Snow Queen", ModType.TWILIGHT_FOREST, "1_0", RARITY, -2294785, -3957760, -16579191, -1, LAYER_PROVIDER).setInfo("Twilight Forest", "Snow Queen", "snow_queen")});
        SHADERS = listBuilder.build();
    }

    public static List<ShaderRegistry.ShaderRegistryEntry> getAllTwilightShaders() {
        return SHADERS;
    }

    public static List<ShaderRegistry.ShaderRegistryEntry> getAllNonbossShaders() {
        return NONBOSSES;
    }

    @SafeVarargs
    private static ShaderRegistry.ShaderRegistryEntry registerShaderCasesTopped(String name, ModType mod, String overlayType, EnumRarity rarity, int bodyColor, int colorSecondary, int gripColor, int colorBlade, ShaderLayerProvider<? extends ShaderCase.ShaderLayer>[] providers, ShaderLayerProvider<? extends ShaderCase.ShaderLayer> ... extraProviders) {
        ShaderRegistry.registerShader_Item((String)name, (EnumRarity)rarity, (int)gripColor, (int)bodyColor, (int)colorSecondary);
        IEShaderRegister.registerShaderCaseRevolver(name, gripColor, bodyColor, colorBlade, rarity, IEShaderRegister.provideFromProviders(mod, CaseType.REVOLVER, overlayType, colorSecondary, providers), IEShaderRegister.provideFromProviders(mod, CaseType.REVOLVER, overlayType, colorSecondary, extraProviders));
        IEShaderRegister.registerShaderCaseChemthrower(name, gripColor, bodyColor, rarity, IEShaderRegister.provideFromProviders(mod, CaseType.CHEMICAL_THROWER, overlayType, colorSecondary, providers), IEShaderRegister.provideFromProviders(mod, CaseType.CHEMICAL_THROWER, overlayType, colorSecondary, extraProviders));
        IEShaderRegister.registerShaderCaseDrill(name, gripColor, bodyColor, colorBlade, rarity, IEShaderRegister.provideFromProviders(mod, CaseType.DRILL, overlayType, colorSecondary, providers), IEShaderRegister.provideFromProviders(mod, CaseType.DRILL, overlayType, colorSecondary, extraProviders));
        IEShaderRegister.registerShaderCaseRailgun(name, gripColor, bodyColor, rarity, IEShaderRegister.provideFromProviders(mod, CaseType.RAILGUN, overlayType, colorSecondary, providers), IEShaderRegister.provideFromProviders(mod, CaseType.RAILGUN, overlayType, colorSecondary, extraProviders));
        IEShaderRegister.registerShaderCaseShield(name, gripColor, bodyColor, rarity, IEShaderRegister.provideFromProviders(mod, CaseType.SHIELD, overlayType, colorSecondary, providers), IEShaderRegister.provideFromProviders(mod, CaseType.SHIELD, overlayType, colorSecondary, extraProviders));
        IEShaderRegister.registerShaderCaseMinecart(name, gripColor, bodyColor, rarity, IEShaderRegister.provideFromProviders(mod, CaseType.MINECART, overlayType, colorSecondary, providers), IEShaderRegister.provideFromProviders(mod, CaseType.MINECART, overlayType + ".png", colorSecondary, extraProviders));
        IEShaderRegister.registerShaderCaseBalloon(name, gripColor, bodyColor, rarity, IEShaderRegister.provideFromProviders(mod, CaseType.BALLOON, overlayType, colorSecondary, providers), IEShaderRegister.provideFromProviders(mod, CaseType.BALLOON, overlayType, colorSecondary, extraProviders));
        for (ShaderRegistry.IShaderRegistryMethod method : ShaderRegistry.shaderRegistrationMethods) {
            method.apply(name, overlayType, rarity, gripColor, bodyColor, colorSecondary, colorBlade, null, 0);
        }
        return ((ShaderRegistry.ShaderRegistryEntry)ShaderRegistry.shaderRegistry.get(name)).setCrateLoot(false).setBagLoot(false).setInLowerBags(false).setReplicationCost(new IngredientStack(new ItemStack(TFItems.ore_meter)));
    }

    @SafeVarargs
    private static ShaderRegistry.ShaderRegistryEntry registerShaderCases(String name, ModType type, String overlayType, EnumRarity rarity, int bodyColor, int colorSecondary, int gripColor, int colorBlade, ShaderLayerProvider<? extends ShaderCase.ShaderLayer> ... providers) {
        return IEShaderRegister.registerShaderCasesTopped(name, type, overlayType, rarity, bodyColor, colorSecondary, gripColor, colorBlade, providers, new ShaderLayerProvider[0]);
    }

    private static ShaderCase.ShaderLayer[] provideFromProviders(ModType mod, CaseType type, String suffix, int color, ShaderLayerProvider<? extends ShaderCase.ShaderLayer>[] layerProviders) {
        ShaderCase.ShaderLayer[] array = new ShaderCase.ShaderLayer[layerProviders.length];
        for (int i = 0; i < layerProviders.length; ++i) {
            array[i] = layerProviders[i].get(mod, type, suffix, color);
        }
        return array;
    }

    private static ShaderCaseRevolver registerShaderCaseRevolver(String name, int gripColor, int bodyColor, int bladeColor, EnumRarity rarity, ShaderCase.ShaderLayer[] additionalLayers, ShaderCase.ShaderLayer ... topLayers) {
        ImmutableList.Builder shaderLayerBuilder = ImmutableList.builder();
        return (ShaderCaseRevolver)ShaderRegistry.registerShaderCase((String)name, (ShaderCase)new ShaderCaseRevolver((Collection)shaderLayerBuilder.add((Object[])new ShaderCase.ShaderLayer[]{new ShaderCase.ShaderLayer(PROCESSED_REVOLVER_GRIP_LAYER, gripColor), new ShaderCase.ShaderLayer(PROCESSED_REVOLVER_LAYER, bodyColor), new ShaderCase.ShaderLayer(PROCESSED_REVOLVER_LAYER, bladeColor)}).add((Object[])additionalLayers).add((Object)UNCOLORED_REVOLVER_LAYER).add((Object[])topLayers).build()), (EnumRarity)rarity);
    }

    private static ShaderCaseChemthrower registerShaderCaseChemthrower(String name, int gripColor, int bodyColor, EnumRarity rarity, ShaderCase.ShaderLayer[] additionalLayers, ShaderCase.ShaderLayer ... topLayers) {
        ImmutableList.Builder shaderLayerBuilder = ImmutableList.builder();
        return (ShaderCaseChemthrower)ShaderRegistry.registerShaderCase((String)name, (ShaderCase)new TFShaderCaseChemthrower(3 + additionalLayers.length, (Collection<ShaderCase.ShaderLayer>)shaderLayerBuilder.add((Object[])new ShaderCase.ShaderLayer[]{new ShaderCase.ShaderLayer(PROCESSED_CHEMTHROW_LAYER, gripColor), new ShaderCase.ShaderLayer(PROCESSED_CHEMTHROW_LAYER, bodyColor)}).add((Object[])additionalLayers).add((Object)UNCOLORED_CHEMTHROW_LAYER).add((Object[])topLayers).build()), (EnumRarity)rarity);
    }

    private static ShaderCaseDrill registerShaderCaseDrill(String name, int gripColor, int bodyColor, int bladeColor, EnumRarity rarity, ShaderCase.ShaderLayer[] additionalLayers, ShaderCase.ShaderLayer ... topLayers) {
        ImmutableList.Builder shaderLayerBuilder = ImmutableList.builder();
        return (ShaderCaseDrill)ShaderRegistry.registerShaderCase((String)name, (ShaderCase)new TFShaderCaseDrill(5 + additionalLayers.length, (Collection<ShaderCase.ShaderLayer>)shaderLayerBuilder.add((Object[])new ShaderCase.ShaderLayer[]{new ShaderCase.ShaderLayer(PROCESSED_DRILL_LAYER, gripColor), new ShaderCase.ShaderLayer(PROCESSED_DRILL_LAYER, bodyColor)}).add((Object)UNCOLORED_DRILL_LAYER).add((Object[])additionalLayers).add((Object)UNCOLORED_DRILL_LAYER).add((Object)NULL_LAYER).add((Object[])topLayers).build()), (EnumRarity)rarity);
    }

    private static ShaderCaseRailgun registerShaderCaseRailgun(String name, int gripColor, int bodyColor, EnumRarity rarity, ShaderCase.ShaderLayer[] additionalLayers, ShaderCase.ShaderLayer ... topLayers) {
        ImmutableList.Builder shaderLayerBuilder = ImmutableList.builder();
        return (ShaderCaseRailgun)ShaderRegistry.registerShaderCase((String)name, (ShaderCase)new TFShaderCaseRailgun(3 + additionalLayers.length, (Collection<ShaderCase.ShaderLayer>)shaderLayerBuilder.add((Object[])new ShaderCase.ShaderLayer[]{new ShaderCase.ShaderLayer(PROCESSED_RAILGUN_LAYER, gripColor), new ShaderCase.ShaderLayer(PROCESSED_RAILGUN_LAYER, bodyColor)}).add((Object[])additionalLayers).add((Object)UNCOLORED_RAILGUN_LAYER).add((Object[])topLayers).build()), (EnumRarity)rarity);
    }

    private static ShaderCaseShield registerShaderCaseShield(String name, int gripColor, int bodyColor, EnumRarity rarity, ShaderCase.ShaderLayer[] additionalLayers, ShaderCase.ShaderLayer ... topLayers) {
        ImmutableList.Builder shaderLayerBuilder = ImmutableList.builder();
        return (ShaderCaseShield)ShaderRegistry.registerShaderCase((String)name, (ShaderCase)new TFShaderCaseShield(3 + additionalLayers.length, (Collection<ShaderCase.ShaderLayer>)shaderLayerBuilder.add((Object[])new ShaderCase.ShaderLayer[]{new ShaderCase.ShaderLayer(PROCESSED_SHIELD_LAYER, gripColor), new ShaderCase.ShaderLayer(PROCESSED_SHIELD_LAYER, bodyColor)}).add((Object[])additionalLayers).add((Object)UNCOLORED_SHIELD_LAYER).add((Object[])topLayers).build()), (EnumRarity)rarity);
    }

    private static ShaderCaseMinecart registerShaderCaseMinecart(String name, int bodyColor, int secondaryColor, EnumRarity rarity, ShaderCase.ShaderLayer[] additionalLayers, ShaderCase.ShaderLayer ... topLayers) {
        ImmutableList.Builder shaderLayerBuilder = ImmutableList.builder();
        return (ShaderCaseMinecart)ShaderRegistry.registerShaderCase((String)name, (ShaderCase)new ShaderCaseMinecart((Collection)shaderLayerBuilder.add((Object[])new ShaderCase.ShaderLayer[]{new ShaderCase.ShaderLayer(new ResourceLocation("immersiveengineering", "textures/models/shaders/minecart_0.png"), bodyColor), new ShaderCase.ShaderLayer(new ResourceLocation("immersiveengineering", "textures/models/shaders/minecart_1_0.png"), secondaryColor)}).add((Object[])additionalLayers).add((Object)UNCOLORED_MINECART_LAYER).add((Object[])topLayers).build()), (EnumRarity)rarity);
    }

    private static ShaderCaseBalloon registerShaderCaseBalloon(String name, int gripColor, int bodyColor, EnumRarity rarity, ShaderCase.ShaderLayer[] additionalLayers, ShaderCase.ShaderLayer ... topLayers) {
        ImmutableList.Builder shaderLayerBuilder = ImmutableList.builder();
        return (ShaderCaseBalloon)ShaderRegistry.registerShaderCase((String)name, (ShaderCase)new ShaderCaseBalloon((Collection)shaderLayerBuilder.add((Object[])new ShaderCase.ShaderLayer[]{new ShaderCase.ShaderLayer(PROCESSED_BALLOON_LAYER, gripColor), new ShaderCase.ShaderLayer(PROCESSED_BALLOON_LAYER, bodyColor)}).add((Object[])additionalLayers).add((Object)UNCOLORED_BALLOON_LAYER).add((Object[])topLayers).build()), (EnumRarity)rarity);
    }

    static {
        RARITY = TwilightForestMod.getRarity();
        if (RARITY != EnumRarity.EPIC) {
            ShaderRegistry.rarityWeightMap.put(RARITY, 1);
        }
        IEShaderRegister.initShaders();
    }

    public static enum CaseType {
        REVOLVER,
        CHEMICAL_THROWER,
        DRILL,
        RAILGUN,
        SHIELD,
        MINECART,
        BALLOON;


        public static CaseType[] everythingButMinecart() {
            return new CaseType[]{REVOLVER, CHEMICAL_THROWER, DRILL, RAILGUN, SHIELD, BALLOON};
        }
    }

    public static enum ModType {
        IMMERSIVE_ENGINEERING("immersiveengineering"){

            @Override
            String getPath(CaseType caseType, String suffix) {
                switch (caseType) {
                    case REVOLVER: {
                        return "revolvers/shaders/revolver_" + suffix;
                    }
                    case CHEMICAL_THROWER: {
                        return "items/shaders/chemthrower_" + suffix;
                    }
                    case DRILL: {
                        return "items/shaders/drill_diesel_" + suffix;
                    }
                    case RAILGUN: {
                        return "items/shaders/railgun_" + suffix;
                    }
                    case SHIELD: {
                        return "items/shaders/shield_" + suffix;
                    }
                    case MINECART: {
                        return "textures/models/shaders/minecart_" + suffix + ".png";
                    }
                    case BALLOON: {
                        return "blocks/shaders/balloon_" + suffix;
                    }
                }
                return "";
            }
        }
        ,
        TWILIGHT_FOREST("twilightforest"){

            @Override
            String getPath(CaseType caseType, String suffix) {
                switch (caseType) {
                    case REVOLVER: {
                        return "items/immersiveengineering/revolver_" + suffix;
                    }
                    case CHEMICAL_THROWER: {
                        return "items/immersiveengineering/chemthrower_" + suffix;
                    }
                    case DRILL: {
                        return "items/immersiveengineering/drill_" + suffix;
                    }
                    case RAILGUN: {
                        return "items/immersiveengineering/railgun_" + suffix;
                    }
                    case SHIELD: {
                        return "items/immersiveengineering/shield_" + suffix;
                    }
                    case MINECART: {
                        return "textures/model/immersiveengineering/minecart_" + suffix + ".png";
                    }
                    case BALLOON: {
                        return "blocks/immersiveengineering/balloon_" + suffix;
                    }
                }
                return "";
            }

            @Override
            public ResourceLocation provideTex(CaseType caseType, String suffix) {
                if (caseType == CaseType.MINECART && suffix.startsWith("1_")) {
                    return IMMERSIVE_ENGINEERING.provideTex(caseType, suffix);
                }
                return super.provideTex(caseType, suffix);
            }
        };

        private final String namespace;

        private ModType(String namespace) {
            this.namespace = namespace;
        }

        abstract String getPath(CaseType var1, String var2);

        public ResourceLocation provideTex(CaseType caseType, String suffix) {
            return new ResourceLocation(this.namespace, this.getPath(caseType, suffix));
        }
    }

    @FunctionalInterface
    private static interface ShaderLayerProvider<T extends ShaderCase.ShaderLayer> {
        public T get(ModType var1, CaseType var2, String var3, int var4);
    }

    private static class ShaderConsumerLayer
    extends ShaderCase.DynamicShaderLayer {
        private final TriConsumer<IntConsumer, Boolean, Float> render;
        private final IntConsumer shaderCallback;

        ShaderConsumerLayer(ResourceLocation texture, int colour, TriConsumer<IntConsumer, Boolean, Float> render, ShaderUniform ... shaderParams) {
            super(texture, colour);
            this.render = render;
            this.shaderCallback = shader -> {
                for (ShaderUniform param : shaderParams) {
                    param.assignUniform(shader);
                }
            };
        }

        public void modifyRender(boolean pre, float partialTick) {
            this.render.accept((Object)this.shaderCallback, (Object)pre, (Object)Float.valueOf(partialTick));
        }
    }
}

