/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import twilightforest.TFConfig;
import twilightforest.TFFeature;
import twilightforest.advancements.TFAdvancements;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.block.TFBlocks;
import twilightforest.network.PacketStructureProtection;
import twilightforest.network.PacketStructureProtectionClear;
import twilightforest.network.TFPacketHandler;
import twilightforest.util.StructureBoundingBoxUtils;
import twilightforest.world.ChunkGeneratorTFBase;
import twilightforest.world.TFWorld;

@Mod.EventBusSubscriber(modid="twilightforest")
public class TFTickHandler {
    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        World world = player.field_70170_p;
        if (!world.field_72995_K && !TFConfig.disablePortalCreation && event.phase == TickEvent.Phase.END && player.field_70173_aa % (TFConfig.checkPortalDestination ? 100 : 20) == 0) {
            if (TFConfig.adminOnlyPortals) {
                if (FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152603_m().func_187452_a(player.func_146103_bH()) != 0) {
                    TFTickHandler.checkForPortalCreation(player, world, 4.0f);
                }
            } else {
                TFTickHandler.checkForPortalCreation(player, world, 32.0f);
            }
        }
        if (!world.field_72995_K && event.phase == TickEvent.Phase.END && player.field_70173_aa % 20 == 0 && TFWorld.isProgressionEnforced(world) && TFWorld.isTwilightForest(world) && !player.func_184812_l_() && !player.func_175149_v()) {
            TFTickHandler.checkBiomeForProgression(player, world);
        }
        if (!world.field_72995_K && event.phase == TickEvent.Phase.END && player.field_70173_aa % 100 == 0 && TFWorld.isProgressionEnforced(world) && TFWorld.isTwilightForest(world)) {
            if (player.func_184812_l_() || player.func_175149_v()) {
                TFTickHandler.sendAllClearPacket(world, player);
            } else {
                TFTickHandler.checkForLockedStructuresSendPacket(player, world);
            }
        }
    }

    private static void sendStructureProtectionPacket(World world, EntityPlayer player, StructureBoundingBox sbb) {
        if (player instanceof EntityPlayerMP) {
            TFPacketHandler.CHANNEL.sendTo((IMessage)new PacketStructureProtection(sbb), (EntityPlayerMP)player);
        }
    }

    private static void sendAllClearPacket(World world, EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            TFPacketHandler.CHANNEL.sendTo((IMessage)new PacketStructureProtectionClear(), (EntityPlayerMP)player);
        }
    }

    private static boolean checkForLockedStructuresSendPacket(EntityPlayer player, World world) {
        int pz;
        ChunkGeneratorTFBase chunkGenerator = TFWorld.getChunkGenerator(world);
        if (chunkGenerator == null) {
            return false;
        }
        int px = MathHelper.func_76128_c((double)player.field_70165_t);
        StructureBoundingBox fullSBB = chunkGenerator.getFullSBBNear(px, pz = MathHelper.func_76128_c((double)player.field_70161_v), 100);
        if (fullSBB != null) {
            Vec3i center = StructureBoundingBoxUtils.getCenter(fullSBB);
            TFFeature nearFeature = TFFeature.getFeatureForRegionPos(center.func_177958_n(), center.func_177952_p(), world);
            if (!nearFeature.hasProtectionAura || nearFeature.doesPlayerHaveRequiredAdvancements(player)) {
                TFTickHandler.sendAllClearPacket(world, player);
                return false;
            }
            TFTickHandler.sendStructureProtectionPacket(world, player, fullSBB);
            return true;
        }
        return false;
    }

    private static void checkForPortalCreation(EntityPlayer player, World world, float rangeToCheck) {
        if (world.field_73011_w.getDimension() == TFConfig.originDimension || world.field_73011_w.getDimension() == TFConfig.dimension.dimensionID || TFConfig.allowPortalsInOtherDimensions) {
            List itemList = world.func_72872_a(EntityItem.class, player.func_174813_aQ().func_186662_g((double)rangeToCheck));
            for (EntityItem entityItem : itemList) {
                BlockPos pos;
                IBlockState state;
                if (!TFConfig.portalIngredient.apply(entityItem.func_92059_d()) || !TFBlocks.twilight_portal.canFormPortal(state = world.func_180495_p(pos = entityItem.func_180425_c()))) continue;
                Random rand = new Random();
                for (int i = 0; i < 2; ++i) {
                    double vx = rand.nextGaussian() * 0.02;
                    double vy = rand.nextGaussian() * 0.02;
                    double vz = rand.nextGaussian() * 0.02;
                    world.func_175688_a(EnumParticleTypes.SPELL, entityItem.field_70165_t, entityItem.field_70163_u + 0.2, entityItem.field_70161_v, vx, vy, vz, new int[0]);
                }
                if (!TFBlocks.twilight_portal.tryToCreatePortal(world, pos, entityItem, player)) continue;
                TFAdvancements.MADE_TF_PORTAL.trigger((EntityPlayerMP)player);
                return;
            }
        }
    }

    private static void checkBiomeForProgression(EntityPlayer player, World world) {
        TFBiomeBase tfBiome;
        Biome currentBiome = world.func_180494_b(new BlockPos((Entity)player));
        if (currentBiome instanceof TFBiomeBase && !(tfBiome = (TFBiomeBase)currentBiome).doesPlayerHaveRequiredAdvancements(player)) {
            tfBiome.enforceProgression(player, world);
        }
    }
}

