/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalcultivation.item;

import cofh.api.item.IInventoryContainerItem;
import cofh.api.item.IMultiModeItem;
import cofh.api.item.INBTCopyIngredient;
import cofh.core.gui.container.InventoryContainerItemWrapper;
import cofh.core.init.CoreEnchantments;
import cofh.core.init.CoreProps;
import cofh.core.item.IEnchantableItem;
import cofh.core.item.ItemMulti;
import cofh.core.key.KeyBindingItemMultiMode;
import cofh.core.render.IModelRegister;
import cofh.core.util.CoreUtils;
import cofh.core.util.core.IInitializer;
import cofh.core.util.helpers.ChatHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.MathHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalcultivation.ThermalCultivation;
import cofh.thermalfoundation.init.TFProps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemSeedBag
extends ItemMulti
implements IInitializer,
IMultiModeItem,
IInventoryContainerItem,
IEnchantableItem,
INBTCopyIngredient {
    private static Int2ObjectOpenHashMap<TypeEntry> typeMap = new Int2ObjectOpenHashMap();
    private static HashMap<Item, Integer> colorMap = new HashMap();
    public static final int CREATIVE = 32000;
    public static boolean enable = true;
    public static ItemStack seedBagBasic;
    public static ItemStack seedBagHardened;
    public static ItemStack seedBagReinforced;
    public static ItemStack seedBagSignalum;
    public static ItemStack seedBagResonant;
    public static ItemStack seedBagCreative;

    public ItemSeedBag() {
        super("thermalcultivation");
        this.func_77655_b("seed_bag");
        this.func_77637_a(ThermalCultivation.tabTools);
        this.func_77627_a(true);
        this.func_77625_d(1);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            Iterator iterator = this.itemList.iterator();
            while (iterator.hasNext()) {
                int metadata = (Integer)iterator.next();
                if (metadata != 32000) {
                    items.add((Object)this.setDefaultInventoryTag(new ItemStack((Item)this, 1, metadata)));
                    continue;
                }
                if (!TFProps.showCreativeItems) continue;
                items.add((Object)this.setDefaultInventoryTag(new ItemStack((Item)this, 1, metadata)));
            }
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flagIn) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        int range = this.getRange(stack) * 2 + 1;
        tooltip.add(StringHelper.getInfoText((String)"info.thermalcultivation.seed_bag.0"));
        tooltip.add(StringHelper.localize((String)"info.cofh.area") + ": " + range + "x" + range);
        if (this.getNumModes(stack) > 1) {
            tooltip.add(StringHelper.localizeFormat((String)"info.thermalcultivation.seed_bag.1", (Object[])new Object[]{StringHelper.getKeyName((int)KeyBindingItemMultiMode.INSTANCE.getKey())}));
        }
        ItemHelper.addInventoryInformation((ItemStack)stack, tooltip);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (CoreUtils.isFakePlayer((Entity)player) || hand != EnumHand.MAIN_HAND) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (!stack.func_77942_o()) {
            this.setDefaultInventoryTag(stack);
        }
        if (player.func_70093_af()) {
            player.openGui((Object)ThermalCultivation.instance, 0, world, 0, 0, 0);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (CoreUtils.isFakePlayer((Entity)player) || hand != EnumHand.MAIN_HAND) {
            return EnumActionResult.FAIL;
        }
        if (!stack.func_77942_o()) {
            this.setDefaultInventoryTag(stack);
        }
        if (facing != EnumFacing.UP) {
            return EnumActionResult.FAIL;
        }
        if (ServerHelper.isServerWorld((World)world)) {
            int range = this.getRange(stack);
            InventoryContainerItemWrapper wrapper = new InventoryContainerItemWrapper(stack);
            for (int x = -range; x <= range; ++x) {
                block1: for (int z = -range; z <= range; ++z) {
                    BlockPos target = pos.func_177982_a(x, 0, z);
                    for (int i = 0; i < wrapper.func_70302_i_(); ++i) {
                        ItemStack item = wrapper.func_70301_a(i);
                        if (item.func_190926_b() || !(item.func_77973_b() instanceof IPlantable)) continue;
                        IPlantable plantable = (IPlantable)item.func_77973_b();
                        IBlockState state = world.func_180495_p(target);
                        if (!player.func_175151_a(target.func_177972_a(facing), facing, item) || !state.func_177230_c().canSustainPlant(state, (IBlockAccess)world, target, EnumFacing.UP, plantable) || !world.func_175623_d(target.func_177984_a())) continue;
                        world.func_175656_a(target.func_177984_a(), plantable.getPlant((IBlockAccess)world, target));
                        if (player instanceof EntityPlayerMP) {
                            CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, target.func_177984_a(), item);
                        }
                        if (ItemSeedBag.isCreative((ItemStack)stack)) continue block1;
                        item.func_190918_g(1);
                        continue block1;
                    }
                }
            }
            wrapper.func_70296_d();
        }
        return EnumActionResult.SUCCESS;
    }

    public boolean func_77662_d() {
        return true;
    }

    public boolean func_77616_k(ItemStack stack) {
        return !ItemSeedBag.isCreative((ItemStack)stack);
    }

    public int func_77619_b() {
        return 10;
    }

    public boolean canEnchant(ItemStack stack, Enchantment enchantment) {
        return ItemHelper.getItemDamage((ItemStack)stack) != 32000 && enchantment == CoreEnchantments.holding;
    }

    public ItemStack setDefaultInventoryTag(ItemStack container) {
        if (container.func_77978_p() == null) {
            container.func_77982_d(new NBTTagCompound());
        }
        container.func_77978_p().func_74768_a("Mode", this.getNumModes(container) - 1);
        return container;
    }

    @SideOnly(value=Side.CLIENT)
    public static int getSeedColor(Item seed) {
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(new ItemStack(seed)).func_177554_e();
        int[] data = sprite.func_147965_a(0)[0];
        long[] avgColor = new long[3];
        int dropped = 0;
        int minDiversion = 15;
        for (int j = 0; j < sprite.func_94216_b(); ++j) {
            for (int i = 0; i < sprite.func_94211_a(); ++i) {
                int color = data[j * sprite.func_94211_a() + i];
                int red = color & 0xFF;
                int green = color >> 8 & 0xFF;
                int blue = color >> 16 & 0xFF;
                if (Math.abs(red - green) > minDiversion || Math.abs(red - blue) > minDiversion || Math.abs(green - blue) > minDiversion) {
                    avgColor[2] = avgColor[2] + (long)red;
                    avgColor[1] = avgColor[1] + (long)green;
                    avgColor[0] = avgColor[0] + (long)blue;
                    continue;
                }
                ++dropped;
            }
        }
        int count = sprite.func_94211_a() * sprite.func_94216_b() - dropped;
        int avgR = (int)(avgColor[2] / (long)count);
        int avgG = (int)(avgColor[1] / (long)count);
        int avgB = (int)(avgColor[0] / (long)count);
        return avgR | avgG << 8 | avgB << 16;
    }

    public static boolean onItemPickup(EntityItemPickupEvent event, ItemStack stack) {
        ItemStack eventItem = event.getItem().func_92059_d();
        int count = eventItem.func_190916_E();
        if (ItemSeedBag.getCurrentSeed(stack) == null || !eventItem.func_77973_b().equals(ItemSeedBag.getCurrentSeed(stack))) {
            return false;
        }
        InventoryContainerItemWrapper inv = new InventoryContainerItemWrapper(stack);
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack slot = inv.func_70301_a(i);
            if (ItemHandlerHelper.canItemStacksStackRelaxed((ItemStack)eventItem, (ItemStack)slot)) {
                int fill = slot.func_77976_d() - slot.func_190916_E();
                if (fill > eventItem.func_190916_E()) {
                    slot.func_190920_e(slot.func_190916_E() + eventItem.func_190916_E());
                } else {
                    slot.func_190920_e(slot.func_77976_d());
                }
                eventItem.func_77979_a(fill);
            } else if (slot.func_190926_b()) {
                inv.func_70299_a(i, eventItem.func_77946_l());
                eventItem.func_190920_e(0);
            }
            if (eventItem.func_190926_b()) break;
        }
        if (eventItem.func_190916_E() != count) {
            stack.func_190915_d(5);
            EntityPlayer player = event.getEntityPlayer();
            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((MathHelper.RANDOM.nextFloat() - MathHelper.RANDOM.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            inv.func_70296_d();
        }
        eventItem.func_190920_e(0);
        return eventItem.func_190926_b();
    }

    public static int getLevel(ItemStack stack) {
        if (!typeMap.containsKey(ItemHelper.getItemDamage((ItemStack)stack))) {
            return 0;
        }
        return ((TypeEntry)ItemSeedBag.typeMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).level;
    }

    public static Item getCurrentSeed(ItemStack stack) {
        InventoryContainerItemWrapper wrapper = new InventoryContainerItemWrapper(stack);
        for (int i = 0; i < wrapper.func_70302_i_(); ++i) {
            ItemStack item = wrapper.func_70301_a(i);
            if (item.func_190926_b()) continue;
            return item.func_77973_b();
        }
        return null;
    }

    public int getMaxRange(int metadata) {
        if (!typeMap.containsKey(metadata)) {
            return 0;
        }
        return ((TypeEntry)ItemSeedBag.typeMap.get((int)metadata)).range;
    }

    public int getRange(ItemStack stack) {
        return 1 + this.getMode(stack);
    }

    public static boolean hasHoldingEnchant(ItemStack stack) {
        return EnchantmentHelper.func_77506_a((Enchantment)CoreEnchantments.holding, (ItemStack)stack) > 0;
    }

    public static int getStorageIndex(ItemStack stack) {
        if (ItemSeedBag.isCreative((ItemStack)stack) || !typeMap.containsKey(ItemHelper.getItemDamage((ItemStack)stack))) {
            return 0;
        }
        int level = ((TypeEntry)ItemSeedBag.typeMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).level;
        int enchant = EnchantmentHelper.func_77506_a((Enchantment)CoreEnchantments.holding, (ItemStack)stack);
        return Math.min(1 + level + enchant, CoreProps.STORAGE_SIZE.length - 1);
    }

    public int getNumModes(ItemStack stack) {
        return this.getMaxRange(ItemHelper.getItemDamage((ItemStack)stack));
    }

    public void onModeChange(EntityPlayer player, ItemStack stack) {
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187907_gg, SoundCategory.PLAYERS, 0.6f, 1.0f - 0.1f * (float)this.getMode(stack));
        int radius = this.getRange(stack) * 2 + 1;
        ChatHelper.sendIndexedChatMessageToPlayer((EntityPlayer)player, (ITextComponent)new TextComponentTranslation("info.cofh.area", new Object[0]).func_150258_a(": " + radius + "x" + radius));
    }

    public int getSizeInventory(ItemStack container) {
        return CoreProps.STORAGE_SIZE[ItemSeedBag.getStorageIndex(container)];
    }

    public boolean preInit() {
        ForgeRegistries.ITEMS.register(this.setRegistryName("seed_bag"));
        ThermalCultivation.proxy.addIModelRegister((IModelRegister)this);
        ItemSeedBag.config();
        seedBagBasic = this.addEntryItem(0, "standard0", 0, 1, EnumRarity.COMMON);
        seedBagHardened = this.addEntryItem(1, "standard1", 1, 2, EnumRarity.COMMON);
        seedBagReinforced = this.addEntryItem(2, "standard2", 2, 3, EnumRarity.UNCOMMON);
        seedBagSignalum = this.addEntryItem(3, "standard3", 3, 4, EnumRarity.UNCOMMON);
        seedBagResonant = this.addEntryItem(4, "standard4", 4, 5, EnumRarity.RARE);
        seedBagCreative = this.addEntryItem(32000, "creative", 4, 5, EnumRarity.EPIC);
        return true;
    }

    public boolean initialize() {
        return enable;
    }

    private static void config() {
        String category = "Item.SeedBag";
        enable = ThermalCultivation.CONFIG.get(category, "Enable", true);
    }

    private void addEntry(int metadata, String name, int level, int radius) {
        typeMap.put(metadata, (Object)new TypeEntry(name, level, radius));
    }

    private ItemStack addEntryItem(int metadata, String name, int level, int radius, EnumRarity rarity) {
        this.addEntry(metadata, name, level, radius);
        return this.addItem(metadata, name, rarity);
    }

    public class TypeEntry {
        public final String name;
        public final int level;
        public final int range;

        TypeEntry(String name, int level, int range) {
            this.name = name;
            this.level = level;
            this.range = range;
        }
    }
}

