/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.extrarails.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.shadowfacts.extrarails.ExtraRails;
import net.shadowfacts.extrarails.block.base.BlockExtraRail;
import net.shadowfacts.extrarails.tileentity.TileEntityRailComparator;

public class BlockRailComparator
extends BlockExtraRail {
    protected BlockRailComparator() {
        super(true);
        this.setRegistryName("comparator_rail");
        this.func_149663_c(this.getRegistryName().toString());
    }

    private void updatePower(World world, BlockPos pos, EntityMinecart minecart) {
        int level = 0;
        if (minecart instanceof IInventory) {
            level = Container.func_94526_b((IInventory)((IInventory)minecart));
        } else if (minecart.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN) || minecart instanceof IItemHandler) {
            IItemHandler handler = minecart.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.NORTH) ? (IItemHandler)minecart.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN) : (IItemHandler)minecart;
            int slots = 0;
            float filled = 0.0f;
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                if (stack == null) continue;
                filled += (float)stack.func_190916_E() / (float)stack.func_77976_d();
                ++slots;
            }
            level = MathHelper.func_76141_d((float)((filled /= (float)slots) * 14.0f)) + (slots > 0 ? 1 : 0);
        }
        TileEntityRailComparator te = (TileEntityRailComparator)world.func_175625_s(pos);
        if (te.getPower() != level) {
            te.setPower(level);
            world.func_175685_c(pos, (Block)this, false);
            world.func_175704_b(pos, pos);
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        List<? extends EntityMinecart> minecarts = this.findMinecarts(world, pos);
        if (minecarts.isEmpty()) {
            ((TileEntityRailComparator)world.func_175625_s(pos)).setPower(0);
            world.func_175685_c(pos, (Block)this, false);
            world.func_175704_b(pos, pos);
        } else {
            this.updatePower(world, pos, minecarts.get(0));
            world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (entity instanceof EntityMinecart) {
            this.updatePower(world, pos, (EntityMinecart)entity);
            world.func_175684_a(pos instanceof BlockPos.MutableBlockPos ? new BlockPos((Vec3i)pos) : pos, (Block)this, this.func_149738_a(world));
        }
    }

    @Deprecated
    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    @Deprecated
    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return ((TileEntityRailComparator)world.func_175625_s(pos)).getPower();
    }

    @Deprecated
    public int func_176211_b(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return ((TileEntityRailComparator)world.func_175625_s(pos)).getPower();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileEntityRailComparator();
    }

    @Override
    public void initItemModel() {
        ExtraRails.proxy.registerItemModel((Block)this, 0, this.getRegistryName().func_110623_a());
    }

    @Override
    @Nonnull
    @Deprecated
    public IBlockState func_176203_a(int meta) {
        BlockRailBase.EnumRailDirection shape = BlockRailBase.EnumRailDirection.func_177016_a((int)(meta & 1));
        EnumFacing facing = EnumFacing.func_176731_b((int)(meta >> 1));
        return this.func_176223_P().func_177226_a((IProperty)SHAPE, (Comparable)shape).func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    @Override
    public int func_176201_c(IBlockState state) {
        BlockRailBase.EnumRailDirection shape = (BlockRailBase.EnumRailDirection)state.func_177229_b((IProperty)SHAPE);
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        int meta = 0;
        meta |= shape.func_177015_a();
        return meta |= facing.func_176736_b() << 1;
    }

    @Override
    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SHAPE, FACING});
    }
}

