/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.server.item;

import com.pau101.fairylights.FairyLights;
import com.pau101.fairylights.server.item.LightVariant;
import com.pau101.fairylights.util.Utils;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.translation.I18n;

public final class ItemLight
extends Item {
    public static final int COLOR_COUNT = 16;

    public ItemLight() {
        this.func_77637_a(FairyLights.fairyLightsTab);
        this.func_77627_a(true);
        Utils.name(this, "light");
    }

    public String func_77653_i(ItemStack stack) {
        String localizedLightName = I18n.func_74838_a((String)(super.func_77667_c(stack) + '.' + ItemLight.getLightVariant(stack.func_77960_j()).getUnlocalizedName() + ".name"));
        return Utils.formatColored(ItemLight.getLightColor(stack.func_77960_j()), localizedLightName);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            LightVariant[] variants = LightVariant.values();
            for (int variant = 0; variant < variants.length; ++variant) {
                if (variants[variant] == LightVariant.LUXO_BALL) continue;
                for (int color = 0; color < 16; ++color) {
                    subItems.add((Object)new ItemStack((Item)this, 1, variant * 16 + color));
                }
            }
        }
    }

    public static final int getLightMeta(LightVariant variant, EnumDyeColor color) {
        return ItemLight.getLightMeta(variant, color.ordinal());
    }

    public static final int getLightMeta(LightVariant variant, int color) {
        return variant.ordinal() * 16 + color;
    }

    public static final EnumDyeColor getLightColor(int meta) {
        return EnumDyeColor.func_176766_a((int)ItemLight.getLightColorOrdinal(meta));
    }

    public static final LightVariant getLightVariant(int meta) {
        return LightVariant.getLightVariant(ItemLight.getLightVariantOrdinal(meta));
    }

    public static final byte getLightColorOrdinal(int meta) {
        return (byte)(meta % 16);
    }

    public static final int getLightVariantOrdinal(int meta) {
        return meta / 16;
    }

    public static final int getColorValue(EnumDyeColor color) {
        if (color == EnumDyeColor.BLACK) {
            return 0x323232;
        }
        if (color == EnumDyeColor.GRAY) {
            return 0x606060;
        }
        float[] rgb = color.func_193349_f();
        return (int)(rgb[0] * 255.0f) << 16 | (int)(rgb[1] * 255.0f) << 8 | (int)(rgb[2] * 255.0f);
    }
}

