/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.server.entity;

import com.google.common.base.Throwables;
import com.pau101.fairylights.server.ServerProxy;
import com.pau101.fairylights.server.block.FLBlocks;
import com.pau101.fairylights.server.capability.CapabilityHandler;
import com.pau101.fairylights.server.fastener.Fastener;
import com.pau101.fairylights.server.item.ItemConnection;
import com.pau101.fairylights.server.net.clientbound.MessageUpdateFastenerEntity;
import com.pau101.fairylights.util.Utils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public final class EntityFenceFastener
extends EntityHanging
implements IEntityAdditionalSpawnData {
    public EntityFenceFastener(World world) {
        super(world);
    }

    public EntityFenceFastener(World world, BlockPos pos) {
        super(world);
        this.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public int func_82329_d() {
        return 9;
    }

    public int func_82330_g() {
        return 9;
    }

    public float func_70047_e() {
        return 1.0f;
    }

    public float func_70013_c() {
        BlockPos pos = new BlockPos((Entity)this);
        if (this.field_70170_p.func_175667_e(pos)) {
            return this.field_70170_p.func_175724_o(pos);
        }
        return 0.0f;
    }

    public int func_70070_b() {
        BlockPos pos = new BlockPos((Entity)this);
        if (this.field_70170_p.func_175667_e(pos)) {
            return this.field_70170_p.func_175626_b(pos, 0);
        }
        return 0;
    }

    public boolean func_70112_a(double distance) {
        return distance < 4096.0;
    }

    public boolean func_180427_aV() {
        return true;
    }

    public boolean func_70518_d() {
        return ItemConnection.isFence(this.field_70170_p.func_180495_p(this.field_174861_a), this.field_70170_p.func_175625_s(this.field_174861_a));
    }

    public void func_70106_y() {
        super.func_70106_y();
        this.getFastener().remove();
    }

    public String func_70005_c_() {
        return Utils.getEntityName((Entity)this);
    }

    public void func_110128_b(@Nullable Entity breaker) {
        this.getFastener().dropItems(this.field_70170_p, this.field_174861_a);
        if (breaker != null) {
            this.field_70170_p.func_175718_b(2001, this.field_174861_a, Block.func_176210_f((IBlockState)FLBlocks.FASTENER.func_176223_P()));
        }
    }

    public void func_184523_o() {
        SoundType sound = FLBlocks.FASTENER.getSoundType(FLBlocks.FASTENER.func_176223_P(), this.field_70170_p, this.func_174857_n(), null);
        this.func_184185_a(sound.func_185841_e(), (sound.func_185843_a() + 1.0f) / 2.0f, sound.func_185847_b() * 0.8f);
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.BLOCKS;
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b((double)MathHelper.func_76128_c((double)x) + 0.5, (double)MathHelper.func_76128_c((double)y) + 0.5, (double)MathHelper.func_76128_c((double)z) + 0.5);
    }

    public void func_174859_a(EnumFacing facing) {
    }

    protected void func_174856_o() {
        this.field_70165_t = (double)this.field_174861_a.func_177958_n() + 0.5;
        this.field_70163_u = (double)this.field_174861_a.func_177956_o() + 0.5;
        this.field_70161_v = (double)this.field_174861_a.func_177952_p() + 0.5;
        float w = 0.1875f;
        float h = 0.1875f;
        this.func_174826_a(new AxisAlignedBB(this.field_70165_t - 0.1875, this.field_70163_u - 0.1875, this.field_70161_v - 0.1875, this.field_70165_t + 0.1875, this.field_70163_u + 0.1875, this.field_70161_v + 0.1875));
    }

    public AxisAlignedBB func_184177_bl() {
        return this.getFastener().getBounds().func_186662_g(1.0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        Fastener<?> fastener = this.getFastener();
        if (!this.field_70170_p.field_72995_K && fastener.hasNoConnections()) {
            this.func_70106_y();
            this.func_110128_b(null);
        } else if (fastener.update() && !this.field_70170_p.field_72995_K) {
            MessageUpdateFastenerEntity msg = new MessageUpdateFastenerEntity((Entity)this, fastener.serializeNBT());
            ServerProxy.sendToPlayersWatchingEntity(msg, this.field_70170_p, (Entity)this);
        }
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() instanceof ItemConnection) {
            if (this.field_70170_p.field_72995_K) {
                player.func_184609_a(hand);
            } else {
                ((ItemConnection)stack.func_77973_b()).connect(stack, player, this.field_70170_p, this.getFastener());
            }
            return true;
        }
        return super.func_184230_a(player, hand);
    }

    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74782_a("pos", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.field_174861_a));
    }

    public void func_70037_a(NBTTagCompound compound) {
        this.field_174861_a = NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("pos"));
    }

    public void writeSpawnData(ByteBuf buf) {
        Fastener<?> fastener = this.getFastener();
        try {
            CompressedStreamTools.func_74800_a((NBTTagCompound)fastener.serializeNBT(), (DataOutput)new ByteBufOutputStream(buf));
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    public void readSpawnData(ByteBuf buf) {
        Fastener<?> fastener = this.getFastener();
        try {
            fastener.deserializeNBT((NBTBase)CompressedStreamTools.func_152456_a((DataInput)new ByteBufInputStream(buf), (NBTSizeTracker)new NBTSizeTracker(0x200000L)));
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    private Fastener<?> getFastener() {
        return (Fastener)this.getCapability(CapabilityHandler.FASTENER_CAP, null);
    }

    public static EntityFenceFastener create(World world, BlockPos fence) {
        EntityFenceFastener fastener = new EntityFenceFastener(world, fence);
        fastener.field_98038_p = true;
        world.func_72838_d((Entity)fastener);
        fastener.func_184523_o();
        return fastener;
    }

    @Nullable
    public static EntityFenceFastener find(World world, BlockPos pos) {
        EntityHanging entity = EntityFenceFastener.findHanging(world, pos);
        if (entity instanceof EntityFenceFastener) {
            return (EntityFenceFastener)entity;
        }
        return null;
    }

    @Nullable
    public static EntityHanging findHanging(World world, BlockPos pos) {
        for (EntityHanging e : world.func_72872_a(EntityHanging.class, new AxisAlignedBB(pos).func_186662_g(2.0))) {
            if (!e.func_174857_n().equals((Object)pos)) continue;
            return e;
        }
        return null;
    }
}

