/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.tileentity;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.common.Function;
import shetiphian.platforms.common.helpers.EnumHelper;
import shetiphian.platforms.common.tileentity.TileEntityTypeBase;
import shetiphian.platforms.common.tileentity.TileEntityTypeBaseWithRail;

public class TileEntityPlatformTypes {

    public static class TileEntityPlatformRise
    extends TileEntityTypeBase {
        private byte riseType = 0;
        private boolean linkedToRamp = false;
        private boolean linkedToFloor = false;
        private boolean isRail = false;

        @Override
        protected void buildNBT(NBTTagCompound nbtTag) {
            super.buildNBT(nbtTag);
            nbtTag.func_74774_a("riseType", this.riseType);
            nbtTag.func_74757_a("linkedToRamp", this.linkedToRamp);
            nbtTag.func_74757_a("linkedToFloor", this.linkedToFloor);
            nbtTag.func_74757_a("isRail", this.isRail);
        }

        @Override
        protected void processNBT(NBTTagCompound nbtTag) {
            super.processNBT(nbtTag);
            this.riseType = nbtTag.func_74771_c("riseType");
            this.linkedToRamp = nbtTag.func_74767_n("linkedToRamp");
            this.linkedToFloor = nbtTag.func_74767_n("linkedToFloor");
            this.isRail = nbtTag.func_74767_n("isRail");
        }

        @Override
        public byte getType() {
            return this.riseType;
        }

        @Override
        public void setType(int riseType) {
            this.riseType = (byte)MathHelper.func_76125_a((int)riseType, (int)0, (int)5);
        }

        public void setLinkedToRamp(boolean linkToRamp) {
            this.linkedToRamp = linkToRamp;
        }

        public boolean isLinkedToRamp() {
            return this.linkedToRamp;
        }

        public void setLinkedToFloor(boolean linkedToFloor) {
            this.linkedToFloor = linkedToFloor;
        }

        public boolean isLinkedToFloor() {
            return this.linkedToFloor;
        }

        public void setIsRail(boolean isRail) {
            this.isRail = isRail;
        }

        public boolean isRail() {
            return this.isRail;
        }
    }

    public static class TileEntityPlatformFrame
    extends TileEntityTypeBase {
        private EnumHelper.EnumPlatformTorch torchType = EnumHelper.EnumPlatformTorch.NONE;

        @Override
        protected void buildNBT(NBTTagCompound nbtTag) {
            super.buildNBT(nbtTag);
            nbtTag.func_74774_a("torchType", this.torchType.VALUE);
        }

        @Override
        protected void processNBT(NBTTagCompound nbtTag) {
            super.processNBT(nbtTag);
            this.torchType = EnumHelper.getTorch(nbtTag.func_74771_c("torchType"));
        }

        protected void processNBT_SyncOnly(NBTTagCompound nbtTag) {
            super.processNBT_SyncOnly(nbtTag);
            Function.updateLighting((TileEntity)this);
        }

        @Override
        public byte getType() {
            return 0;
        }

        @Override
        public void setType(int frameType) {
        }

        public EnumHelper.EnumPlatformTorch getTorchType() {
            return this.torchType;
        }

        public boolean setTorchType(EnumHelper.EnumPlatformTorch torchType) {
            if (torchType != null && torchType != EnumHelper.EnumPlatformTorch.NONE) {
                this.torchType = torchType;
                return true;
            }
            return false;
        }

        public void removeTorch() {
            switch (this.torchType) {
                case GLOWSTONE: {
                    this.torchType = EnumHelper.EnumPlatformTorch.LIGHT;
                    return;
                }
                case LAMP_OFF: {
                    this.torchType = EnumHelper.EnumPlatformTorch.REDSTONE_ON;
                    return;
                }
                case LAMP_ON: {
                    this.torchType = EnumHelper.EnumPlatformTorch.REDSTONE_OFF;
                    return;
                }
            }
            this.torchType = EnumHelper.EnumPlatformTorch.NONE;
        }
    }

    public static class TileEntityPlatformFloor
    extends TileEntityTypeBaseWithRail {
        private byte floorType = 0;
        private byte altSupport = 0;

        @Override
        protected void buildNBT(NBTTagCompound nbtTag) {
            super.buildNBT(nbtTag);
            nbtTag.func_74774_a("flatType", this.floorType);
            nbtTag.func_74774_a("altSupport", this.altSupport);
        }

        @Override
        protected void processNBT(NBTTagCompound nbtTag) {
            super.processNBT(nbtTag);
            this.floorType = nbtTag.func_74771_c("flatType");
            this.altSupport = nbtTag.func_74771_c("altSupport");
        }

        @Override
        public byte getType() {
            return this.floorType;
        }

        @Override
        public void setType(int flatType) {
            this.floorType = (byte)MathHelper.func_76125_a((int)flatType, (int)0, (int)14);
        }

        public byte getAltSupport() {
            return this.altSupport;
        }

        public void setAltSupport(int altSupport) {
            this.altSupport = (byte)MathHelper.func_76125_a((int)altSupport, (int)0, (int)2);
        }
    }

    public static class TileEntityPlatformRamp
    extends TileEntityTypeBaseWithRail {
        private byte rampType = 0;
        private byte altSupport = 0;

        @Override
        protected void buildNBT(NBTTagCompound nbtTag) {
            super.buildNBT(nbtTag);
            nbtTag.func_74774_a("rampType", this.rampType);
            nbtTag.func_74774_a("altSupport", this.altSupport);
        }

        @Override
        protected void processNBT(NBTTagCompound nbtTag) {
            super.processNBT(nbtTag);
            this.rampType = nbtTag.func_74771_c("rampType");
            this.altSupport = nbtTag.func_74771_c("altSupport");
        }

        @Override
        public byte getType() {
            return this.rampType;
        }

        @Override
        public void setType(int rampType) {
            this.rampType = (byte)MathHelper.func_76125_a((int)rampType, (int)0, (int)2);
        }

        public byte getAltSupport() {
            return this.altSupport;
        }

        public void setAltSupport(int altSupport) {
            this.altSupport = (byte)MathHelper.func_76125_a((int)altSupport, (int)0, (int)5);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public AxisAlignedBB getRenderBoundingBox() {
            AxisAlignedBB aabb = super.getRenderBoundingBox();
            aabb.func_72321_a(0.0, 0.25, 0.0);
            return aabb;
        }
    }

    public static class TileEntityPlatformFlat
    extends TileEntityTypeBaseWithRail {
        private byte flatType = 0;

        @Override
        protected void buildNBT(NBTTagCompound nbtTag) {
            super.buildNBT(nbtTag);
            nbtTag.func_74774_a("flatType", this.flatType);
        }

        @Override
        protected void processNBT(NBTTagCompound nbtTag) {
            super.processNBT(nbtTag);
            this.flatType = nbtTag.func_74771_c("flatType");
        }

        @Override
        public byte getType() {
            return this.flatType;
        }

        @Override
        public void setType(int flatType) {
            this.flatType = (byte)MathHelper.func_76125_a((int)flatType, (int)0, (int)14);
        }
    }
}

