/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;
import shetiphian.core.common.Function;
import shetiphian.platforms.common.helpers.CraftHelper;

@Config(modid="platforms", name="platforms")
public class Configuration {
    @Config.Comment(value={"Changes what sneak right-clicking on a platform with a wrench will do", "GUI: opens the platform selector GUI", "CYCLE: cycles through the options", "MIXED: uses the GUI if the is more then 5 options"})
    public static PlatformSelect platformSelect = PlatformSelect.GUI;
    @Config.Comment(value={"By default Wood and Stone Platforms only use blocks registered to the Forge Ore Dictionary but additional blocks can be added here.", "", "Format = \u00a79modId\u00a7r:\u00a72nameId\u00a73@meta", "\u00a79modId\u00a7r can be left off for vanilla blocks, and 'ore' can be used to indicate a dictionary entry", "\u00a72nameId\u00a7r can contain [*] or [#-#] to replace an incrementing number or a number range", "\u00a73@meta\u00a7r can be left off to indicate any meta"})
    public static Menu_Blocks ADDITIONAL_BLOCKS = new Menu_Blocks();
    @Config.Comment(value={""})
    public static Menu_GUI GUI_STYLE = new Menu_GUI();

    @Mod.EventBusSubscriber
    static class EventHandler {
        EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("platforms")) {
                ConfigManager.sync((String)"platforms", (Config.Type)Config.Type.INSTANCE);
                EventHandler.process();
            }
        }

        public static void process() {
            CraftHelper.generateUserPlanks(EventHandler.process(Configuration.ADDITIONAL_BLOCKS.woodBlocks));
            CraftHelper.generateUserStone(EventHandler.process(Configuration.ADDITIONAL_BLOCKS.stoneBlocks));
        }

        private static ArrayList<ItemStack> process(String[] names) {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (String name : names) {
                String nameId;
                if (Strings.isNullOrEmpty((String)name)) continue;
                int meta = Short.MAX_VALUE;
                if (name.contains("@")) {
                    try {
                        meta = Integer.valueOf(name.split("@")[1]);
                        name = name.substring(0, name.lastIndexOf(64));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                String modId = name.contains(":") ? name.split(":")[0] : "minecraft";
                String string = nameId = name.contains(":") ? name.split(":")[1] : name;
                if (modId.equalsIgnoreCase("ore") || modId.equalsIgnoreCase("oredictionary")) {
                    NonNullList ores = OreDictionary.getOres((String)nameId);
                    for (ItemStack ore : ores) {
                        EventHandler.addToList(ore, list);
                    }
                    continue;
                }
                if (nameId.contains("[") && nameId.contains("]")) {
                    String find = "[*]";
                    ItemStack stack = ItemStack.field_190927_a;
                    if (nameId.contains(find)) {
                        for (int index = 0; index < 1 || !stack.func_190926_b(); ++index) {
                            stack = Function.findItemStack((String)modId, (String)nameId.replace(find, "" + index), (int)meta);
                            EventHandler.addToList(stack, list);
                        }
                        continue;
                    }
                    Pattern pattern = Pattern.compile("(\\[(\\d*)-(\\d*)\\])");
                    Matcher matcher = pattern.matcher(nameId);
                    if (!matcher.find()) continue;
                    find = matcher.group(1);
                    int start = EventHandler.getInt(matcher.group(2));
                    int end = EventHandler.getInt(matcher.group(3));
                    for (int index = start; index <= end; ++index) {
                        stack = Function.findItemStack((String)modId, (String)nameId.replace(find, "" + index), (int)meta);
                        EventHandler.addToList(stack, list);
                    }
                    continue;
                }
                EventHandler.addToList(Function.findItemStack((String)modId, (String)nameId, (int)meta), list);
            }
            return list;
        }

        private static int getInt(String string) {
            try {
                return Integer.parseInt(string);
            }
            catch (Exception exception) {
                return 0;
            }
        }

        private static void addToList(ItemStack stack, ArrayList<ItemStack> list) {
            if (list != null && !stack.func_190926_b() && !list.contains(stack)) {
                list.add(stack);
            }
        }
    }

    public static class Menu_GUI {
        public STYLE platformer = STYLE.DEFAULT;
        public STYLE wrench = STYLE.DEFAULT;

        public static enum STYLE {
            DEFAULT,
            VANILLA;

        }
    }

    public static class Menu_Blocks {
        @Config.Comment(value={"Listed blocks will be used in addition to any registered as 'plankWood'"})
        public String[] woodBlocks = new String[0];
        @Config.Comment(value={"Listed blocks will be used in addition to any registered as 'stone', 'cobblestone', or 'sandstone'"})
        public String[] stoneBlocks = new String[]{"stone", "lapis_block", "brick_block", "mossy_cobblestone", "diamond_block", "stonebrick", "end_stone", "nether_brick", "emerald_block", "quartz_block", "stained_hardened_clay", "prismarine", "hardened_clay", "packed_ice", "purpur_block", "purpur_pillar", "end_bricks", "red_nether_brick", "flatcoloredblocks:flatcoloredblock[*]"};
    }

    public static enum PlatformSelect {
        GUI,
        CYCLE,
        MIXED;

    }
}

