/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structures.helpers;

import com.ldtteam.structures.blueprints.v1.Blueprint;
import com.ldtteam.structures.blueprints.v1.BlueprintUtil;
import com.ldtteam.structurize.api.configuration.Configurations;
import com.ldtteam.structurize.api.util.BlockPosUtil;
import com.ldtteam.structurize.api.util.ItemStackUtils;
import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.management.Structures;
import com.ldtteam.structurize.util.BlockInfo;
import com.ldtteam.structurize.util.BlockUtils;
import com.ldtteam.structurize.util.PlacementSettings;
import com.ldtteam.structurize.util.StructureLoadingUtils;
import com.ldtteam.structurize.util.StructurePlacementUtils;
import com.ldtteam.structurize.util.StructureUtils;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Structure {
    protected static final BlockPos NULL_POS = new BlockPos(-1, -1, -1);
    private Blueprint blueprint;
    private String md5;
    private PlacementSettings settings;
    private BlockPos offset;
    @NotNull
    protected final World world;
    protected BlockPos position;
    protected final BlockPos.MutableBlockPos progressPos;

    public Structure(@NotNull World world) {
        this.progressPos = new BlockPos.MutableBlockPos(-1, -1, -1);
        this.world = world;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Structure(@NotNull World world, String structureName, PlacementSettings settings) {
        InputStream inputStream;
        String correctStructureName;
        block7: {
            this(world);
            correctStructureName = structureName;
            this.settings = settings;
            inputStream = null;
            try {
                if (Structures.hasMD5(correctStructureName) && (inputStream = StructureLoadingUtils.getStream("cache/" + Structures.getMD5(correctStructureName))) != null) {
                    correctStructureName = "cache/" + Structures.getMD5(correctStructureName);
                }
                if (inputStream == null) {
                    inputStream = StructureLoadingUtils.getStream(correctStructureName);
                }
                if (inputStream != null) break block7;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            return;
        }
        try {
            this.md5 = StructureUtils.calculateMD5(StructureLoadingUtils.getStream(correctStructureName));
            NBTTagCompound nbttagcompound = CompressedStreamTools.func_74796_a((InputStream)inputStream);
            this.blueprint = BlueprintUtil.readBlueprintFromNBT(nbttagcompound, StructureUtils.getFixer());
        }
        catch (IOException e) {
            Log.getLogger().warn(String.format("Failed to load blueprint %s", correctStructureName), (Throwable)e);
        }
        IOUtils.closeQuietly((InputStream)inputStream);
    }

    public Blueprint getBluePrint() {
        return this.blueprint;
    }

    public void setBluePrint(Blueprint blueprint) {
        this.blueprint = blueprint;
    }

    public boolean isCorrectMD5(String otherMD5) {
        Log.getLogger().info("isCorrectMD5: md5:" + this.md5 + " other:" + otherMD5);
        if (this.md5 == null || otherMD5 == null) {
            return false;
        }
        return this.md5.compareTo(otherMD5) == 0;
    }

    public boolean isBluePrintMissing() {
        return this.blueprint == null;
    }

    public BlockPos getOffset() {
        return this.offset;
    }

    public void setOffset(BlockPos pos) {
        this.offset = pos;
    }

    @Nullable
    public IBlockState getBlockState(@NotNull BlockPos pos) {
        if (this.blueprint.getStructure().length <= pos.func_177956_o() || this.blueprint.getStructure()[pos.func_177956_o()].length <= pos.func_177952_p() || this.blueprint.getStructure()[pos.func_177956_o()][pos.func_177952_p()].length <= pos.func_177958_n()) {
            return null;
        }
        return this.blueprint.getPalette()[this.blueprint.getStructure()[pos.func_177956_o()][pos.func_177952_p()][pos.func_177958_n()] & 0xFFFF];
    }

    @NotNull
    public BlockInfo getBlockInfo(@NotNull BlockPos pos) {
        IBlockState state = this.getBlockState(pos);
        NBTTagCompound compound = this.getTileEntityData(pos);
        return new BlockInfo(pos, state, compound);
    }

    @Nullable
    public NBTTagCompound getTileEntityData(@NotNull BlockPos pos) {
        if (this.blueprint.getTileEntities().length <= pos.func_177956_o() || this.blueprint.getTileEntities()[pos.func_177956_o()].length <= pos.func_177952_p() || this.blueprint.getTileEntities()[pos.func_177956_o()][pos.func_177952_p()].length <= pos.func_177958_n()) {
            return null;
        }
        return this.blueprint.getTileEntities()[pos.func_177956_o()][pos.func_177952_p()][pos.func_177958_n()];
    }

    @Nullable
    public NBTTagCompound[] getEntityData() {
        return this.blueprint.getEntities();
    }

    public int getWidth() {
        return this.blueprint.getSizeX();
    }

    public int getLength() {
        return this.blueprint.getSizeZ();
    }

    public int getHeight() {
        return this.blueprint.getSizeY();
    }

    public void setPlacementSettings(PlacementSettings settings) {
        this.settings = settings;
    }

    public PlacementSettings getSettings() {
        return this.settings;
    }

    public void rotate(Rotation rotation, @NotNull World world, @NotNull BlockPos rotatePos, @NotNull Mirror mirror) {
        this.offset = this.blueprint.rotateWithMirror(rotation, rotatePos, mirror, world);
    }

    public boolean incrementBlock() {
        if (this.progressPos.equals((Object)NULL_POS)) {
            this.progressPos.func_181079_c(-1, 0, 0);
        }
        this.progressPos.func_181079_c(this.progressPos.func_177958_n() + 1, this.progressPos.func_177956_o(), this.progressPos.func_177952_p());
        if (this.progressPos.func_177958_n() == this.blueprint.getSizeX()) {
            this.progressPos.func_181079_c(0, this.progressPos.func_177956_o(), this.progressPos.func_177952_p() + 1);
            if (this.progressPos.func_177952_p() == this.blueprint.getSizeZ()) {
                this.progressPos.func_181079_c(this.progressPos.func_177958_n(), this.progressPos.func_177956_o() + 1, 0);
                if (this.progressPos.func_177956_o() == this.blueprint.getSizeY()) {
                    this.reset();
                    return false;
                }
            }
        }
        return true;
    }

    public boolean decrementBlock() {
        if (this.progressPos.equals((Object)NULL_POS)) {
            this.progressPos.func_181079_c((int)this.blueprint.getSizeX(), this.blueprint.getSizeY() - 1, this.blueprint.getSizeZ() - 1);
        }
        this.progressPos.func_181079_c(this.progressPos.func_177958_n() - 1, this.progressPos.func_177956_o(), this.progressPos.func_177952_p());
        if (this.progressPos.func_177958_n() == -1) {
            this.progressPos.func_181079_c(this.blueprint.getSizeX() - 1, this.progressPos.func_177956_o(), this.progressPos.func_177952_p() - 1);
            if (this.progressPos.func_177952_p() == -1) {
                this.progressPos.func_181079_c(this.progressPos.func_177958_n(), this.progressPos.func_177956_o() - 1, this.blueprint.getSizeZ() - 1);
                if (this.progressPos.func_177956_o() == -1) {
                    this.reset();
                    return false;
                }
            }
        }
        return true;
    }

    public boolean findNextBlock() {
        int count = 0;
        do {
            ++count;
            if (this.incrementBlock()) continue;
            return false;
        } while (StructurePlacementUtils.isStructureBlockEqualWorldBlock(this.world, this.getBlockPosition(), this.getBlockState(this.getLocalPosition())) && count < Configurations.gameplay.maxBlocksChecked);
        return true;
    }

    public BlockPos getPosition() {
        if (this.position == null) {
            return new BlockPos(0, 0, 0);
        }
        return this.position;
    }

    @Nullable
    public Item getItem() {
        Block block = this.getBlock();
        IBlockState blockState = this.getBlockstate();
        if (block == null || blockState == null || block == Blocks.field_150350_a || blockState.func_185904_a().func_76224_d()) {
            return null;
        }
        ItemStack stack = BlockUtils.getItemStackFromBlockState(blockState);
        if (!ItemStackUtils.isEmpty(stack).booleanValue()) {
            return stack.func_77973_b();
        }
        return null;
    }

    @Nullable
    public Block getBlock() {
        if (this.progressPos.equals((Object)NULL_POS)) {
            return null;
        }
        IBlockState state = this.getBlockState((BlockPos)this.progressPos);
        if (state == null) {
            return null;
        }
        return state.func_177230_c();
    }

    @Nullable
    public IBlockState getBlockstate() {
        if (this.progressPos.equals((Object)NULL_POS)) {
            return null;
        }
        return this.getBlockState((BlockPos)this.progressPos);
    }

    @Nullable
    public BlockInfo getBlockInfo() {
        if (this.progressPos.equals((Object)NULL_POS)) {
            return null;
        }
        return this.getBlockInfo((BlockPos)this.progressPos);
    }

    public void reset() {
        BlockPosUtil.set(this.progressPos, NULL_POS);
    }

    @NotNull
    public BlockPos getLocalPosition() {
        return this.progressPos.func_185334_h();
    }

    public void setLocalPosition(@NotNull BlockPos localPosition) {
        BlockPosUtil.set(this.progressPos, localPosition);
    }

    public BlockPos getBlockPosition() {
        return this.progressPos.func_177971_a((Vec3i)this.getOffsetPosition());
    }

    public BlockPos getOffsetPosition() {
        return this.position.func_177973_b((Vec3i)this.getOffset());
    }

    public void setPosition(BlockPos position) {
        this.position = position;
    }

    public World getWorld() {
        return this.world;
    }

    public BlockPos getSize(Rotation rotation, Mirror mirror) {
        return Blueprint.transformedSize(new BlockPos((int)this.blueprint.getSizeX(), (int)this.blueprint.getSizeY(), (int)this.blueprint.getSizeZ()), rotation);
    }
}

