/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structures.helpers;

import com.ldtteam.structures.helpers.Structure;
import com.ldtteam.structurize.api.util.Shape;
import com.ldtteam.structurize.client.gui.WindowBuildTool;
import io.netty.buffer.ByteBuf;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Mirror;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import org.jetbrains.annotations.Nullable;

public final class Settings {
    public static final Settings instance = new Settings();
    private final BlockPos.MutableBlockPos offset = new BlockPos.MutableBlockPos();
    private BlockPos pos = null;
    private boolean isMirrored = false;
    @Nullable
    private Structure structure = null;
    private int rotation = 0;
    private String structureName = null;
    private String style = "";
    private int width = 1;
    private int height = 1;
    private int length = 1;
    private int frequency = 1;
    private String equation = "";
    private boolean hollow = false;
    private Shape shape = Shape.CUBE;
    private Tuple<BlockPos, BlockPos> box = null;
    private boolean staticSchematicMode = false;
    private String staticSchematicName = null;
    private Tuple<ItemStack, ItemStack> stack = new Tuple((Object)new ItemStack(Blocks.field_150340_R), (Object)new ItemStack(Blocks.field_150340_R));
    private WindowBuildTool.FreeMode freeMode = null;

    private Settings() {
    }

    public void setupStaticMode(String name, WindowBuildTool.FreeMode freeMode) {
        this.staticSchematicMode = true;
        this.staticSchematicName = name;
        this.freeMode = freeMode;
    }

    public void setupStaticMode(String name) {
        this.staticSchematicMode = true;
        this.staticSchematicName = name;
    }

    public BlockPos getPosition() {
        return this.pos;
    }

    @Nullable
    public Tuple<BlockPos, BlockPos> getBox() {
        return this.box;
    }

    public void setBox(Tuple<BlockPos, BlockPos> box) {
        this.box = box;
    }

    public void setPosition(BlockPos position) {
        this.pos = position;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    public int getWidth() {
        return this.width;
    }

    public int getLength() {
        return this.length;
    }

    public int getHeight() {
        return this.height;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public void moveTo(BlockPos pos) {
        if (this.structure == null) {
            return;
        }
        this.pos = this.pos.func_177971_a((Vec3i)pos);
    }

    @Nullable
    public Structure getActiveStructure() {
        if (this.structure != null && this.structure.isBluePrintMissing()) {
            this.structure = null;
        }
        return this.structure;
    }

    public void setActiveSchematic(Structure structure) {
        if (structure == null) {
            this.reset();
        } else {
            this.structure = structure;
        }
    }

    public void reset() {
        this.structure = null;
        this.offset.func_181079_c(0, 0, 0);
        this.rotation = 0;
        this.isMirrored = false;
        this.staticSchematicMode = false;
        this.staticSchematicName = null;
        this.freeMode = null;
        this.hollow = false;
        this.structureName = null;
        this.pos = null;
        this.box = null;
        this.equation = "";
    }

    public void softReset() {
        this.structure = null;
        this.offset.func_181079_c(0, 0, 0);
        this.staticSchematicMode = false;
        this.staticSchematicName = null;
        this.freeMode = null;
        this.hollow = false;
        this.pos = null;
        this.box = null;
        this.equation = "";
    }

    public void setSchematicInfo(String structureName, int rotation) {
        this.structureName = structureName;
        this.rotation = rotation;
    }

    public String getStructureName() {
        return this.structureName;
    }

    public void setStructureName(String structureName) {
        this.structureName = structureName;
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public void mirror() {
        if (this.structure == null) {
            return;
        }
        this.isMirrored = !this.isMirrored;
        this.structure.getSettings().setMirror(this.getMirror());
        this.structure.setPlacementSettings(this.structure.getSettings());
    }

    public Mirror getMirror() {
        if (this.isMirrored) {
            return Mirror.FRONT_BACK;
        }
        return Mirror.NONE;
    }

    public boolean isStaticSchematicMode() {
        return this.staticSchematicMode;
    }

    public String getStaticSchematicName() {
        return this.staticSchematicName;
    }

    public WindowBuildTool.FreeMode getFreeMode() {
        return this.freeMode;
    }

    public void setShape(String s) {
        this.shape = Shape.valueOf(s);
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setBlock(ItemStack s, boolean mainBlock) {
        this.stack = mainBlock ? new Tuple((Object)s, this.stack.func_76340_b()) : new Tuple(this.stack.func_76341_a(), (Object)s);
    }

    public ItemStack getBlock(boolean main) {
        return main ? (ItemStack)this.stack.func_76341_a() : (ItemStack)this.stack.func_76340_b();
    }

    public boolean isHollow() {
        return this.hollow;
    }

    public void setHollow(boolean hollow) {
        this.hollow = hollow;
    }

    public void fromBytes(ByteBuf buf) {
        this.isMirrored = buf.readBoolean();
        this.staticSchematicMode = buf.readBoolean();
        this.hollow = buf.readBoolean();
        this.rotation = buf.readInt();
        this.width = buf.readInt();
        this.height = buf.readInt();
        this.length = buf.readInt();
        this.frequency = buf.readInt();
        this.shape = buf.readBoolean() ? Shape.values()[buf.readInt()] : Shape.CUBE;
        this.freeMode = buf.readBoolean() ? WindowBuildTool.FreeMode.values()[buf.readInt()] : null;
        if (buf.readBoolean()) {
            this.offset.func_181079_c(buf.readInt(), buf.readInt(), buf.readInt());
        } else {
            this.offset.func_181079_c(0, 0, 0);
        }
        this.pos = buf.readBoolean() ? new BlockPos(buf.readInt(), buf.readInt(), buf.readInt()) : null;
        this.box = buf.readBoolean() ? new Tuple((Object)new BlockPos(buf.readInt(), buf.readInt(), buf.readInt()), (Object)new BlockPos(buf.readInt(), buf.readInt(), buf.readInt())) : null;
        this.structureName = buf.readBoolean() ? ByteBufUtils.readUTF8String((ByteBuf)buf) : null;
        this.staticSchematicName = buf.readBoolean() ? ByteBufUtils.readUTF8String((ByteBuf)buf) : null;
        this.stack = buf.readBoolean() ? new Tuple((Object)ByteBufUtils.readItemStack((ByteBuf)buf), (Object)ByteBufUtils.readItemStack((ByteBuf)buf)) : new Tuple((Object)new ItemStack(Blocks.field_150340_R), (Object)new ItemStack(Blocks.field_150340_R));
        if (buf.readBoolean()) {
            this.equation = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.isMirrored);
        buf.writeBoolean(this.staticSchematicMode);
        buf.writeBoolean(this.hollow);
        buf.writeInt(this.rotation);
        buf.writeInt(this.width);
        buf.writeInt(this.height);
        buf.writeInt(this.length);
        buf.writeInt(this.frequency);
        buf.writeBoolean(this.shape != null);
        if (this.shape != null) {
            buf.writeInt(this.shape.ordinal());
        }
        buf.writeBoolean(this.freeMode != null);
        if (this.freeMode != null) {
            buf.writeInt(this.freeMode.ordinal());
        }
        buf.writeBoolean(!this.offset.equals((Object)BlockPos.field_177992_a));
        if (!this.offset.equals((Object)BlockPos.field_177992_a)) {
            buf.writeInt(this.offset.func_177958_n());
            buf.writeInt(this.offset.func_177956_o());
            buf.writeInt(this.offset.func_177952_p());
        }
        buf.writeBoolean(this.pos != null);
        if (this.pos != null) {
            buf.writeInt(this.pos.func_177958_n());
            buf.writeInt(this.pos.func_177956_o());
            buf.writeInt(this.pos.func_177952_p());
        }
        buf.writeBoolean(this.box != null);
        if (this.box != null) {
            buf.writeInt(((BlockPos)this.box.func_76341_a()).func_177958_n());
            buf.writeInt(((BlockPos)this.box.func_76341_a()).func_177956_o());
            buf.writeInt(((BlockPos)this.box.func_76341_a()).func_177952_p());
            buf.writeInt(((BlockPos)this.box.func_76340_b()).func_177958_n());
            buf.writeInt(((BlockPos)this.box.func_76340_b()).func_177956_o());
            buf.writeInt(((BlockPos)this.box.func_76340_b()).func_177952_p());
        }
        buf.writeBoolean(this.structureName != null);
        if (this.structureName != null) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.structureName);
        }
        buf.writeBoolean(this.staticSchematicName != null);
        if (this.staticSchematicName != null) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.staticSchematicName);
        }
        buf.writeBoolean(this.stack != null);
        if (this.stack != null) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)((ItemStack)this.stack.func_76341_a()));
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)((ItemStack)this.stack.func_76340_b()));
        }
        buf.writeBoolean(!this.equation.isEmpty());
        if (!this.equation.isEmpty()) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.equation);
        }
    }

    public void setEquation(String localEquation) {
        this.equation = localEquation;
    }

    public String getEquation() {
        return this.equation;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }
}

