/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.item.functional.armor;

import com.cjm721.overloaded.Overloaded;
import com.cjm721.overloaded.client.render.dynamic.ImageUtil;
import com.cjm721.overloaded.client.render.entity.RenderMultiHelmet;
import com.cjm721.overloaded.item.functional.armor.AbstractMultiArmor;
import com.cjm721.overloaded.network.packets.MultiArmorSettingsMessage;
import com.cjm721.overloaded.storage.GenericDataStorage;
import com.cjm721.overloaded.storage.IGenericDataStorage;
import com.cjm721.overloaded.storage.itemwrapper.GenericDataCapabilityProviderWrapper;
import com.google.common.primitives.Floats;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockDispenser;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemMultiHelmet
extends AbstractMultiArmor {
    private RenderMultiHelmet armorModel;

    public ItemMultiHelmet() {
        super(0, EntityEquipmentSlot.HEAD);
        this.setRegistryName("multi_helmet");
        this.func_77655_b("multi_helmet");
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)ItemArmor.field_96605_cw);
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        if (this.armorModel == null) {
            this.armorModel = new RenderMultiHelmet();
        }
        return this.armorModel;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        ModelResourceLocation location = new ModelResourceLocation(this.getRegistryName(), null);
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)location);
        ImageUtil.registerDynamicTexture(new ResourceLocation("overloaded", "textures/armors/multi_helmet.png"), Overloaded.cachedConfig.textureResolutions.multiArmorResolution);
    }

    public void updateSettings(EntityPlayerMP entityPlayerMP, MultiArmorSettingsMessage message) {
        for (ItemStack itemStack : entityPlayerMP.func_184193_aE()) {
            if (itemStack.func_77973_b() != this) continue;
            this.updateSettings(itemStack, message);
        }
    }

    @Override
    public Collection<ICapabilityProvider> collectCapabilities(@Nonnull Collection<ICapabilityProvider> collection, ItemStack stack, @Nullable NBTTagCompound nbt) {
        collection.add(new GenericDataCapabilityProviderWrapper(stack));
        return super.collectCapabilities(collection, stack, nbt);
    }

    private void updateSettings(ItemStack itemStack, MultiArmorSettingsMessage message) {
        IGenericDataStorage settings = (IGenericDataStorage)itemStack.getCapability(GenericDataStorage.GENERIC_DATA_STORAGE, null);
        settings.suggestUpdate();
        Map<String, Float> floats = settings.getFloatMap();
        floats.put("flight_speed", Float.valueOf(Floats.constrainToRange((float)message.flightSpeed, (float)0.0f, (float)Overloaded.cachedConfig.multiArmorConfig.maxFlightSpeed)));
        floats.put("ground_speed", Float.valueOf(Floats.constrainToRange((float)message.groundSpeed, (float)0.0f, (float)Overloaded.cachedConfig.multiArmorConfig.maxGroundSpeed)));
        Map<String, Boolean> booleans = settings.getBooleanMap();
        booleans.put("noclip_flight_lock", message.noclipFlightLock);
        booleans.put("flight", message.flight);
        booleans.put("feed", message.feed);
        booleans.put("heal", message.heal);
        booleans.put("remove_harmful", message.removeHarmful);
        booleans.put("give_air", message.air);
        booleans.put("extinguish", message.extinguish);
        settings.suggestSave();
    }
}

