/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.block.tile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileItemInterface
extends TileEntity
implements IItemHandler {
    private ItemStack storedItem = ItemStack.field_190927_a;

    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound compound) {
        compound.func_74782_a("StoredItem", (NBTBase)this.storedItem.serializeNBT());
        return super.func_189515_b(compound);
    }

    public void func_145839_a(@Nonnull NBTTagCompound compound) {
        this.storedItem = new ItemStack((NBTTagCompound)compound.func_74781_a("StoredItem"));
        super.func_145839_a(compound);
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, tag);
    }

    public void onDataPacket(NetworkManager net, @Nonnull SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public int getSlots() {
        return 1;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.storedItem;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (this.storedItem.func_190926_b()) {
            if (stack.func_190916_E() == 1) {
                if (!simulate) {
                    this.storedItem = stack;
                    this.updateClient();
                    this.func_70296_d();
                }
                return ItemStack.field_190927_a;
            }
            ItemStack storedCopy = stack.func_77946_l();
            storedCopy.func_190920_e(1);
            ItemStack returnCopy = stack.func_77946_l();
            returnCopy.func_190920_e(stack.func_190916_E() - 1);
            if (!simulate) {
                this.storedItem = storedCopy;
                this.updateClient();
                this.func_70296_d();
            }
            return returnCopy;
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack copy = this.storedItem.func_77946_l();
        copy.func_190920_e(Math.min(copy.func_190916_E(), amount));
        if (!simulate) {
            this.storedItem.func_190920_e(this.storedItem.func_190916_E() - copy.func_190916_E());
            if (this.storedItem.func_190916_E() == 0) {
                this.storedItem = ItemStack.field_190927_a;
            }
            this.func_70296_d();
            this.updateClient();
        }
        return copy;
    }

    private void updateClient() {
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if ((facing == EnumFacing.UP || facing == EnumFacing.DOWN) && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return this.storedItem.hasCapability(capability, facing) || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if ((facing == EnumFacing.UP || facing == EnumFacing.DOWN) && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this);
        }
        Object t = this.storedItem.getCapability(capability, facing);
        if (t == null) {
            return (T)super.getCapability(capability, facing);
        }
        return (T)t;
    }

    public ItemStack getStoredItem() {
        return this.storedItem;
    }

    public void breakBlock() {
        if (!this.storedItem.func_190926_b()) {
            this.func_145831_w().func_72838_d((Entity)new EntityItem(this.func_145831_w(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), this.storedItem));
        }
    }
}

