/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.world.tree;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockVine;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenSwamp;
import net.minecraftforge.common.IPlantable;
import vazkii.quark.world.feature.TreeVariants;

public class WorldGenSwampTree
extends WorldGenSwamp {
    private static final IBlockState TRUNK = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.OAK);
    private final IBlockState leaf;
    private final boolean addVines;

    public WorldGenSwampTree(boolean addVines) {
        this.addVines = addVines;
        this.leaf = TreeVariants.variant_leaves.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
    }

    public boolean func_180709_b(@Nonnull World worldIn, @Nonnull Random rand, @Nonnull BlockPos pos) {
        int i = rand.nextInt(4) + 5;
        while (worldIn.func_180495_p(pos.func_177977_b()).func_185904_a() == Material.field_151586_h) {
            pos = pos.func_177977_b();
        }
        boolean generating = true;
        if (pos.func_177956_o() >= 1 && pos.func_177956_o() + i + 1 <= 256) {
            for (int y = pos.func_177956_o(); y <= pos.func_177956_o() + 1 + i; ++y) {
                int k = 1;
                if (y == pos.func_177956_o()) {
                    k = 0;
                }
                if (y >= pos.func_177956_o() + 1 + i - 2) {
                    k = 3;
                }
                BlockPos.MutableBlockPos pointer = new BlockPos.MutableBlockPos();
                for (int x = pos.func_177958_n() - k; x <= pos.func_177958_n() + k && generating; ++x) {
                    for (int z = pos.func_177952_p() - k; z <= pos.func_177952_p() + k && generating; ++z) {
                        if (y >= 0 && y < 256) {
                            IBlockState iblockstate = worldIn.func_180495_p((BlockPos)pointer.func_181079_c(x, y, z));
                            Block block = iblockstate.func_177230_c();
                            if (iblockstate.func_177230_c().isAir(iblockstate, (IBlockAccess)worldIn, (BlockPos)pointer.func_181079_c(x, y, z)) || iblockstate.func_177230_c().isLeaves(iblockstate, (IBlockAccess)worldIn, (BlockPos)pointer.func_181079_c(x, y, z))) continue;
                            if (block != Blocks.field_150355_j && block != Blocks.field_150358_i) {
                                generating = false;
                                continue;
                            }
                            if (y <= pos.func_177956_o()) continue;
                            generating = false;
                            continue;
                        }
                        generating = false;
                    }
                }
            }
            if (!generating) {
                return false;
            }
            BlockPos down = pos.func_177977_b();
            IBlockState state = worldIn.func_180495_p(down);
            boolean isSoil = state.func_177230_c().canSustainPlant(state, (IBlockAccess)worldIn, down, EnumFacing.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g));
            if (isSoil && pos.func_177956_o() < worldIn.func_72800_K() - i - 1) {
                int z;
                int y;
                state.func_177230_c().onPlantGrow(state, worldIn, pos.func_177977_b(), pos);
                for (y = pos.func_177956_o() - 3 + i; y <= pos.func_177956_o() + i; ++y) {
                    int dy = y - (pos.func_177956_o() + i);
                    int partialDy = 2 - dy / 2;
                    for (int x = pos.func_177958_n() - partialDy; x <= pos.func_177958_n() + partialDy; ++x) {
                        int dx = x - pos.func_177958_n();
                        for (z = pos.func_177952_p() - partialDy; z <= pos.func_177952_p() + partialDy; ++z) {
                            BlockPos blockpos;
                            int dz = z - pos.func_177952_p();
                            if (Math.abs(dx) == partialDy && Math.abs(dz) == partialDy && (rand.nextInt(2) == 0 || dy == 0) || !(state = worldIn.func_180495_p(blockpos = new BlockPos(x, y, z))).func_177230_c().canBeReplacedByLeaves(state, (IBlockAccess)worldIn, blockpos)) continue;
                            this.func_175903_a(worldIn, blockpos, this.leaf);
                        }
                    }
                }
                for (int l1 = 0; l1 < i; ++l1) {
                    BlockPos upN = pos.func_177981_b(l1);
                    IBlockState upState = worldIn.func_180495_p(upN);
                    Block upBlock = upState.func_177230_c();
                    if (!upBlock.isAir(upState, (IBlockAccess)worldIn, upN) && !upBlock.isLeaves(upState, (IBlockAccess)worldIn, upN) && upBlock != Blocks.field_150358_i && upBlock != Blocks.field_150355_j) continue;
                    this.func_175903_a(worldIn, pos.func_177981_b(l1), TRUNK);
                }
                if (this.addVines) {
                    for (y = pos.func_177956_o() - 3 + i; y <= pos.func_177956_o() + i; ++y) {
                        int dx = y - (pos.func_177956_o() + i);
                        int partialDy = 2 - dx / 2;
                        BlockPos.MutableBlockPos pointer = new BlockPos.MutableBlockPos();
                        for (int x = pos.func_177958_n() - partialDy; x <= pos.func_177958_n() + partialDy; ++x) {
                            for (z = pos.func_177952_p() - partialDy; z <= pos.func_177952_p() + partialDy; ++z) {
                                pointer.func_181079_c(x, y, z);
                                if (worldIn.func_180495_p((BlockPos)pointer).func_185904_a() != Material.field_151584_j) continue;
                                BlockPos west = pointer.func_177976_e();
                                BlockPos east = pointer.func_177974_f();
                                BlockPos north = pointer.func_177978_c();
                                BlockPos south = pointer.func_177968_d();
                                if (rand.nextInt(4) == 0 && worldIn.func_175623_d(west)) {
                                    this.addVine(worldIn, west, BlockVine.field_176278_M);
                                }
                                if (rand.nextInt(4) == 0 && worldIn.func_175623_d(east)) {
                                    this.addVine(worldIn, east, BlockVine.field_176280_O);
                                }
                                if (rand.nextInt(4) == 0 && worldIn.func_175623_d(north)) {
                                    this.addVine(worldIn, north, BlockVine.field_176279_N);
                                }
                                if (rand.nextInt(4) != 0 || !worldIn.func_175623_d(south)) continue;
                                this.addVine(worldIn, south, BlockVine.field_176273_b);
                            }
                        }
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void addVine(World worldIn, BlockPos pos, PropertyBool prop) {
        IBlockState iblockstate = Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)prop, (Comparable)Boolean.valueOf(true));
        this.func_175903_a(worldIn, pos, iblockstate);
        BlockPos blockpos = pos.func_177977_b();
        for (int i = 4; worldIn.func_175623_d(blockpos) && i > 0; --i) {
            this.func_175903_a(worldIn, blockpos, iblockstate);
            blockpos = blockpos.func_177977_b();
        }
    }
}

