/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.world;

import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.IWorldGenerator;
import vazkii.quark.world.block.BlockVariantSapling;
import vazkii.quark.world.feature.TreeVariants;
import vazkii.quark.world.world.tree.WorldGenSakuraTree;

public class SakuraTreeGenerator
implements IWorldGenerator {
    private final WorldGenSakuraTree treeGen = new WorldGenSakuraTree(false);

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        for (double chance = TreeVariants.sakuraChance; random.nextDouble() < chance; chance -= 1.0) {
            boolean snow;
            int z;
            int x = chunkX * 16 + random.nextInt(16) + 8;
            BlockPos xzPos = new BlockPos(x, 0, z = chunkZ * 16 + random.nextInt(16) + 8);
            Biome biome = world.func_180494_b(xzPos);
            Set types = BiomeDictionary.getTypes((Biome)biome);
            if (!types.contains(BiomeDictionary.Type.MOUNTAIN) || types.contains(BiomeDictionary.Type.FOREST)) continue;
            BlockPos pos = world.func_175672_r(xzPos).func_177977_b();
            IBlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            boolean bl = snow = block == Blocks.field_150431_aC;
            if (snow) {
                pos = pos.func_177977_b();
                state = world.func_180495_p(pos);
                block = state.func_177230_c();
            }
            if (!block.canSustainPlant(state, (IBlockAccess)world, pos, EnumFacing.UP, (IPlantable)((BlockVariantSapling)TreeVariants.variant_sapling))) continue;
            BlockPos placePos = pos.func_177984_a();
            if (snow) {
                world.func_175698_g(placePos);
            }
            this.treeGen.func_180709_b(world, random, placePos);
        }
    }
}

