/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.oddities.client.render;

import java.util.Iterator;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import vazkii.quark.oddities.tile.TilePipe;

public class RenderTilePipe
extends TileEntitySpecialRenderer<TilePipe> {
    private Random random = new Random();

    public void render(TilePipe te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        RenderItem render = Minecraft.func_71410_x().func_175599_af();
        Iterator<TilePipe.PipeItem> items = te.getItemIterator();
        while (items.hasNext()) {
            this.renderItem(items.next(), render, partialTicks);
        }
        GlStateManager.func_179121_F();
    }

    private void renderItem(TilePipe.PipeItem item, RenderItem render, float partial) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179123_a();
        RenderHelper.func_74519_b();
        float scale = 0.4f;
        float fract = item.getTimeFract(partial);
        float shiftFract = fract - 0.5f;
        EnumFacing face = item.outgoingFace;
        if ((double)fract < 0.5) {
            face = item.incomingFace.func_176734_d();
        }
        float offX = (float)face.func_82601_c() * 1.0f;
        float offY = (float)face.func_96559_d() * 1.0f;
        float offZ = (float)face.func_82599_e() * 1.0f;
        GlStateManager.func_179109_b((float)(offX * shiftFract), (float)(offY * shiftFract), (float)(offZ * shiftFract));
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        float speed = 4.0f;
        GlStateManager.func_179114_b((float)(((float)item.timeInWorld + partial) * speed), (float)0.0f, (float)1.0f, (float)0.0f);
        int seed = item.stack.func_190926_b() ? 187 : Item.func_150891_b((Item)item.stack.func_77973_b()) + item.stack.func_77960_j();
        this.random.setSeed(seed);
        int count = this.getModelCount(item.stack);
        for (int i = 0; i < count; ++i) {
            GlStateManager.func_179094_E();
            if (i > 0) {
                float spread = 0.15f;
                float x = (this.random.nextFloat() * 2.0f - 1.0f) * spread;
                float y = (this.random.nextFloat() * 2.0f - 1.0f) * spread;
                float z = (this.random.nextFloat() * 2.0f - 1.0f) * spread;
                GlStateManager.func_179109_b((float)x, (float)y, (float)z);
            }
            render.func_181564_a(item.stack, ItemCameraTransforms.TransformType.FIXED);
            GlStateManager.func_179121_F();
        }
        RenderHelper.func_74518_a();
        GlStateManager.func_179099_b();
        GlStateManager.func_179121_F();
    }

    protected int getModelCount(ItemStack stack) {
        if (stack.func_190916_E() > 48) {
            return 5;
        }
        if (stack.func_190916_E() > 32) {
            return 4;
        }
        if (stack.func_190916_E() > 16) {
            return 3;
        }
        if (stack.func_190916_E() > 1) {
            return 2;
        }
        return 1;
    }
}

