/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.misc.feature;

import javax.annotation.Nonnull;
import net.minecraft.block.BlockDispenser;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RenderSnowball;
import net.minecraft.dispenser.BehaviorProjectileDispense;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.quark.base.Quark;
import vazkii.quark.base.module.Feature;
import vazkii.quark.misc.entity.EntityDragonBreathBottle;

public class ThrowableDragonBreath
extends Feature {
    public static int blocksPerBottle;

    @Override
    public void setupConfig() {
        blocksPerBottle = this.loadPropInt("Blocks per Bottle", "", 64);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        String bottleName = "quark:dragon_breath_bottle";
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(bottleName), EntityDragonBreathBottle.class, (String)bottleName, (int)11, (Object)Quark.instance, (int)64, (int)10, (boolean)true);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInitClient() {
        RenderingRegistry.registerEntityRenderingHandler(EntityDragonBreathBottle.class, renderManager -> new RenderSnowball(renderManager, Items.field_185157_bK, Minecraft.func_71410_x().func_175599_af()));
    }

    @Override
    public void postInit() {
        BlockDispenser.field_149943_a.func_82595_a((Object)Items.field_185157_bK, (Object)new BehaviorProjectileDispense(){

            @Nonnull
            protected IProjectile func_82499_a(@Nonnull World worldIn, @Nonnull IPosition position, @Nonnull ItemStack stackIn) {
                return new EntityDragonBreathBottle(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
            }

            protected float func_82498_a() {
                return super.func_82498_a() * 0.5f;
            }

            protected float func_82500_b() {
                return super.func_82500_b() * 1.25f;
            }
        });
    }

    @SubscribeEvent
    public void playerRightClick(PlayerInteractEvent.RightClickItem event) {
        EntityPlayer player = event.getEntityPlayer();
        World world = player.field_70170_p;
        ItemStack stack = event.getItemStack();
        if (stack.func_77973_b() != Items.field_185157_bK) {
            return;
        }
        if (!player.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
        }
        world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187827_fP, SoundCategory.PLAYERS, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
        if (!world.field_72995_K) {
            EntityDragonBreathBottle b = new EntityDragonBreathBottle(world, (EntityLivingBase)player);
            b.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 1.5f, 1.0f);
            world.func_72838_d((Entity)b);
        } else {
            player.func_184609_a(event.getHand());
        }
        event.setCancellationResult(EnumActionResult.SUCCESS);
        event.setCanceled(true);
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }
}

