/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.misc.ai;

import java.util.Objects;
import java.util.UUID;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import vazkii.quark.misc.feature.HorseWhistle;

public class EntityAIHorseFollow
extends EntityAIBase {
    private final AbstractHorse horse;
    private EntityLivingBase owner;
    private final World world;
    private final double followSpeed;
    private final PathNavigate petPathfinder;
    private int timeToRebuildPath;
    private float oldWaterCost;
    private static final UUID HORSE_SIGHT = UUID.fromString("f58c267b-67fb-4997-b2a0-27649fb0aa9a");

    public EntityAIHorseFollow(AbstractHorse horse, double followSpeedIn) {
        this.horse = horse;
        this.world = horse.field_70170_p;
        this.followSpeed = followSpeedIn;
        this.petPathfinder = horse.func_70661_as();
        this.owner = null;
        this.horse.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111265_b).func_188479_b(HORSE_SIGHT);
        this.func_75248_a(3);
        if (!(horse.func_70661_as() instanceof PathNavigateGround) && !(horse.func_70661_as() instanceof PathNavigateFlying)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
        }
    }

    public void setOwner(EntityLivingBase player) {
        if (Objects.equals(player.func_110124_au(), this.horse.func_184780_dh()) && !this.horse.func_110167_bD() && !this.horse.func_184207_aI()) {
            this.owner = player;
        }
    }

    public boolean func_75250_a() {
        return this.owner != null && !this.horse.func_110167_bD() && Objects.equals(this.owner.func_110124_au(), this.horse.func_184780_dh()) && !this.horse.func_184207_aI();
    }

    public boolean func_75253_b() {
        return !this.petPathfinder.func_75500_f() && this.owner != null;
    }

    public void func_75249_e() {
        this.timeToRebuildPath = 0;
        this.oldWaterCost = this.horse.func_184643_a(PathNodeType.WATER);
        this.horse.func_184644_a(PathNodeType.WATER, 0.0f);
        this.horse.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111265_b).func_111121_a(new AttributeModifier(HORSE_SIGHT, "Whistle range bonus", HorseWhistle.horseSummonRange, 0));
    }

    public void func_75251_c() {
        this.owner = null;
        this.petPathfinder.func_75499_g();
        this.horse.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
        this.horse.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111265_b).func_188479_b(HORSE_SIGHT);
    }

    public void func_75246_d() {
        this.horse.func_70671_ap().func_75651_a((Entity)this.owner, 10.0f, (float)this.horse.func_70646_bf());
        if (--this.timeToRebuildPath <= 0) {
            this.timeToRebuildPath = 10;
            if (!this.petPathfinder.func_75497_a((Entity)this.owner, this.followSpeed) && !this.horse.func_110167_bD() && !this.horse.func_184218_aH() && this.horse.func_70068_e((Entity)this.owner) >= HorseWhistle.horseSummonRange * HorseWhistle.horseSummonRange / 4.0) {
                if (!HorseWhistle.horsesAreMagical) {
                    return;
                }
                int ownerX = MathHelper.func_76128_c((double)this.owner.field_70165_t) - 2;
                int ownerZ = MathHelper.func_76128_c((double)this.owner.field_70161_v) - 2;
                int ownerY = MathHelper.func_76128_c((double)this.owner.func_174813_aQ().field_72338_b);
                for (int xOffset = 0; xOffset <= 4; ++xOffset) {
                    for (int zOffset = 0; zOffset <= 4; ++zOffset) {
                        if (xOffset >= 1 && zOffset >= 1 && xOffset <= 3 && zOffset <= 3 || !this.isTeleportFriendlyBlock(ownerX, ownerZ, ownerY, xOffset, zOffset)) continue;
                        this.horse.func_70012_b((double)((float)(ownerX + xOffset) + 0.5f), (double)ownerY, (double)((float)(ownerZ + zOffset) + 0.5f), this.horse.field_70177_z, this.horse.field_70125_A);
                        this.petPathfinder.func_75499_g();
                        return;
                    }
                }
            }
        }
    }

    protected boolean isTeleportFriendlyBlock(int x, int z, int y, int xOffset, int zOffset) {
        BlockPos blockpos = new BlockPos(x + xOffset, y - 1, z + zOffset);
        IBlockState iblockstate = this.world.func_180495_p(blockpos);
        return iblockstate.func_193401_d((IBlockAccess)this.world, blockpos, EnumFacing.DOWN) == BlockFaceShape.SOLID && iblockstate.func_189884_a((Entity)this.horse) && this.world.func_175623_d(blockpos.func_177984_a()) && this.world.func_175623_d(blockpos.func_177981_b(2));
    }
}

