/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.client.feature;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.quark.base.module.Feature;

public class GreenerGrass
extends Feature {
    public static boolean affectFoliage;
    public static boolean alphaGrass;
    public static boolean absoluteValues;
    public static int redShift;
    public static int greenShift;
    public static int blueShift;
    public static List<String> extraBlocks;

    @Override
    public void setupConfig() {
        affectFoliage = this.loadPropBool("Should affect foliage", "", true);
        alphaGrass = this.loadPropBool("Alpha grass", "Sets the grass color to be a \"Minecraft Alpha\" tone.\nThis will override all manual shift values.", false);
        absoluteValues = this.loadPropBool("Treat shifts as absolute and ignore biome colors", "", false);
        redShift = this.loadPropInt("Shift reds by", "", -30);
        greenShift = this.loadPropInt("Shift greens by", "", 30);
        blueShift = this.loadPropInt("Shift blues by", "", -30);
        extraBlocks = Arrays.asList(this.loadPropStringList("Extra blocks", "", new String[]{"buildingbrickscompatvanilla:grass_slab", "buildingbrickscompatvanilla:grass_step", "buildingbrickscompatvanilla:grass_corner", "buildingbrickscompatvanilla:grass_vertical_slab", "buildingbrickscompatvanilla:grass_stairs", "betterwithmods:dirt_slab", "biomesoplenty:plant_0", "biomesoplenty:plant_1", "biomesoplenty:leaves_1", "biomesoplenty:leaves_2", "biomesoplenty:leaves_3", "biomesoplenty:leaves_4", "biomesoplenty:leaves_5", "biomesoplenty:grass"}));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initClient() {
        this.registerGreenerColor(new Block[]{Blocks.field_150349_c, Blocks.field_150329_H, Blocks.field_150398_cm, Blocks.field_150436_aH});
        if (affectFoliage) {
            this.registerGreenerColor(new Block[]{Blocks.field_150362_t, Blocks.field_150361_u, Blocks.field_150395_bd});
        }
        for (String s : extraBlocks) {
            Block b = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(s));
            this.registerGreenerColor(b);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void registerGreenerColor(Block ... blocks) {
        BlockColors colors = Minecraft.func_71410_x().func_184125_al();
        Map map = (Map)ObfuscationReflectionHelper.getPrivateValue(BlockColors.class, (Object)colors, (String)"blockColorMap");
        for (Block b : blocks) {
            IBlockColor color = (IBlockColor)map.get(b.delegate);
            if (color == null) continue;
            colors.func_186722_a(this.getGreenerColor(color), new Block[]{b});
        }
    }

    @SideOnly(value=Side.CLIENT)
    private IBlockColor getGreenerColor(IBlockColor color) {
        return (state, world, pos, tintIndex) -> {
            int shiftBlue;
            int originalColor = color.func_186720_a(state, world, pos, tintIndex);
            int r = originalColor >> 16 & 0xFF;
            int g = originalColor >> 8 & 0xFF;
            int b = originalColor & 0xFF;
            int shiftRed = alphaGrass ? 30 : redShift;
            int shiftGreen = alphaGrass ? 120 : greenShift;
            int n = shiftBlue = alphaGrass ? 30 : blueShift;
            if (absoluteValues) {
                return (Math.max(0, Math.min(255, redShift)) << 16) + Math.max(0, Math.min(255, greenShift) << 8) + Math.max(0, Math.min(255, blueShift));
            }
            return (Math.max(0, Math.min(255, r + shiftRed)) << 16) + Math.max(0, Math.min(255, g + shiftGreen) << 8) + Math.max(0, Math.min(255, b + shiftBlue));
        };
    }

    @Override
    public String[] getIncompatibleMods() {
        return new String[]{"sereneseasons"};
    }
}

