/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.client.gui.config;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.common.FMLCommonHandler;
import vazkii.quark.base.client.gui.config.GuiConfigBase;
import vazkii.quark.base.module.Feature;
import vazkii.quark.base.module.ModuleLoader;

public class GuiConfigImport
extends GuiConfigBase {
    private boolean needsRestart = false;
    private int disabledFeatures;
    private GuiTextField textField;

    public GuiConfigImport(GuiScreen parent) {
        super(parent);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.title = this.title + " - " + I18n.func_135052_a((String)"quark.config.import", (Object[])new Object[0]);
        int x = this.field_146294_l / 2 - 100;
        int y = this.field_146295_m / 6;
        GuiButton importButton = new GuiButton(1, x, y + 110, 200, 20, I18n.func_135052_a((String)"quark.config.import", (Object[])new Object[0]));
        this.backButton = new GuiButton(0, x, y + 167, 200, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        this.field_146292_n.add(this.backButton);
        this.field_146292_n.add(importButton);
        this.field_146292_n.add(new GuiButton(2, x, y + 132, 200, 20, I18n.func_135052_a((String)"quark.config.opensite", (Object[])new Object[0])));
        this.textField = new GuiTextField(0, this.field_146289_q, x, y + 72, 200, 20);
        this.textField.func_146195_b(true);
        this.textField.func_146205_d(false);
        this.textField.func_146203_f(Integer.MAX_VALUE);
        if (this.field_146297_k.field_71441_e != null) {
            importButton.field_146124_l = false;
        }
    }

    @Override
    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        switch (button.field_146127_k) {
            case 1: {
                if (!this.needsRestart) {
                    this.doImport();
                    if (!this.needsRestart) break;
                    button.field_146126_j = I18n.func_135052_a((String)"quark.config.close", (Object[])new Object[0]);
                    for (GuiButton b : this.field_146292_n) {
                        if (b == button) continue;
                        b.field_146124_l = false;
                    }
                    break;
                }
                FMLCommonHandler.instance().exitJava(0, false);
                break;
            }
            case 2: {
                this.tryOpenWebsite("https://quark.vazkii.net");
                break;
            }
            case 3: {
                this.tryOpenWebsite("https://quark.vazkii.net");
            }
        }
    }

    @Override
    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (!this.needsRestart) {
            super.func_73869_a(typedChar, keyCode);
            this.textField.func_146201_a(typedChar, keyCode);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.textField.func_146192_a(mouseX, mouseY, mouseButton);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.textField.func_146194_f();
        int x = this.field_146294_l / 2;
        for (int i = 0; i < 4; ++i) {
            int y = 50 + i * 10;
            String key = "quark.config.importinfo" + i;
            if (i == 3) {
                if (Minecraft.field_142025_a) {
                    key = key + "m";
                }
                y += 5;
            }
            this.func_73732_a(this.field_146297_k.field_71466_p, I18n.func_135052_a((String)key, (Object[])new Object[0]), x, y, 0xFFFFFF);
        }
        if (this.needsRestart) {
            String s = this.disabledFeatures == 1 ? I18n.func_135052_a((String)"quark.config.disabledcount1", (Object[])new Object[0]) : I18n.func_135052_a((String)"quark.config.disabledcount", (Object[])new Object[]{this.disabledFeatures});
            this.func_73732_a(this.field_146297_k.field_71466_p, s, x, this.textField.field_146210_g + 26, 65280);
        }
        if (this.field_146297_k.field_71441_e != null) {
            this.func_73732_a(this.field_146297_k.field_71466_p, I18n.func_135052_a((String)"quark.config.cantimport", (Object[])new Object[0]), x, this.textField.field_146210_g + 26, 0xFF0000);
        }
    }

    private void doImport() {
        boolean changed = false;
        this.disabledFeatures = 0;
        Object[] disables = this.textField.func_146179_b().trim().split(",");
        if (disables.length > 0) {
            ImmutableSet disabledSet = ImmutableSet.copyOf((Object[])disables);
            for (String name : ModuleLoader.featureClassnames.keySet()) {
                boolean enabled;
                Feature f = ModuleLoader.featureClassnames.get(name);
                boolean bl = enabled = disabledSet.contains(name) != f.enabledByDefault;
                if (f.prop.getBoolean() != enabled) {
                    f.prop.set(enabled);
                }
                if (!f.prop.hasChanged()) continue;
                changed = true;
                if (enabled) continue;
                ++this.disabledFeatures;
            }
        }
        this.needsRestart = false;
        if (changed) {
            ModuleLoader.loadConfig();
            this.needsRestart = true;
        }
    }
}

