/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.util;

import com.lothrazar.cyclicmagic.util.UtilString;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.config.Configuration;

public class UtilRepairItem {
    public static NonNullList<String> blacklistBlockIds;
    public static boolean doNonRepairable;

    public static boolean isBlockAllowed(ItemStack thing) {
        return !UtilString.isInList(blacklistBlockIds, thing.func_77973_b().getRegistryName());
    }

    public static void syncConfig(Configuration config) {
        String category = "modpacks.block_anvil";
        String[] deflist = new String[]{"galacticraftcore:battery", "galacticraftcore:oxygen_tank_heavy_full", "galacticraftcore:oxygen_tank_med_full", "galacticraftcore:oil_canister_partial", "galacticraftcore:oxygen_tank_light_full", "pneumaticcraft:*"};
        Object[] blacklist = config.getStringList("RepairBlacklist", category, deflist, "These cannot be repaired. Use star syntax to lock out an entire mod, otherwise use the standard modid:itemid for singles.  Applies to both diamond and magma anvil");
        blacklistBlockIds = NonNullList.func_193580_a((Object)"", (Object[])blacklist);
        doNonRepairable = config.getBoolean("ForceNonRepairable", category, false, "If this is set to true, this block will force-repair items that are set to be non-repairable (such as Tinkers Construct tools).  Of course it still respects the blacklist.  Applies to both diamond and magma anvil");
    }

    public static boolean canRepair(ItemStack inputStack) {
        if (inputStack.func_190926_b()) {
            return false;
        }
        if (!inputStack.func_77951_h()) {
            return false;
        }
        if (!UtilRepairItem.isBlockAllowed(inputStack)) {
            return false;
        }
        if (doNonRepairable) {
            return true;
        }
        return inputStack.func_77973_b().isRepairable();
    }

    public static boolean doRepair(ItemStack inputStack) {
        if (inputStack.func_77951_h()) {
            inputStack.func_77964_b(inputStack.func_77952_i() - 1);
            return true;
        }
        return false;
    }
}

