/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class UtilOreDictionary {
    public static boolean doesMatchOreDict(ItemStack stack, String oreId) {
        return UtilOreDictionary.doesMatchOreDict(stack, oreId, false);
    }

    public static boolean doesMatchOreDict(ItemStack stack, String oreId, boolean strict) {
        if (OreDictionary.doesOreNameExist((String)oreId)) {
            for (ItemStack stackCurrent : OreDictionary.getOres((String)oreId)) {
                boolean match = OreDictionary.itemMatches((ItemStack)stackCurrent, (ItemStack)stack, (boolean)strict);
                if (!match) continue;
                return true;
            }
        }
        return false;
    }

    public static List<String> getOreDictList(ItemStack stack, boolean strict) {
        ArrayList<String> ores = new ArrayList<String>();
        for (String oreId : OreDictionary.getOreNames()) {
            for (ItemStack stackCurrent : OreDictionary.getOres((String)oreId)) {
                if (!OreDictionary.itemMatches((ItemStack)stackCurrent, (ItemStack)stack, (boolean)strict)) continue;
                ores.add(oreId);
            }
        }
        return ores;
    }

    public static boolean doesMatchOreDict(ItemStack stack, List<String> oreIds) {
        return UtilOreDictionary.doesMatchOreDict(stack, oreIds.toArray(new String[0]));
    }

    public static boolean doesMatchOreDict(ItemStack stack, String[] oreIds) {
        return UtilOreDictionary.doesMatchOreDict(stack, oreIds, false);
    }

    public static boolean doesMatchOreDict(ItemStack stack, String[] oreIds, boolean strict) {
        for (String oreId : oreIds) {
            if (!UtilOreDictionary.doesMatchOreDict(stack, oreId, strict)) continue;
            return true;
        }
        return false;
    }

    public static boolean itemMatchesAllowAir(ItemStack toMatch, ItemStack stack) {
        if (toMatch.func_190926_b() || stack.func_190926_b()) {
            return true;
        }
        return OreDictionary.itemMatches((ItemStack)toMatch, (ItemStack)stack, (boolean)false);
    }
}

