/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.cyclicwand;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.item.cyclicwand.InventoryWand;
import com.lothrazar.cyclicmagic.item.cyclicwand.ItemCyclicWand;
import com.lothrazar.cyclicmagic.playerupgrade.spell.SpellRangeBuild;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilPlaceBlocks;
import com.lothrazar.cyclicmagic.util.UtilSound;
import com.lothrazar.cyclicmagic.util.UtilSpellCaster;
import com.lothrazar.cyclicmagic.util.UtilWorld;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketRangeBuild
implements IMessage,
IMessageHandler<PacketRangeBuild, IMessage> {
    private BlockPos pos;
    private EnumFacing face;
    private SpellRangeBuild.PlaceType type;
    private Vec3d hitVec;

    public PacketRangeBuild() {
    }

    public PacketRangeBuild(RayTraceResult ray, int spellid, SpellRangeBuild.PlaceType type) {
        this.pos = ray.func_178782_a();
        this.face = ray.field_178784_b;
        this.hitVec = new Vec3d(ray.field_72307_f.field_72450_a - (double)MathHelper.func_76140_b((double)ray.field_72307_f.field_72450_a), ray.field_72307_f.field_72448_b - (double)MathHelper.func_76140_b((double)ray.field_72307_f.field_72448_b), ray.field_72307_f.field_72449_c - (double)MathHelper.func_76140_b((double)ray.field_72307_f.field_72449_c));
        this.type = type;
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound tags = ByteBufUtils.readTag((ByteBuf)buf);
        this.hitVec = new Vec3d(tags.func_74769_h("hitx"), tags.func_74769_h("hity"), tags.func_74769_h("hitz"));
        int x = tags.func_74762_e("x");
        int y = tags.func_74762_e("y");
        int z = tags.func_74762_e("z");
        this.pos = new BlockPos(x, y, z);
        if (tags.func_74764_b("face")) {
            this.face = EnumFacing.values()[tags.func_74762_e("face")];
        }
        int t = tags.func_74762_e("placetype");
        this.type = SpellRangeBuild.PlaceType.values()[t];
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74780_a("hitx", this.hitVec.field_72450_a);
        tags.func_74780_a("hity", this.hitVec.field_72448_b);
        tags.func_74780_a("hitz", this.hitVec.field_72449_c);
        tags.func_74768_a("placetype", this.type.ordinal());
        tags.func_74768_a("x", this.pos.func_177958_n());
        tags.func_74768_a("y", this.pos.func_177956_o());
        tags.func_74768_a("z", this.pos.func_177952_p());
        if (this.face != null) {
            tags.func_74768_a("face", this.face.ordinal());
        }
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tags);
    }

    public IMessage onMessage(PacketRangeBuild message, MessageContext ctx) {
        this.checkThreadAndEnqueue(message, ctx);
        return null;
    }

    private void checkThreadAndEnqueue(final PacketRangeBuild message, final MessageContext ctx) {
        IThreadListener thread = ModCyclic.proxy.getThreadFromContext(ctx);
        thread.func_152344_a(new Runnable(){

            @Override
            public void run() {
                if (ctx.side.isServer() && message != null && message.pos != null) {
                    EntityPlayerMP p = ctx.getServerHandler().field_147369_b;
                    message.castFromServer(message.pos, message.face, (EntityPlayer)p);
                }
            }
        });
    }

    public static BlockPos getPosToPlaceAt(EntityPlayer p, BlockPos pos, EnumFacing sideMouseover, SpellRangeBuild.PlaceType type) {
        BlockPos posToPlaceAt = null;
        EnumFacing facing = null;
        EnumFacing playerFacing = p.func_174811_aO();
        block0 : switch (type) {
            case DOWN: {
                facing = EnumFacing.DOWN;
                break;
            }
            case UP: {
                facing = EnumFacing.UP;
                break;
            }
            case LEFT: {
                switch (playerFacing) {
                    case DOWN: {
                        break block0;
                    }
                    case EAST: {
                        facing = EnumFacing.NORTH;
                        break block0;
                    }
                    case NORTH: {
                        facing = EnumFacing.WEST;
                        break block0;
                    }
                    case SOUTH: {
                        facing = EnumFacing.EAST;
                        break block0;
                    }
                    case UP: {
                        break block0;
                    }
                    case WEST: {
                        facing = EnumFacing.SOUTH;
                        break block0;
                    }
                }
                break;
            }
            case RIGHT: {
                switch (playerFacing) {
                    case DOWN: {
                        break block0;
                    }
                    case EAST: {
                        facing = EnumFacing.SOUTH;
                        break block0;
                    }
                    case NORTH: {
                        facing = EnumFacing.EAST;
                        break block0;
                    }
                    case SOUTH: {
                        facing = EnumFacing.WEST;
                        break block0;
                    }
                    case UP: {
                        break block0;
                    }
                    case WEST: {
                        facing = EnumFacing.NORTH;
                        break block0;
                    }
                }
                break;
            }
            case PLACE: {
                facing = null;
                if (sideMouseover == null) break;
                posToPlaceAt = pos.func_177972_a(sideMouseover);
            }
        }
        if (facing != null && posToPlaceAt == null) {
            posToPlaceAt = UtilWorld.nextAirInDirection(p.field_70170_p, pos.func_177972_a(facing), facing, 32, null);
        }
        return posToPlaceAt;
    }

    private void castFromServer(BlockPos pos, EnumFacing sideMouseover, EntityPlayer p) {
        BlockPos posToPlaceAt;
        World world = p.func_130014_f_();
        ItemStack heldWand = UtilSpellCaster.getPlayerWandIfHeld(p);
        if (heldWand.func_190926_b()) {
            return;
        }
        int itemSlot = ItemCyclicWand.BuildType.getSlot(heldWand);
        ItemStack TEST = InventoryWand.getFromSlot(heldWand, itemSlot);
        IBlockState state = InventoryWand.getToPlaceFromSlot(heldWand, itemSlot);
        if (state == null || state.func_177230_c() == null) {
            ItemCyclicWand.BuildType.setNextSlot(heldWand);
            itemSlot = ItemCyclicWand.BuildType.getSlot(heldWand);
            state = InventoryWand.getToPlaceFromSlot(heldWand, itemSlot);
            if (state == null || state.func_177230_c() == null) {
                UtilChat.sendStatusMessage(p, "wand.inventory.empty");
                return;
            }
        }
        if ((posToPlaceAt = PacketRangeBuild.getPosToPlaceAt(p, pos, sideMouseover, this.type)) != null && UtilPlaceBlocks.buildStackAsPlayer(world, p, posToPlaceAt, TEST, sideMouseover, this.hitVec, p.func_184172_bi())) {
            UtilSound.playSoundPlaceBlock(p, posToPlaceAt, world.func_180495_p(posToPlaceAt));
            ItemCyclicWand.BuildType.setNextSlot(heldWand);
            if (!p.func_184812_l_()) {
                InventoryWand.decrementSlot(heldWand, itemSlot);
            }
        }
    }
}

