/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item;

import com.google.common.collect.Lists;
import com.lothrazar.cyclicmagic.IContent;
import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.data.IHasRecipe;
import com.lothrazar.cyclicmagic.item.core.BaseTool;
import com.lothrazar.cyclicmagic.net.PacketMoveBlock;
import com.lothrazar.cyclicmagic.registry.ItemRegistry;
import com.lothrazar.cyclicmagic.registry.LootTableRegistry;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.registry.SoundRegistry;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilNBT;
import com.lothrazar.cyclicmagic.util.UtilSound;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.state.BlockPistonStructureHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPistonWand
extends BaseTool
implements IHasRecipe,
IContent {
    private static final int durability = 5000;
    private boolean enabled;

    public ItemPistonWand() {
        super(5000);
    }

    @Override
    public String getContentName() {
        return "tool_push";
    }

    @Override
    public void register() {
        ItemRegistry.register(this, this.getContentName());
        ModCyclic.instance.events.register(this);
        LootTableRegistry.registerLoot(this);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void syncConfig(Configuration config) {
        this.enabled = config.getBoolean("PistonScepter", "cyclicmagic.content", true, this.getContentName() + " Set false to delete - requires restart");
    }

    @SubscribeEvent
    public void onHit(PlayerInteractEvent.LeftClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack held = player.func_184586_b(event.getHand());
        if (held != null && held.func_77973_b() == this) {
            if (ActionType.getTimeout(held) > 0) {
                return;
            }
            ActionType.setTimeout(held);
            event.setCanceled(true);
            UtilSound.playSound(player, player.func_180425_c(), SoundRegistry.tool_mode, SoundCategory.PLAYERS);
            if (!player.func_130014_f_().field_72995_K) {
                ActionType.toggle(held);
                UtilChat.sendStatusMessage(player, UtilChat.lang(ActionType.getName(held)));
            }
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        ActionType action = ActionType.get(stack);
        switch (action) {
            case PUSH: {
                UtilSound.playSound(player, SoundEvents.field_187715_dR);
                EnumFacing direction = side.func_176734_d();
                boolean extending = true;
                BlockPistonStructureHelper blockpistonstructurehelper = new BlockPistonStructureHelper(worldIn, pos.func_177972_a(side), direction, extending);
                if (!blockpistonstructurehelper.func_177253_a()) break;
                List blocksToMove = blockpistonstructurehelper.func_177254_c();
                ArrayList copyStates = Lists.newArrayList();
                for (int i = 0; i < blocksToMove.size(); ++i) {
                    BlockPos blockpos = (BlockPos)blocksToMove.get(i);
                    copyStates.add(worldIn.func_180495_p(blockpos).func_185899_b((IBlockAccess)worldIn, blockpos));
                }
                List toDestroy = blockpistonstructurehelper.func_177252_d();
                int k = blocksToMove.size() + toDestroy.size();
                IBlockState[] aiblockstate = new IBlockState[k];
                EnumFacing enumfacing = extending ? direction : direction.func_176734_d();
                for (int j = toDestroy.size() - 1; j >= 0; --j) {
                    BlockPos blockpos1 = (BlockPos)toDestroy.get(j);
                    IBlockState iblockstate = worldIn.func_180495_p(blockpos1);
                    float chance = iblockstate.func_177230_c() instanceof BlockSnow ? -1.0f : 1.0f;
                    iblockstate.func_177230_c().func_180653_a(worldIn, blockpos1, iblockstate, chance, 0);
                    worldIn.func_180501_a(blockpos1, Blocks.field_150350_a.func_176223_P(), 4);
                    aiblockstate[--k] = iblockstate;
                }
                for (int l = blocksToMove.size() - 1; l >= 0; --l) {
                    BlockPos blockpos3 = (BlockPos)blocksToMove.get(l);
                    IBlockState iblockstate2 = worldIn.func_180495_p(blockpos3);
                    worldIn.func_180501_a(blockpos3, Blocks.field_150350_a.func_176223_P(), 2);
                    blockpos3 = blockpos3.func_177972_a(enumfacing);
                    if (!player.func_175151_a(blockpos3, side, ItemStack.field_190927_a)) {
                        ModCyclic.logger.log("piston scepter: cannot edit", new Object[0]);
                        continue;
                    }
                    worldIn.func_180501_a(blockpos3, iblockstate2, 4);
                }
                break;
            }
            case PULL: {
                UtilSound.playSound(player, SoundEvents.field_187715_dR);
                ModCyclic.network.sendToServer((IMessage)new PacketMoveBlock(pos, action, side));
                break;
            }
        }
        this.onUse(stack, player, worldIn, hand);
        return EnumActionResult.SUCCESS;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(TextFormatting.GREEN + UtilChat.lang(ActionType.getName(stack)));
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        ActionType.tickTimeout(stack);
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedRecipe(new ItemStack((Item)this), " gp", " bg", "b  ", Character.valueOf('b'), Items.field_151072_bj, Character.valueOf('g'), "gemQuartz", Character.valueOf('p'), Blocks.field_150320_F);
    }

    public static enum ActionType {
        PUSH,
        PULL,
        ROTATE;

        private static final String NBT = "ActionType";
        private static final String NBTTIMEOUT = "timeout";

        public static int getTimeout(ItemStack wand) {
            return UtilNBT.getItemStackNBT(wand).func_74762_e(NBTTIMEOUT);
        }

        public static void setTimeout(ItemStack wand) {
            UtilNBT.getItemStackNBT(wand).func_74768_a(NBTTIMEOUT, 15);
        }

        public static void tickTimeout(ItemStack wand) {
            NBTTagCompound tags = UtilNBT.getItemStackNBT(wand);
            int t = tags.func_74762_e(NBTTIMEOUT);
            if (t > 0) {
                UtilNBT.getItemStackNBT(wand).func_74768_a(NBTTIMEOUT, t - 1);
            }
        }

        public static ActionType get(ItemStack wand) {
            if (wand == null) {
                return PUSH;
            }
            NBTTagCompound tags = UtilNBT.getItemStackNBT(wand);
            int get = tags.func_74762_e(NBT);
            if (get >= ActionType.values().length) {
                return PUSH;
            }
            return ActionType.values()[get];
        }

        public static String getName(ItemStack wand) {
            return "tool.action." + ActionType.get(wand).toString().toLowerCase();
        }

        public static void toggle(ItemStack wand) {
            NBTTagCompound tags = UtilNBT.getItemStackNBT(wand);
            int type = tags.func_74762_e(NBT);
            if (++type > PULL.ordinal()) {
                type = PUSH.ordinal();
            }
            tags.func_74768_a(NBT, type);
            wand.func_77982_d(tags);
        }
    }
}

