/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item;

import com.lothrazar.cyclicmagic.IContent;
import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.data.IHasRecipe;
import com.lothrazar.cyclicmagic.guide.GuideCategory;
import com.lothrazar.cyclicmagic.item.core.BaseTool;
import com.lothrazar.cyclicmagic.registry.ItemRegistry;
import com.lothrazar.cyclicmagic.registry.LootTableRegistry;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.util.UtilEntity;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import com.lothrazar.cyclicmagic.util.UtilSound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityEvokerFangs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;

public class ItemEvokerFangs
extends BaseTool
implements IHasRecipe,
IContent {
    private static final int COOLDOWN = 10;
    private static final int DURABILITY = 666;
    private static final int MAX_RANGE = 16;
    private boolean enabled;

    public ItemEvokerFangs() {
        super(666);
    }

    @Override
    public String getContentName() {
        return "evoker_fang";
    }

    @Override
    public void register() {
        ItemRegistry.register(this, this.getContentName(), GuideCategory.ITEM);
        LootTableRegistry.registerLoot(this);
        ModCyclic.instance.events.register(this);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void syncConfig(Configuration config) {
        this.enabled = config.getBoolean("EvokerFang", "cyclicmagic.content", true, " Set false to delete - requires restart");
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase entity, EnumHand hand) {
        if (player.func_184811_cZ().func_185141_a((Item)this)) {
            return false;
        }
        this.summonFangRay(player.field_70165_t, player.field_70161_v, player, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        UtilItemStack.damageItem(player, player.func_184586_b(hand));
        return true;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player.func_184811_cZ().func_185141_a((Item)this)) {
            return super.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
        }
        this.summonFangRay(pos.func_177958_n(), pos.func_177952_p(), player, (float)pos.func_177958_n() + hitX, (float)pos.func_177956_o() + hitY, (float)pos.func_177952_p() + hitZ);
        UtilItemStack.damageItem(player, player.func_184586_b(hand));
        return EnumActionResult.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        BlockPos target = playerIn.func_180425_c().func_177972_a(playerIn.func_184172_bi());
        this.summonFangRay(playerIn.field_70165_t, playerIn.field_70161_v, playerIn, target.func_177958_n(), target.func_177956_o(), target.func_177952_p());
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    private void summonFangRay(double startX, double startZ, EntityPlayer caster, double posX, double posY, double posZ) {
        double minY = posY;
        float arctan = (float)MathHelper.func_181159_b((double)(posZ - caster.field_70161_v), (double)(posX - caster.field_70165_t));
        for (int i = 0; i < 16; ++i) {
            double fract = 1.25 * (double)(i + 1);
            this.summonFangSingle(caster, startX + (double)MathHelper.func_76134_b((float)arctan) * fract, minY, startZ + (double)MathHelper.func_76126_a((float)arctan) * fract, arctan, i);
        }
        this.onCastSuccess(caster);
    }

    private void summonFangSingle(EntityPlayer caster, double x, double y, double z, float yaw, int delay) {
        EntityEvokerFangs entityevokerfangs = new EntityEvokerFangs(caster.field_70170_p, x, y, z, yaw, delay, (EntityLivingBase)caster);
        if (!caster.field_70170_p.field_72995_K) {
            caster.field_70170_p.func_72838_d((Entity)entityevokerfangs);
        }
    }

    private void onCastSuccess(EntityPlayer caster) {
        UtilSound.playSound(caster, SoundEvents.field_191247_bq);
        UtilEntity.setCooldownItem(caster, this, 10);
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedRecipe(new ItemStack((Item)this), "wpc", " dp", "r w", Character.valueOf('w'), Blocks.field_150321_G, Character.valueOf('r'), Items.field_151072_bj, Character.valueOf('c'), Items.field_185158_cP, Character.valueOf('p'), Blocks.field_150432_aD, Character.valueOf('d'), "gemEmerald");
    }
}

