/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.enchant;

import com.lothrazar.cyclicmagic.config.IHasConfig;
import com.lothrazar.cyclicmagic.enchant.BaseEnchant;
import com.lothrazar.cyclicmagic.guide.GuideRegistry;
import com.lothrazar.cyclicmagic.registry.EnchantRegistry;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnchantExcavation
extends BaseEnchant
implements IHasConfig {
    private boolean enabled;
    int[] levelToMaxBreak;

    public EnchantExcavation() {
        super("excavation", Enchantment.Rarity.VERY_RARE, EnumEnchantmentType.DIGGER, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND});
        GuideRegistry.register(this, new ArrayList<String>());
    }

    @Override
    public void register() {
        EnchantRegistry.register(this);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    public int func_77325_b() {
        return 3;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onBreakEvent(BlockEvent.BreakEvent event) {
        World world = event.getWorld();
        EntityPlayer player = event.getPlayer();
        if (player.field_184622_au == null) {
            return;
        }
        BlockPos pos = event.getPos();
        Block block = event.getState().func_177230_c();
        ItemStack stackHarvestingWith = player.func_184586_b(player.field_184622_au);
        int level = this.getCurrentLevelTool(stackHarvestingWith);
        if (level <= 0) {
            return;
        }
        boolean isAnySingleOk = false;
        for (String type : stackHarvestingWith.func_77973_b().getToolClasses(stackHarvestingWith)) {
            if (!block.isToolEffective(type, world.func_180495_p(pos))) continue;
            isAnySingleOk = true;
        }
        if (isAnySingleOk) {
            try {
                this.harvestSurrounding(world, player, pos, block, 1, level, player.field_184622_au);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private int getHarvestMax(int level) {
        if (level >= this.levelToMaxBreak.length) {
            level = this.levelToMaxBreak.length - 1;
        }
        return this.levelToMaxBreak[level];
    }

    private int harvestSurrounding(World world, EntityPlayer player, BlockPos posIn, Block block, int totalBroken, int level, EnumHand swingingHand) {
        if (totalBroken >= this.getHarvestMax(level) || player.func_184586_b(player.field_184622_au).func_190926_b()) {
            return totalBroken;
        }
        int fortuneXp = 0;
        List<Object> theFuture = new ArrayList();
        try {
            theFuture = this.getMatchingSurrounding(world, posIn, block);
        }
        catch (Exception e) {
            return totalBroken;
        }
        ArrayList<BlockPos> wasHarvested = new ArrayList<BlockPos>();
        for (BlockPos blockPos : theFuture) {
            if (UtilItemStack.isBroken(player.func_184586_b(player.field_184622_au))) break;
            IBlockState targetState = world.func_180495_p(blockPos);
            if (world.func_175623_d(blockPos) || !player.func_184823_b(targetState) || totalBroken >= this.getHarvestMax(level) || player.func_184586_b(player.field_184622_au).func_190926_b()) continue;
            block.func_180657_a(world, player, blockPos, targetState, null, player.func_184586_b(swingingHand));
            block.func_180637_b(world, blockPos, block.getExpDrop(targetState, (IBlockAccess)world, blockPos, fortuneXp));
            world.func_175655_b(blockPos, false);
            wasHarvested.add(blockPos);
            player.func_184586_b(player.field_184622_au).func_96631_a(1, world.field_73012_v, null);
            ++totalBroken;
        }
        for (BlockPos blockPos : theFuture) {
            if (UtilItemStack.isBroken(player.func_184586_b(player.field_184622_au)) || totalBroken >= this.getHarvestMax(level)) break;
            totalBroken += this.harvestSurrounding(world, player, blockPos, block, totalBroken, level, swingingHand);
        }
        return totalBroken;
    }

    private List<BlockPos> getMatchingSurrounding(World world, BlockPos start, Block blockIn) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        List<EnumFacing> targetFaces = Arrays.asList(EnumFacing.values());
        Collections.shuffle(targetFaces);
        for (EnumFacing fac : targetFaces) {
            BlockPos current = start.func_177972_a(fac);
            IBlockState currentState = world.func_180495_p(current);
            if (currentState.func_177230_c() != blockIn) continue;
            list.add(current);
        }
        return list;
    }

    @Override
    public void syncConfig(Configuration config) {
        this.enabled = config.getBoolean("EnchantExcavation", "cyclicmagic.content", true, " Set false to delete - requires restart");
        this.levelToMaxBreak = new int[this.func_77325_b() + 1];
        this.levelToMaxBreak[0] = 0;
        for (int i = 1; i <= this.func_77325_b(); ++i) {
            this.levelToMaxBreak[i] = config.getInt("EnchantExcavationBreak" + i, "modpacks", 10 + i * 16, 1, 512, "Max blocks broken by this enchantment at level " + i);
        }
    }
}

