/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.core;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.block.core.BaseMachineTESR;
import com.lothrazar.cyclicmagic.block.core.TileEntityBaseMachineInvo;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class MachineTESR
extends BaseMachineTESR<TileEntityBaseMachineInvo> {
    float itemRenderHeight = 0.99f;

    public MachineTESR(Block block, int slot) {
        super(block, slot);
    }

    public MachineTESR(Block block) {
        this(block, -1);
    }

    @Override
    public void render(TileEntityBaseMachineInvo te, double x, double y, double z, float partialTicks, int destroyStage, float p) {
        super.render(te, x, y, z, partialTicks, destroyStage, p);
    }

    protected IBakedModel getBakedModel() {
        if (this.bakedModel == null && this.resource != null) {
            try {
                this.model = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("cyclicmagic", this.resource));
            }
            catch (Exception e) {
                ModCyclic.logger.error("Error trying to obtain baked model", e);
                return null;
            }
            this.bakedModel = this.model.bake((IModelState)TRSRTransformation.identity(), DefaultVertexFormats.field_176599_b, (Function)new Function<ResourceLocation, TextureAtlasSprite>(){

                @Override
                public TextureAtlasSprite apply(ResourceLocation location) {
                    return Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
                }
            });
        }
        return this.bakedModel;
    }

    protected void renderAnimation(TileEntityBaseMachineInvo te) {
        if (Minecraft.func_71410_x() == null || Minecraft.func_71410_x().func_175602_ab() == null || Minecraft.func_71410_x().func_175602_ab().func_175019_b() == null || this.getBakedModel() == null) {
            ModCyclic.logger.error("TESR render animation caught by null check");
            return;
        }
        GlStateManager.func_179094_E();
        EnumFacing facing = te.getCurrentFacing();
        if (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) {
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)-1.0f, (float)0.0f, (float)0.0f);
        }
        double currTenthOfSec = System.currentTimeMillis() / 100L;
        double ratio = currTenthOfSec % 8.0 / 10.0;
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)(-1.0 * ratio));
        RenderHelper.func_74518_a();
        this.func_147499_a(TextureMap.field_110575_b);
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        World world = te.func_145831_w();
        try {
            GlStateManager.func_179109_b((float)(-te.func_174877_v().func_177958_n()), (float)(-te.func_174877_v().func_177956_o()), (float)(-te.func_174877_v().func_177952_p()));
            Tessellator tessellator = Tessellator.func_178181_a();
            tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_176600_a);
            Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_178267_a((IBlockAccess)world, this.getBakedModel(), world.func_180495_p(te.func_174877_v()), te.func_174877_v(), Tessellator.func_178181_a().func_178180_c(), false);
            tessellator.func_78381_a();
        }
        catch (IllegalStateException alreadyBuilding) {
            ModCyclic.logger.info("Already building!  BufferBuilder:isDrawing == true I suppose: " + alreadyBuilding.getMessage(), new Object[0]);
        }
        catch (Exception e) {
            ModCyclic.logger.error("TESR render baked model exception", e);
        }
        RenderHelper.func_74519_b();
        GlStateManager.func_179121_F();
    }

    @Override
    public void renderBasic(TileEntityBaseMachineInvo te) {
        ItemStack stack;
        if (te == null) {
            return;
        }
        this.renderAnimation(te);
        if (this.itemSlotAbove >= 0 && !(stack = te.func_70301_a(this.itemSlotAbove)).func_190926_b()) {
            this.renderItem(te, stack, this.itemRenderHeight);
        }
    }
}

