/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.cablewireless.item;

import com.lothrazar.cyclicmagic.block.cablewireless.ILaserTarget;
import com.lothrazar.cyclicmagic.block.core.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.data.BlockPosDim;
import com.lothrazar.cyclicmagic.data.ITileRedstoneToggle;
import com.lothrazar.cyclicmagic.item.locationgps.ItemLocationGps;
import com.lothrazar.cyclicmagic.util.RenderUtil;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import com.lothrazar.cyclicmagic.util.UtilWorld;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;

public class TileCableContentWireless
extends TileEntityBaseMachineInvo
implements ILaserTarget,
ITickable,
ITileRedstoneToggle {
    public static final int SLOT_TRANSFER = 0;
    public static final int MAX_TRANSFER = 2;
    public static final int SLOT_COUNT = 10;
    List<Integer> slotList = IntStream.rangeClosed(0, 9).boxed().collect(Collectors.toList());
    private int transferRate = 1;
    static final float[] laserColor = new float[]{0.3f, 0.0f, 0.6f};
    static final double rotationTime = 0.0;
    static final double beamWidth = 0.02;
    static final float alpha = 0.5f;

    public TileCableContentWireless() {
        super(10);
        this.setSlotsForInsert(0);
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(Fields.values().length);
    }

    @Override
    public int func_174887_a_(int id) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case TRANSFER_RATE: {
                return this.transferRate;
            }
            case RENDERPARTICLES: {
                return this.renderParticles;
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case TRANSFER_RATE: {
                this.transferRate = value;
                break;
            }
            case RENDERPARTICLES: {
                this.renderParticles = value % 2;
            }
        }
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        return index == 0 ? true : stack.func_77973_b() instanceof ItemLocationGps;
    }

    private BlockPosDim getSlotGps(int slot) {
        return ItemLocationGps.getPosition(this.func_70301_a(slot));
    }

    public void func_73660_a() {
        if (!this.isRunning()) {
            return;
        }
        Collections.shuffle(this.slotList);
        for (int slot : this.slotList) {
            this.outputItems(slot);
        }
    }

    @Override
    public void toggleNeedsRedstone() {
        int val = this.needsRedstone == 1 ? 0 : 1;
        this.func_174885_b(Fields.REDSTONE.ordinal(), val);
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    private boolean isTargetValid(BlockPosDim target) {
        return target != null && target.getDimension() == this.getDimension() && this.field_145850_b.func_175707_a(target.toBlockPos(), target.toBlockPos().func_177984_a());
    }

    private void outputItems(int slot) {
        BlockPosDim dim = this.getSlotGps(slot);
        if (!this.isTargetValid(dim)) {
            return;
        }
        BlockPos target = dim.toBlockPos();
        ItemStack stackToExport = this.func_70301_a(0).func_77946_l();
        stackToExport.func_190920_e(1);
        if (!stackToExport.func_190926_b()) {
            ItemStack leftAfterDeposit;
            EnumFacing sideTarget = dim.getSide();
            if (sideTarget == null) {
                UtilWorld.getRandFacing();
            }
            if ((leftAfterDeposit = UtilItemStack.tryDepositToHandler(this.field_145850_b, target, sideTarget, stackToExport)).func_190926_b() || leftAfterDeposit.func_190916_E() < stackToExport.func_190916_E()) {
                this.decrStackSize(0);
            }
        }
    }

    @Override
    public boolean isPreviewVisible() {
        return this.renderParticles == 1;
    }

    @Override
    public List<RenderUtil.LaserConfig> getTarget() {
        BlockPosDim first = new BlockPosDim(this.func_174877_v(), this.getDimension());
        ArrayList<RenderUtil.LaserConfig> laser = new ArrayList<RenderUtil.LaserConfig>();
        for (BlockPos second : this.getShape()) {
            if (second == null || first == null) continue;
            laser.add(new RenderUtil.LaserConfig(first.toBlockPos(), second, 0.0, 0.5f, 0.02, laserColor));
        }
        return laser;
    }

    @Override
    public List<BlockPos> getShape() {
        ArrayList<BlockPos> shape = new ArrayList<BlockPos>();
        for (int slot : this.slotList) {
            BlockPosDim target;
            if (this.func_70301_a(slot).func_190926_b() || !this.isTargetValid(target = this.getSlotGps(slot))) continue;
            shape.add(target.toBlockPos());
        }
        return shape;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.transferRate = compound.func_74762_e("transferRate");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("transferRate", this.transferRate);
        return super.func_189515_b(compound);
    }

    public static enum Fields {
        REDSTONE,
        TRANSFER_RATE,
        RENDERPARTICLES;

    }
}

