/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.block;

import epicsquid.mysticallib.LibRegistry;
import epicsquid.mysticallib.block.IBlock;
import epicsquid.mysticallib.model.IModeledObject;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;

public class BlockLadderBase
extends BlockLadder
implements IBlock,
IModeledObject {
    @Nonnull
    private Item itemBlock;
    public List<ItemStack> drops = null;
    private boolean hasCustomModel = false;
    private boolean isFlammable = false;
    private Block parent;
    public String name;

    public BlockLadderBase(@Nonnull Block base, float hardness, @Nonnull String name) {
        this.parent = base;
        this.name = name;
        this.func_149647_a(null);
        this.func_149663_c(name);
        this.setRegistryName(LibRegistry.getActiveModid(), name);
        this.func_149711_c(hardness);
        this.field_149787_q = false;
        this.itemBlock = (Item)new ItemBlock((Block)this).func_77655_b(name).setRegistryName(LibRegistry.getActiveModid(), name);
    }

    @Nonnull
    public BlockLadderBase setFlammable(boolean flammable) {
        this.isFlammable = flammable;
        return this;
    }

    @Nonnull
    public BlockLadderBase setResistance(float resistance) {
        super.func_149752_b(resistance);
        return this;
    }

    @Nonnull
    public BlockLadderBase setModelCustom(boolean custom) {
        this.hasCustomModel = custom;
        return this;
    }

    @Nonnull
    public BlockLadderBase setHarvestReqs(String tool, int level) {
        this.setHarvestLevel(tool, level);
        return this;
    }

    public boolean hasCustomModel() {
        return this.hasCustomModel;
    }

    public boolean isFlammable(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        return this.isFlammable || super.isFlammable(world, pos, face);
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.isFlammable ? 100 : super.getFlammability(world, pos, face);
    }

    @Override
    @Nonnull
    public Item getItemBlock() {
        return this.itemBlock;
    }

    @Override
    public ItemBlock setItemBlock(ItemBlock block) {
        this.itemBlock = block;
        return block;
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(this.itemBlock);
    }

    @Nonnull
    public Block getParent() {
        return this.parent;
    }

    @Override
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this.itemBlock, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }
}

