/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.excore.utils.client.gui.elements;

import code.elix_x.excomms.color.RGBA;
import code.elix_x.excore.utils.client.gui.elements.IGuiElement;
import code.elix_x.excore.utils.client.gui.elements.IGuiElementsHandler;
import code.elix_x.excore.utils.client.gui.elements.RectangularGuiElement;
import java.lang.reflect.Array;
import net.minecraft.client.gui.GuiScreen;

public class GridGuiElement<H extends IGuiElementsHandler<? extends IGuiElement<H>>>
extends RectangularGuiElement<H> {
    protected GridElement[][] elements;
    protected int elementsX;
    protected int elementsY;
    public int elementX;
    public int elementY;
    public RGBA backgroundColor;

    public GridGuiElement(String name, int xPos, int yPos, int elementX, int elementY, int elementsX, int elementsY, int borderX, int borderY, RGBA backgroundColor) {
        super(name, xPos, yPos, 0, 0, borderX, borderY);
        this.elements = (GridElement[][])Array.newInstance(GridElement.class, elementsX, elementsY);
        this.elementsX = elementsX;
        this.elementsY = elementsY;
        this.elementX = elementX;
        this.elementY = elementY;
        this.backgroundColor = backgroundColor;
    }

    public GridGuiElement(String name, int posX, int posY, int elementX, int elementY, int elementsX, int elementsY, int borderX, int borderY) {
        this(name, posX, posY, elementX, elementY, elementsX, elementsY, borderX, borderY, new RGBA(0, 0, 0, 0));
    }

    public GridGuiElement(String name, int posX, int posY, int elementX, int elementY, int elementsX, int elementsY) {
        this(name, posX, posY, elementX, elementY, elementsX, elementsY, 2, 2);
    }

    @Override
    public int getWidth() {
        return this.borderX + this.elementsX * (this.elementX + this.borderX);
    }

    @Override
    public int getHeight() {
        return this.borderY + this.elementsY * (this.elementY + this.borderY);
    }

    protected void reInitElements() {
        this.elements = (GridElement[][])Array.newInstance(GridElement.class, this.elementsX, this.elementsY);
    }

    public int getElementsX() {
        return this.elementsX;
    }

    public int getElementsY() {
        return this.elementsY;
    }

    public void setElementsXY(int elementsX, int elementsY) {
        this.elementsX = elementsX;
        this.elementsY = elementsY;
        GridElement[][] old = this.elements;
        this.reInitElements();
        for (int x = 0; x < Math.min(old.length, this.elements.length); ++x) {
            GridElement[] oldd = old[x];
            GridElement[] neww = this.elements[x];
            for (int y = 0; y < Math.min(oldd.length, neww.length); ++y) {
                neww[y] = oldd[y];
            }
        }
    }

    public GridElement getElement(int x, int y) {
        return this.elements[x][y];
    }

    public void addElement(GridElement element, int x, int y) {
        this.elements[x][y] = element;
    }

    public void addElement(GridElement element) {
        for (int x = 0; x < this.elementsX; ++x) {
            for (int y = 0; y < this.elementsY; ++y) {
                if (this.elements[x][y] != null) continue;
                this.elements[x][y] = element;
                return;
            }
        }
    }

    public int getX(GridElement element) {
        for (int x = 0; x < this.elementsX; ++x) {
            for (int y = 0; y < this.elementsY; ++y) {
                if (this.elements[x][y] != element) continue;
                return x;
            }
        }
        return -1;
    }

    public int getY(GridElement element) {
        for (int x = 0; x < this.elementsX; ++x) {
            for (int y = 0; y < this.elementsY; ++y) {
                if (this.elements[x][y] != element) continue;
                return y;
            }
        }
        return -1;
    }

    public int calcAbsX(int x) {
        return this.getXPos() + this.borderX + x * (this.borderX + this.elementX);
    }

    public int calcAbsY(int y) {
        return this.getYPos() + this.borderY + y * (this.borderY + this.elementY);
    }

    public int calcLocalX(int x) {
        return (x - this.getXPos() - this.borderX) / (this.borderX + this.elementX);
    }

    public int calcLocalY(int y) {
        return (y - this.getYPos() - this.borderY) / (this.borderY + this.elementY);
    }

    @Override
    public void openGui(H handler, GuiScreen gui) {
    }

    @Override
    public void initGui(H handler, GuiScreen gui) {
        for (int x = 0; x < this.elements.length; ++x) {
            GridElement[] es = this.elements[x];
            for (int y = 0; y < es.length; ++y) {
                GridElement e = es[y];
                if (e == null) continue;
                e.initGui(handler, gui, this.calcAbsX(x), this.calcAbsY(y));
            }
        }
    }

    @Override
    public void drawGuiPre(H handler, GuiScreen gui, int mouseX, int mouseY, float partialTicks) {
        for (int x = 0; x < this.elements.length; ++x) {
            GridElement[] es = this.elements[x];
            for (int y = 0; y < es.length; ++y) {
                GridElement e = es[y];
                if (e == null) continue;
                e.drawGuiPre(handler, gui, this.calcAbsX(x), this.calcAbsY(y), mouseX, mouseY);
            }
        }
    }

    @Override
    public void drawBackground(H handler, GuiScreen gui, int mouseX, int mouseY, float partialTicks) {
        for (int x = 0; x < this.elements.length; ++x) {
            GridElement[] es = this.elements[x];
            for (int y = 0; y < es.length; ++y) {
                GridElement e = es[y];
                if (e == null) continue;
                e.drawBackground(handler, gui, this.calcAbsX(x), this.calcAbsY(y), mouseX, mouseY);
            }
        }
    }

    @Override
    public void drawGuiPost(H handler, GuiScreen gui, int mouseX, int mouseY, float partialTicks) {
        this.fill(this.backgroundColor);
        for (int x = 0; x < this.elements.length; ++x) {
            GridElement[] es = this.elements[x];
            for (int y = 0; y < es.length; ++y) {
                GridElement e = es[y];
                if (e == null) continue;
                e.drawGuiPost(handler, gui, this.calcAbsX(x), this.calcAbsY(y), mouseX, mouseY);
            }
        }
    }

    @Override
    public void drawGuiPostPost(H handler, GuiScreen gui, int mouseX, int mouseY, float partialTicks) {
        for (int x = 0; x < this.elements.length; ++x) {
            GridElement[] es = this.elements[x];
            for (int y = 0; y < es.length; ++y) {
                GridElement e = es[y];
                if (e == null) continue;
                e.drawGuiPostPost(handler, gui, this.calcAbsX(x), this.calcAbsY(y), mouseX, mouseY);
            }
        }
    }

    @Override
    public boolean handleKeyboardEvent(H handler, GuiScreen gui, boolean down, int key, char c) {
        for (int x = 0; x < this.elements.length; ++x) {
            GridElement[] es = this.elements[x];
            for (int y = 0; y < es.length; ++y) {
                GridElement e = es[y];
                if (e == null || !e.handleKeyboardEvent(handler, gui, this.calcAbsX(x), this.calcAbsY(y), down, key, c)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean handleMouseEvent(H handler, GuiScreen gui, int mouseX, int mouseY, boolean down, int key) {
        for (int x = 0; x < this.elements.length; ++x) {
            GridElement[] es = this.elements[x];
            for (int y = 0; y < es.length; ++y) {
                GridElement e = es[y];
                if (e == null || !e.handleMouseEvent(handler, gui, this.calcAbsX(x), this.calcAbsY(y), mouseX, mouseY, down, key)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean handleMouseEvent(H handler, GuiScreen gui, int mouseX, int mouseY, int dWheel) {
        for (int x = 0; x < this.elements.length; ++x) {
            GridElement[] es = this.elements[x];
            for (int y = 0; y < es.length; ++y) {
                GridElement e = es[y];
                if (e == null || !e.handleMouseEvent(handler, gui, this.calcAbsX(x), this.calcAbsY(y), mouseX, mouseY, dWheel)) continue;
                return true;
            }
        }
        return false;
    }

    public class GridElement {
        public boolean inside(int relX, int relY, int mouseX, int mouseY) {
            return relX <= mouseX && mouseX <= relX + GridGuiElement.this.elementX && relY <= mouseY && mouseY <= relY + GridGuiElement.this.elementY;
        }

        public void initGui(H handler, GuiScreen gui, int relX, int relY) {
        }

        public void drawBackground(H handler, GuiScreen gui, int relX, int relY, int mouseX, int mouseY) {
        }

        public void drawGuiPre(H handler, GuiScreen gui, int relX, int relY, int mouseX, int mouseY) {
        }

        public void drawGuiPost(H handler, GuiScreen gui, int relX, int relY, int mouseX, int mouseY) {
        }

        public void drawGuiPostPost(H handler, GuiScreen gui, int relX, int relY, int mouseX, int mouseY) {
        }

        public boolean handleKeyboardEvent(H handler, GuiScreen gui, int relX, int relY, boolean down, int key, char c) {
            return false;
        }

        public boolean handleMouseEvent(H handler, GuiScreen gui, int relX, int relY, int mouseX, int mouseY, boolean down, int key) {
            return false;
        }

        public boolean handleMouseEvent(H handler, GuiScreen gui, int relX, int relY, int mouseX, int mouseY, int dWheel) {
            return false;
        }
    }
}

