/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.excomms.math;

import code.elix_x.excomms.reflection.ReflectionHelper;
import com.google.common.primitives.Bytes;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.common.primitives.Shorts;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Stream;

public class NumberUtils {
    public static BigDecimal toBigDecimal(Number number) {
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        return new BigDecimal(number.toString());
    }

    public static <N extends Number> N fromBigDecimal(BigDecimal number, Class<N> n) {
        if (n == BigDecimal.class) {
            return (N)number;
        }
        return (N)((Number)new ReflectionHelper.AClass<N>(n).getDeclaredConstructor(String.class).orElseThrow(IllegalArgumentException::new).newInstance(number.toString()).orElseThrow(IllegalArgumentException::new));
    }

    public static byte min(byte ... ints) {
        return (Byte)NumberUtils.minComparable(Bytes.asList((byte[])ints));
    }

    public static byte max(byte ... ints) {
        return (Byte)NumberUtils.maxComparable(Bytes.asList((byte[])ints));
    }

    public static short min(short ... shorts) {
        return (Short)NumberUtils.minComparable(Shorts.asList((short[])shorts));
    }

    public static short max(short ... shorts) {
        return (Short)NumberUtils.maxComparable(Shorts.asList((short[])shorts));
    }

    public static int min(int ... ints) {
        return (Integer)NumberUtils.minComparable(Ints.asList((int[])ints));
    }

    public static int max(int ... ints) {
        return (Integer)NumberUtils.maxComparable(Ints.asList((int[])ints));
    }

    public static long min(long ... longs) {
        return (Long)NumberUtils.minComparable(Longs.asList((long[])longs));
    }

    public static long max(long ... longs) {
        return (Long)NumberUtils.maxComparable(Longs.asList((long[])longs));
    }

    public static float min(float ... floats) {
        return ((Float)NumberUtils.minComparable(Floats.asList((float[])floats))).floatValue();
    }

    public static float max(float ... floats) {
        return ((Float)NumberUtils.maxComparable(Floats.asList((float[])floats))).floatValue();
    }

    public static double min(double ... doubles) {
        return (Double)NumberUtils.minComparable(Doubles.asList((double[])doubles));
    }

    public static double max(double ... doubles) {
        return (Double)NumberUtils.maxComparable(Doubles.asList((double[])doubles));
    }

    @SafeVarargs
    public static <N extends Number> N minComparable(N ... numbers) {
        return NumberUtils.minComparable(Arrays.stream(numbers));
    }

    @SafeVarargs
    public static <N extends Number> N maxComparable(N ... numbers) {
        return NumberUtils.maxComparable(Arrays.stream(numbers));
    }

    public static <N extends Number> N minComparable(Collection<N> numbers) {
        return NumberUtils.minComparable(numbers.stream());
    }

    public static <N extends Number> N maxComparable(Collection<N> numbers) {
        return NumberUtils.maxComparable(numbers.stream());
    }

    public static <N extends Number> N minComparable(Stream<N> numbers) {
        return (N)((Number)numbers.min((n1, n2) -> ((Comparable)((Object)n1)).compareTo(n2)).get());
    }

    public static <N extends Number> N maxComparable(Stream<N> numbers) {
        return (N)((Number)numbers.max((n1, n2) -> ((Comparable)((Object)n1)).compareTo(n2)).get());
    }

    @SafeVarargs
    public static <N extends Number> N min(N ... numbers) {
        return NumberUtils.min(Arrays.stream(numbers));
    }

    @SafeVarargs
    public static <N extends Number> N max(N ... numbers) {
        return NumberUtils.max(Arrays.stream(numbers));
    }

    public static <N extends Number> N min(Collection<N> numbers) {
        return NumberUtils.min(numbers.stream());
    }

    public static <N extends Number> N max(Collection<N> numbers) {
        return NumberUtils.max(numbers.stream());
    }

    public static <N extends Number> N min(Stream<N> numbers) {
        Number number = (Number)numbers.findAny().get();
        if (number instanceof Comparable) {
            return NumberUtils.minComparable(numbers);
        }
        return (N)NumberUtils.fromBigDecimal(NumberUtils.minComparable(numbers.map(n -> NumberUtils.toBigDecimal(n))), number.getClass());
    }

    public static <N extends Number> N max(Stream<N> numbers) {
        Number number = (Number)numbers.findAny().get();
        if (number instanceof Comparable) {
            return NumberUtils.maxComparable(numbers);
        }
        return (N)NumberUtils.fromBigDecimal(NumberUtils.maxComparable(numbers.map(n -> NumberUtils.toBigDecimal(n))), number.getClass());
    }
}

