/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.command;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.handlers.IProcess;
import com.brandon3055.brandonscore.handlers.ProcessHandler;
import com.brandon3055.brandonscore.network.PacketTickTime;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CommandTickTime
extends CommandBase {
    private Map<String, TickSenderProcess> listeners = new HashMap<String, TickSenderProcess>();

    public String func_71517_b() {
        return "bcore_ticktime";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/bcore_ticktime";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        String name = sender.func_70005_c_();
        if (this.listeners.containsKey(name)) {
            if (!this.listeners.get(name).isDead()) {
                this.listeners.get(name).setDead();
                this.listeners.remove(name);
                sender.func_145747_a((ITextComponent)new TextComponentString("Stopped sending tick time to client. (Display will go away after a few seconds)"));
                return;
            }
            this.listeners.remove(name);
        }
        PlayerList list = server.func_184103_al();
        TickSenderProcess process = new TickSenderProcess(sender.func_70005_c_(), list);
        this.listeners.put(sender.func_70005_c_(), process);
        ProcessHandler.addProcess(process);
        sender.func_145747_a((ITextComponent)new TextComponentString("Started sending tick time to client."));
    }

    public int func_82362_a() {
        return 2;
    }

    private class TickSenderProcess
    implements IProcess {
        private boolean isDead = false;
        private String username;
        private PlayerList playerList;
        private MinecraftServer server;
        private int timeout = 0;

        public TickSenderProcess(String listener, PlayerList playerList) {
            this.username = listener;
            this.playerList = playerList;
            this.server = playerList.func_72365_p();
        }

        @Override
        public void updateProcess() {
            EntityPlayerMP player = this.playerList.func_152612_a(this.username);
            if (player == null) {
                ++this.timeout;
                if (this.timeout > 100) {
                    this.setDead();
                }
                return;
            }
            this.timeout = 0;
            int overallTick = (int)(this.server.field_71311_j[this.server.func_71259_af() % 100] / 10000L);
            HashMap<Integer, Integer> dimTimes = new HashMap<Integer, Integer>();
            Hashtable worldTickTimes = this.server.worldTickTimes;
            for (Integer dim : worldTickTimes.keySet()) {
                dimTimes.put(dim, (int)(((long[])worldTickTimes.get(dim))[this.server.func_71259_af() % 100] / 10000L));
            }
            BrandonsCore.network.sendTo((IMessage)new PacketTickTime(dimTimes, overallTick), player);
        }

        @Override
        public boolean isDead() {
            return this.isDead;
        }

        public void setDead() {
            this.isDead = true;
        }
    }
}

