/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.util;

import epicsquid.mysticallib.types.OneTimeSupplier;
import epicsquid.mysticallib.util.ItemUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.OreIngredient;

public class OreDictCache {
    private static Map<String, Supplier<Ingredient>> entries = new HashMap<String, Supplier<Ingredient>>();
    private static Map<String, Set<Supplier<Ingredient>>> prefixMatches = new HashMap<String, Set<Supplier<Ingredient>>>();
    private static Set<String> noIngredients = new HashSet<String>();

    public static boolean matches(String oreName, IBlockState state) {
        return OreDictCache.matches(oreName, ItemUtil.stackFromState((IBlockState)state));
    }

    public static boolean matches(String oreName, Block block) {
        return OreDictCache.matches(oreName, new ItemStack(block));
    }

    public static boolean matches(String oreName, ItemStack stack) {
        if (stack.func_190926_b() || oreName == null || oreName.isEmpty()) {
            return false;
        }
        return ((Ingredient)entries.computeIfAbsent(oreName, name -> new OneTimeSupplier(() -> new OreIngredient(name))).get()).apply(stack);
    }

    public static boolean matchesPrefix(String prefix, ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (noIngredients.contains(prefix)) {
            return false;
        }
        Set matches = prefixMatches.computeIfAbsent(prefix, p -> {
            HashSet<Supplier> ingredientSet = new HashSet<Supplier>();
            for (String oreName : OreDictionary.getOreNames()) {
                if (!oreName.startsWith((String)p)) continue;
                ingredientSet.add(entries.computeIfAbsent(oreName, name -> new OneTimeSupplier(() -> new OreIngredient(name))));
            }
            return ingredientSet;
        });
        if (matches.isEmpty()) {
            noIngredients.add(prefix);
            return false;
        }
        for (Supplier match : matches) {
            if (!((Ingredient)match.get()).apply(stack)) continue;
            return true;
        }
        return false;
    }
}

