/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.spell;

import epicsquid.mysticallib.network.PacketHandler;
import epicsquid.mysticallib.util.Util;
import epicsquid.roots.config.SpellConfig;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.modifiers.Cost;
import epicsquid.roots.modifiers.CostType;
import epicsquid.roots.modifiers.Modifier;
import epicsquid.roots.modifiers.ModifierCores;
import epicsquid.roots.modifiers.ModifierRegistry;
import epicsquid.roots.modifiers.instance.staff.StaffModifierInstanceList;
import epicsquid.roots.network.fx.MessageSanctuaryBurstFX;
import epicsquid.roots.network.fx.MessageSanctuaryRingFX;
import epicsquid.roots.properties.Property;
import epicsquid.roots.spell.SpellBase;
import epicsquid.roots.util.EntityUtil;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.oredict.OreIngredient;

public class SpellSanctuary
extends SpellBase {
    public static Property.PropertyCooldown PROP_COOLDOWN = new Property.PropertyCooldown(0);
    public static Property.PropertyCastType PROP_CAST_TYPE = new Property.PropertyCastType(SpellBase.EnumCastType.CONTINUOUS);
    public static Property.PropertyCost PROP_COST_1 = new Property.PropertyCost(new SpellBase.SpellCost("pereskia", 0.225));
    public static Property.PropertyCost PROP_COST_2 = new Property.PropertyCost(new SpellBase.SpellCost("wildroot", 0.225));
    public static Property<Float> PROP_VELOCITY = new Property<Float>("push_velocity", Float.valueOf(0.125f)).setDescription("the knockback speed at which entities are pushed away by the spell");
    public static Property<Integer> PROP_RADIUS_X = new Property<Integer>("radius_x", 4).setDescription("the radius on the X axis of the area the spell in which the spell takes effect");
    public static Property<Integer> PROP_RADIUS_Y = new Property<Integer>("radius_y", 5).setDescription("the radius on the Y axis of the area the spell in which the spell takes effect");
    public static Property<Integer> PROP_RADIUS_Z = new Property<Integer>("radius_z", 4).setDescription("the radius on the Z axis of the area the spell in which the spell takes effect");
    public static Property<Integer> PROP_RADIUS_BOOST = new Property<Integer>("radius_boost", 3).setDescription("how much is added to the size of the circle");
    public static Property<Integer> PROP_FIRE_DURATION = new Property<Integer>("fire_duration", 4).setDescription("the duration that creatures knocked back are set on fire for");
    public static Property<Integer> PROP_LEVITATION_DURATION = new Property<Integer>("levitate_duration", 120).setDescription("how long the levitation effect should be applied for");
    public static Property<Integer> PROP_WITHER_DURATION = new Property<Integer>("wither_duration", 80).setDescription("how long the wither duration should be applied for");
    public static Property<Integer> PROP_WITHER_AMPLIFIER = new Property<Integer>("wither_amplifier", 0).setDescription("the amplifier for the wither effect");
    public static Property<Float> PROP_SPIDER_DAMAGE = new Property<Float>("spider_damage", Float.valueOf(4.0f)).setDescription("how much damage is dealt to arachnids");
    public static Property<Float> PROP_UNDEAD_DAMAGE = new Property<Float>("undead_damage", Float.valueOf(3.0f)).setDescription("how much damage is dealt to undead");
    public static Modifier UNPEACEFUL = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "reject_nature"), ModifierCores.WILDEWHEET, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.WILDEWHEET, 0.125)));
    public static Modifier WITHER = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "withering"), ModifierCores.MOONGLOW_LEAF, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.MOONGLOW_LEAF, 0.375)));
    public static Modifier UNDEAD = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "undead_rejection"), ModifierCores.SPIRIT_HERB, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.SPIRIT_HERB, 0.375)));
    public static Modifier KNOCKBACK1 = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "repulsive_bubble"), ModifierCores.TERRA_MOSS, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.TERRA_MOSS, 0.375)));
    public static Modifier SPIDER = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "spider_unsuffrage"), ModifierCores.BAFFLE_CAP, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.BAFFLE_CAP, 0.375)));
    public static Modifier LEVITATE = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "levitating_bubble"), ModifierCores.CLOUD_BERRY, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.CLOUD_BERRY, 0.125)));
    public static Modifier FIRE = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "inflammatory_bubble"), ModifierCores.INFERNAL_BULB, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.INFERNAL_BULB, 0.125)));
    public static Modifier RADIUS = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "earthen_radius"), ModifierCores.STALICRIPE, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.STALICRIPE, 0.275)));
    public static Modifier KNOCKBACK2 = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "liquid_repulsion"), ModifierCores.DEWGONIA, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.DEWGONIA, 0.125)));
    public static ResourceLocation spellName = new ResourceLocation("roots", "spell_sanctuary");
    public static SpellSanctuary instance = new SpellSanctuary(spellName);
    private float velocity;
    private float spider_damage;
    private float undead_damage;
    public int radius_x;
    public int radius_y;
    public int radius_z;
    public int radius_boost;
    private int fire_duration;
    private int levitation_duration;
    private int wither_duration;
    private int wither_amplifier;

    public SpellSanctuary(ResourceLocation name) {
        super(name, TextFormatting.DARK_PURPLE, 0.8156863f, 0.0627451f, 0.3137255f, 0.8784314f, 0.1254902f, 0.5647059f);
        this.properties.add(PROP_COOLDOWN, PROP_CAST_TYPE, PROP_COST_1, PROP_COST_2, PROP_VELOCITY, PROP_RADIUS_X, PROP_RADIUS_Y, PROP_RADIUS_Z, PROP_RADIUS_BOOST, PROP_FIRE_DURATION, PROP_LEVITATION_DURATION, PROP_WITHER_AMPLIFIER, PROP_WITHER_DURATION, PROP_SPIDER_DAMAGE, PROP_UNDEAD_DAMAGE);
        this.acceptModifiers(UNPEACEFUL, WITHER, UNDEAD, KNOCKBACK1, SPIDER, LEVITATE, FIRE, RADIUS, KNOCKBACK2);
    }

    @Override
    public void init() {
        this.addIngredients(new ItemStack((Item)Items.field_179565_cj), new ItemStack(ModItems.pereskia), new ItemStack(Items.field_151054_z), new ItemStack(ModItems.bark_spruce), new OreIngredient("wildroot"));
    }

    @Override
    public boolean cast(EntityPlayer player, StaffModifierInstanceList info, int ticks) {
        int x = this.radius_x;
        int y = this.radius_y;
        int z = this.radius_z;
        if (info.has(RADIUS)) {
            x += this.radius_boost;
            y += this.radius_boost;
            z += this.radius_boost;
        }
        int r = 1 + x + z;
        float v = this.velocity;
        if (info.has(KNOCKBACK1)) {
            v *= 2.0f;
        }
        if (info.has(KNOCKBACK2)) {
            v *= 2.0f;
        }
        List entities = Util.getEntitiesWithinRadius((World)player.field_70170_p, Entity.class, (BlockPos)player.func_180425_c(), (float)x, (float)y, (float)z);
        for (Entity e : entities) {
            if (e == player) continue;
            boolean reject = false;
            if (e instanceof IProjectile) {
                reject = true;
            } else if (EntityUtil.isHostile(e, instance)) {
                reject = true;
            } else if (info.has(UNPEACEFUL) && EntityUtil.isFriendly(e, instance)) {
                reject = true;
            } else if (SpellConfig.spellFeaturesCategory.getSanctuaryBlacklist().contains(EntityList.func_191301_a((Entity)e))) {
                reject = true;
            }
            if (!reject || !(e.func_70068_e((Entity)player) < (double)r)) continue;
            e.field_70159_w = (double)v * (e.field_70165_t - player.field_70165_t);
            e.field_70181_x = (double)v * (e.field_70163_u - player.field_70163_u);
            e.field_70179_y = (double)v * (e.field_70161_v - player.field_70161_v);
            e.field_70133_I = true;
            if (!e.func_82150_aj()) {
                PacketHandler.sendToAllTracking((IMessage)new MessageSanctuaryBurstFX(e.field_70165_t, e.field_70163_u + (double)(0.6f * e.func_70047_e()), e.field_70161_v), (Entity)e);
            }
            if (e instanceof EntityLivingBase) {
                if (info.has(SPIDER) && ((EntityLivingBase)e).func_70668_bt() == EnumCreatureAttribute.ARTHROPOD) {
                    e.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)player), this.spider_damage);
                }
                if (info.has(WITHER)) {
                    ((EntityLivingBase)e).func_70690_d(new PotionEffect(MobEffects.field_82731_v, this.wither_duration, this.wither_amplifier));
                }
                if (info.has(LEVITATE)) {
                    ((EntityLivingBase)e).func_70690_d(new PotionEffect(MobEffects.field_188424_y, this.levitation_duration, 0));
                }
                if (info.has(UNDEAD) && ((EntityLivingBase)e).func_70662_br()) {
                    e.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)player), this.undead_damage);
                }
            }
            if (!info.has(FIRE)) continue;
            e.func_70015_d(this.fire_duration);
        }
        if (player.field_70173_aa % 2 == 0) {
            PacketHandler.sendToAllTracking((IMessage)new MessageSanctuaryRingFX(player.field_70165_t, player.field_70163_u + 0.875, player.field_70161_v, info), (Entity)player);
        }
        return true;
    }

    @Override
    public void doFinalise() {
        this.castType = this.properties.get(PROP_CAST_TYPE);
        this.cooldown = this.properties.get(PROP_COOLDOWN);
        this.radius_x = this.properties.get(PROP_RADIUS_X);
        this.radius_y = this.properties.get(PROP_RADIUS_Y);
        this.radius_z = this.properties.get(PROP_RADIUS_Z);
        this.velocity = this.properties.get(PROP_VELOCITY).floatValue();
        this.radius_boost = this.properties.get(PROP_RADIUS_BOOST);
        this.spider_damage = this.properties.get(PROP_SPIDER_DAMAGE).floatValue();
        this.fire_duration = this.properties.get(PROP_FIRE_DURATION);
        this.levitation_duration = this.properties.get(PROP_LEVITATION_DURATION);
        this.wither_amplifier = this.properties.get(PROP_WITHER_AMPLIFIER);
        this.wither_duration = this.properties.get(PROP_WITHER_DURATION);
        this.undead_damage = this.properties.get(PROP_UNDEAD_DAMAGE).floatValue();
    }
}

